/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.eai.EventWrapper;
import org.web3d.vrml.scripting.external.eai.VRMLNodeFactory;
import vrml.eai.Node;
import vrml.eai.field.EventInMFNode;

class EventInMFNodeWrapper
extends EventInMFNode
implements ExternalEvent,
EventWrapper {
    private boolean hasStoredValue;
    private boolean isSet1Value;
    private VRMLNodeType[] storedValue;
    private int theFieldID;
    private VRMLNodeType theNode;
    private VRMLNodeFactory theNodeFactory;
    private ExternalEventQueue theQueue;

    EventInMFNodeWrapper(VRMLNodeType vRMLNodeType, int n, VRMLNodeFactory vRMLNodeFactory, ExternalEventQueue externalEventQueue) {
        this.fieldType = 15;
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
        this.theNodeFactory = vRMLNodeFactory;
        this.theQueue = externalEventQueue;
    }

    EventInMFNodeWrapper(VRMLNodeType vRMLNodeType, int n, VRMLNodeFactory vRMLNodeFactory, ExternalEventQueue externalEventQueue, Node[] nodeArray) {
        this(vRMLNodeType, n, vRMLNodeFactory, externalEventQueue);
        this.storeValue(nodeArray);
    }

    EventInMFNodeWrapper(VRMLNodeType vRMLNodeType, int n, VRMLNodeFactory vRMLNodeFactory, ExternalEventQueue externalEventQueue, int n2, Node node) {
        this(vRMLNodeType, n, vRMLNodeFactory, externalEventQueue);
        this.loadValue();
        this.store1Value(n2, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            try {
                this.theNode.setValue(this.theFieldID, this.storedValue, this.storedValue.length);
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                for (int i = 0; i < this.storedValue.length; ++i) {
                    this.storedValue[i] = null;
                }
                this.isSet1Value = false;
                this.hasStoredValue = false;
                throw throwable;
            }
            for (int i = 0; i < this.storedValue.length; ++i) {
                this.storedValue[i] = null;
            }
            this.isSet1Value = false;
            this.hasStoredValue = false;
            {
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException setting EventIn value.", invalidFieldException);
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            throw new RuntimeException("InvalidFieldValueException setting EventIn value.", invalidFieldValueException);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EventWrapper) {
            EventWrapper eventWrapper = (EventWrapper)object;
            return eventWrapper.getFieldNode() == this.theNode && eventWrapper.getFieldID() == this.theFieldID && eventWrapper.getType() == this.getType();
        }
        return super.equals(object);
    }

    public int getFieldID() {
        return this.theFieldID;
    }

    public VRMLNodeType getFieldNode() {
        return this.theNode;
    }

    public Object getUserData() {
        try {
            return this.theNode.getUserData(this.theFieldID);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting user data");
        }
    }

    public int hashCode() {
        return this.theNode.hashCode() + this.theFieldID;
    }

    public boolean isConglomerating() {
        return this.isSet1Value;
    }

    private void loadValue() {
        try {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
            if (this.storedValue == null || this.storedValue.length != vRMLFieldData.numElements) {
                this.storedValue = new VRMLNodeType[vRMLFieldData.numElements];
            }
            System.arraycopy(vRMLFieldData.nodeArrayValue, 0, this.storedValue, 0, vRMLFieldData.numElements);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException Error setting EventIn value.");
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            throw new RuntimeException("InvalidFieldValueException Error setting EventIn value.");
        }
        this.hasStoredValue = true;
    }

    public void setUserData(Object object) {
        try {
            this.theNode.setUserData(this.theFieldID, object);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error setting user data");
        }
    }

    public void setValue(Node[] nodeArray) {
        EventInMFNodeWrapper eventInMFNodeWrapper;
        if (!this.hasStoredValue) {
            eventInMFNodeWrapper = this;
            this.storeValue(nodeArray);
        } else {
            eventInMFNodeWrapper = new EventInMFNodeWrapper(this.theNode, this.theFieldID, this.theNodeFactory, this.theQueue, nodeArray);
        }
        this.theQueue.processEvent(eventInMFNodeWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, Node node) {
        Object object = this.theQueue.eventLock;
        synchronized (object) {
            EventInMFNodeWrapper eventInMFNodeWrapper = (EventInMFNodeWrapper)this.theQueue.getLast(this);
            if (eventInMFNodeWrapper == null || !eventInMFNodeWrapper.isSet1Value) {
                if (!this.hasStoredValue) {
                    eventInMFNodeWrapper = this;
                    this.loadValue();
                    this.store1Value(n, node);
                } else {
                    eventInMFNodeWrapper = new EventInMFNodeWrapper(this.theNode, this.theFieldID, this.theNodeFactory, this.theQueue, n, node);
                }
                this.theQueue.processEvent(eventInMFNodeWrapper);
            } else {
                eventInMFNodeWrapper.store1Value(n, node);
            }
        }
    }

    private void storeValue(Node[] nodeArray) {
        this.hasStoredValue = true;
        if (nodeArray != null) {
            if (this.storedValue == null || nodeArray.length != this.storedValue.length) {
                this.storedValue = new VRMLNodeType[nodeArray.length];
            }
            for (int i = 0; i < nodeArray.length; ++i) {
                this.storedValue[i] = this.theNodeFactory.getVRMLNode(nodeArray[i]);
            }
        } else {
            this.storedValue = null;
        }
    }

    private void store1Value(int n, Node node) {
        this.isSet1Value = true;
        this.storedValue[n] = this.theNodeFactory.getVRMLNode(node);
    }
}

