/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.eai.EventWrapper;
import vrml.eai.field.EventInMFString;

class EventInMFStringWrapper
extends EventInMFString
implements ExternalEvent,
EventWrapper {
    boolean hasStoredValue;
    boolean isSet1Value;
    String[] storedValue;
    int theFieldID;
    VRMLNodeType theNode;
    ExternalEventQueue theQueue;

    EventInMFStringWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue) {
        this.fieldType = 17;
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
        this.theQueue = externalEventQueue;
    }

    EventInMFStringWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, String[] stringArray) {
        this(vRMLNodeType, n, externalEventQueue);
        this.storeValue(stringArray);
    }

    EventInMFStringWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, int n2, String string) {
        this(vRMLNodeType, n, externalEventQueue);
        this.loadValue();
        this.store1Value(n2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            try {
                this.theNode.setValue(this.theFieldID, this.storedValue, this.storedValue.length);
            }
            finally {
                this.isSet1Value = false;
                this.hasStoredValue = false;
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException setting EventIn value.", invalidFieldException);
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            throw new RuntimeException("InvalidFieldValueException setting EventIn value.", invalidFieldValueException);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EventWrapper) {
            EventWrapper eventWrapper = (EventWrapper)object;
            return eventWrapper.getFieldNode() == this.theNode && eventWrapper.getFieldID() == this.theFieldID && eventWrapper.getType() == this.getType();
        }
        return super.equals(object);
    }

    public int getFieldID() {
        return this.theFieldID;
    }

    public VRMLNodeType getFieldNode() {
        return this.theNode;
    }

    public Object getUserData() {
        try {
            return this.theNode.getUserData(this.theFieldID);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting user data");
        }
    }

    public int hashCode() {
        return this.theNode.hashCode() + this.theFieldID;
    }

    public boolean isConglomerating() {
        return this.isSet1Value;
    }

    private void loadValue() {
        try {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
            if (this.storedValue == null || this.storedValue.length != vRMLFieldData.numElements) {
                this.storedValue = new String[vRMLFieldData.numElements];
            }
            System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.storedValue, 0, vRMLFieldData.numElements);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException Error setting EventIn value.");
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            throw new RuntimeException("InvalidFieldValueException Error setting EventIn value.");
        }
        this.hasStoredValue = true;
    }

    public void setUserData(Object object) {
        try {
            this.theNode.setUserData(this.theFieldID, object);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error setting user data");
        }
    }

    public void setValue(String[] stringArray) {
        EventInMFStringWrapper eventInMFStringWrapper;
        if (!this.hasStoredValue) {
            eventInMFStringWrapper = this;
            this.storeValue(stringArray);
        } else {
            eventInMFStringWrapper = new EventInMFStringWrapper(this.theNode, this.theFieldID, this.theQueue, stringArray);
        }
        this.theQueue.processEvent(eventInMFStringWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, String string) {
        Object object = this.theQueue.eventLock;
        synchronized (object) {
            EventInMFStringWrapper eventInMFStringWrapper = (EventInMFStringWrapper)this.theQueue.getLast(this);
            if (eventInMFStringWrapper == null || !eventInMFStringWrapper.isSet1Value) {
                if (!this.hasStoredValue) {
                    eventInMFStringWrapper = this;
                    this.loadValue();
                    this.store1Value(n, string);
                } else {
                    eventInMFStringWrapper = new EventInMFStringWrapper(this.theNode, this.theFieldID, this.theQueue, n, string);
                }
                this.theQueue.processEvent(eventInMFStringWrapper);
            } else {
                eventInMFStringWrapper.store1Value(n, string);
            }
        }
    }

    private void storeValue(String[] stringArray) {
        this.hasStoredValue = true;
        if (stringArray != null) {
            if (this.storedValue == null || this.storedValue.length != stringArray.length) {
                this.storedValue = new String[stringArray.length];
            }
            System.arraycopy(stringArray, 0, this.storedValue, 0, stringArray.length);
        } else {
            stringArray = null;
        }
    }

    private void store1Value(int n, String string) {
        this.isSet1Value = true;
        this.storedValue[n] = string;
    }
}

