/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.eai.EventWrapper;
import org.web3d.vrml.scripting.external.eai.VRMLNodeFactory;
import vrml.eai.Node;
import vrml.eai.field.EventInSFNode;

class EventInSFNodeWrapper
extends EventInSFNode
implements ExternalEvent,
EventWrapper {
    boolean hasStoredValue;
    VRMLNodeType storedValue;
    int theFieldID;
    VRMLNodeType theNode;
    VRMLNodeFactory theNodeFactory;
    ExternalEventQueue theQueue;

    EventInSFNodeWrapper(VRMLNodeType vRMLNodeType, int n, VRMLNodeFactory vRMLNodeFactory, ExternalEventQueue externalEventQueue) {
        this.fieldType = 6;
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
        this.theNodeFactory = vRMLNodeFactory;
        this.theQueue = externalEventQueue;
    }

    EventInSFNodeWrapper(VRMLNodeType vRMLNodeType, int n, VRMLNodeFactory vRMLNodeFactory, ExternalEventQueue externalEventQueue, Node node) {
        this(vRMLNodeType, n, vRMLNodeFactory, externalEventQueue);
        this.storeValue(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            try {
                this.theNode.setValue(this.theFieldID, this.storedValue);
            }
            finally {
                this.storedValue = null;
                this.hasStoredValue = false;
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException setting EventIn value.", invalidFieldException);
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            throw new RuntimeException("InvalidFieldValueException setting EventIn value.", invalidFieldValueException);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EventWrapper) {
            EventWrapper eventWrapper = (EventWrapper)object;
            return eventWrapper.getFieldNode() == this.theNode && eventWrapper.getFieldID() == this.theFieldID && eventWrapper.getType() == this.getType();
        }
        return super.equals(object);
    }

    public int getFieldID() {
        return this.theFieldID;
    }

    public VRMLNodeType getFieldNode() {
        return this.theNode;
    }

    public Object getUserData() {
        try {
            return this.theNode.getUserData(this.theFieldID);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting user data");
        }
    }

    public int hashCode() {
        return this.theNode.hashCode() + this.theFieldID;
    }

    public boolean isConglomerating() {
        return false;
    }

    public void setUserData(Object object) {
        try {
            this.theNode.setUserData(this.theFieldID, object);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error setting user data");
        }
    }

    public void setValue(Node node) {
        EventInSFNodeWrapper eventInSFNodeWrapper;
        if (!this.hasStoredValue) {
            eventInSFNodeWrapper = this;
            this.storeValue(node);
        } else {
            eventInSFNodeWrapper = new EventInSFNodeWrapper(this.theNode, this.theFieldID, this.theNodeFactory, this.theQueue, node);
        }
        this.theQueue.processEvent(eventInSFNodeWrapper);
    }

    private void storeValue(Node node) {
        this.hasStoredValue = true;
        this.storedValue = this.theNodeFactory.getVRMLNode(node);
    }
}

