/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.eai.EventWrapper;
import vrml.eai.field.EventInSFVec3f;

class EventInSFVec3fWrapper
extends EventInSFVec3f
implements ExternalEvent,
EventWrapper {
    boolean hasStoredValue;
    float[] storedValue;
    int theFieldID;
    VRMLNodeType theNode;
    ExternalEventQueue theQueue;

    EventInSFVec3fWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue) {
        this.fieldType = 11;
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
        this.theQueue = externalEventQueue;
        this.storedValue = new float[3];
    }

    EventInSFVec3fWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, float[] fArray) {
        this(vRMLNodeType, n, externalEventQueue);
        this.storeValue(fArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            try {
                this.theNode.setValue(this.theFieldID, this.storedValue, 3);
            }
            finally {
                this.hasStoredValue = false;
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException setting EventIn value.", invalidFieldException);
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            throw new RuntimeException("InvalidFieldValueException setting EventIn value.", invalidFieldValueException);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EventWrapper) {
            EventWrapper eventWrapper = (EventWrapper)object;
            return eventWrapper.getFieldNode() == this.theNode && eventWrapper.getFieldID() == this.theFieldID && eventWrapper.getType() == this.getType();
        }
        return super.equals(object);
    }

    public int getFieldID() {
        return this.theFieldID;
    }

    public VRMLNodeType getFieldNode() {
        return this.theNode;
    }

    public Object getUserData() {
        try {
            return this.theNode.getUserData(this.theFieldID);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting user data");
        }
    }

    public int hashCode() {
        return this.theNode.hashCode() + this.theFieldID;
    }

    public boolean isConglomerating() {
        return false;
    }

    public void setUserData(Object object) {
        try {
            this.theNode.setUserData(this.theFieldID, object);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error setting user data");
        }
    }

    public void setValue(float[] fArray) {
        EventInSFVec3fWrapper eventInSFVec3fWrapper;
        if (!this.hasStoredValue) {
            eventInSFVec3fWrapper = this;
            this.storeValue(fArray);
        } else {
            eventInSFVec3fWrapper = new EventInSFVec3fWrapper(this.theNode, this.theFieldID, this.theQueue, fArray);
        }
        this.theQueue.processEvent(eventInSFVec3fWrapper);
    }

    private void storeValue(float[] fArray) {
        this.hasStoredValue = true;
        System.arraycopy(fArray, 0, this.storedValue, 0, 3);
    }
}

