/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import org.web3d.util.ArrayUtils;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.eai.EAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.eai.EventWrapper;
import vrml.eai.event.VrmlEventListener;
import vrml.eai.field.EventOutMFColor;

class EventOutMFColorWrapper
extends EventOutMFColor
implements ExternalOutputBuffer,
EventWrapper {
    boolean isStored;
    int storedSize;
    float[] storedValue;
    EAIEventAdapterFactory theEventAdapterFactory;
    int theFieldID;
    VRMLNodeType theNode;

    EventOutMFColorWrapper(VRMLNodeType vRMLNodeType, int n, EAIEventAdapterFactory eAIEventAdapterFactory, boolean bl) {
        this.fieldType = 12;
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
        this.theEventAdapterFactory = eAIEventAdapterFactory;
        if (bl) {
            this.loadOutputValue();
        }
    }

    public void addVrmlEventListener(VrmlEventListener vrmlEventListener) {
        this.theEventAdapterFactory.getAdapter(this.theNode).addListener(this.theFieldID, vrmlEventListener);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EventWrapper) {
            EventWrapper eventWrapper = (EventWrapper)object;
            return eventWrapper.getFieldNode() == this.theNode && eventWrapper.getFieldID() == this.theFieldID && eventWrapper.getType() == this.getType();
        }
        return super.equals(object);
    }

    public int getFieldID() {
        return this.theFieldID;
    }

    public VRMLNodeType getFieldNode() {
        return this.theNode;
    }

    public Object getUserData() {
        try {
            return this.theNode.getUserData(this.theFieldID);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting user data", invalidFieldException);
        }
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
    }

    public void reset() {
        this.theNode = null;
        this.theFieldID = -1;
        this.isStored = false;
    }

    public void removeVrmlEventListener(VrmlEventListener vrmlEventListener) {
        this.theEventAdapterFactory.getAdapter(this.theNode).removeListener(this.theFieldID, vrmlEventListener);
    }

    public float[] get1Value(int n) {
        float[] fArray = new float[3];
        this.get1Value(n, fArray);
        return fArray;
    }

    public void get1Value(int n, float[] fArray) {
        if (this.isStored) {
            System.arraycopy(this.storedValue, n * 3, fArray, 0, 3);
        } else {
            try {
                VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
                if (n < 0 || n >= vRMLFieldData.numElements) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(vRMLFieldData.floatArrayValue, n * 3, fArray, 0, 3);
            }
            catch (InvalidFieldException invalidFieldException) {
                throw new RuntimeException("Error getting field value");
            }
        }
    }

    public void getValue(float[][] fArray) {
        if (this.isStored) {
            ArrayUtils.raise3(this.storedValue, this.storedSize, fArray);
        } else {
            try {
                VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
                int n = vRMLFieldData.numElements;
                ArrayUtils.raise3(vRMLFieldData.floatArrayValue, n, fArray);
            }
            catch (InvalidFieldException invalidFieldException) {
                throw new RuntimeException("Error getting field value");
            }
        }
    }

    public float[][] getValue() {
        float[][] fArrayArray = new float[this.size()][];
        for (int i = 0; i < fArrayArray.length; ++i) {
            fArrayArray[i] = new float[3];
        }
        if (this.isStored) {
            ArrayUtils.raise3(this.storedValue, this.storedSize, fArrayArray);
            return fArrayArray;
        }
        try {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
            ArrayUtils.raise3(vRMLFieldData.floatArrayValue, vRMLFieldData.numElements, fArrayArray);
            return fArrayArray;
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException Error getting field value.  Was looking for fieldID" + this.theFieldID + " in a " + this.theNode.getClass().getName() + ".");
        }
    }

    public void getValue(float[] fArray) {
        if (this.isStored) {
            System.arraycopy(this.storedValue, 0, fArray, 0, this.storedValue.length);
        } else {
            try {
                VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, fArray, 0, vRMLFieldData.floatArrayValue.length);
            }
            catch (InvalidFieldException invalidFieldException) {
                throw new RuntimeException("Error getting field value");
            }
        }
    }

    public void loadOutputValue() {
        this.isStored = false;
        this.storedSize = this.size();
        if (this.storedValue == null || this.storedValue.length != this.storedSize * 3) {
            this.storedValue = new float[this.storedSize * 3];
        }
        this.getValue(this.storedValue);
        this.isStored = true;
    }

    public int size() {
        if (this.isStored) {
            return this.storedSize;
        }
        try {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
            return vRMLFieldData.numElements;
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting field size");
        }
    }

    public void setUserData(Object object) {
        try {
            this.theNode.setUserData(this.theFieldID, object);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error setting user data");
        }
    }
}

