/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.eai.EAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.eai.EventWrapper;
import vrml.eai.event.VrmlEventListener;
import vrml.eai.field.EventOutMFString;

class EventOutMFStringWrapper
extends EventOutMFString
implements ExternalOutputBuffer,
EventWrapper {
    boolean isStored;
    String[] storedValue;
    EAIEventAdapterFactory theEventAdapterFactory;
    int theFieldID;
    VRMLNodeType theNode;

    EventOutMFStringWrapper(VRMLNodeType vRMLNodeType, int n, EAIEventAdapterFactory eAIEventAdapterFactory, boolean bl) {
        this.fieldType = 17;
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
        this.theEventAdapterFactory = eAIEventAdapterFactory;
        if (bl) {
            this.loadOutputValue();
        }
    }

    public void addVrmlEventListener(VrmlEventListener vrmlEventListener) {
        this.theEventAdapterFactory.getAdapter(this.theNode).addListener(this.theFieldID, vrmlEventListener);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EventWrapper) {
            EventWrapper eventWrapper = (EventWrapper)object;
            return eventWrapper.getFieldNode() == this.theNode && eventWrapper.getFieldID() == this.theFieldID && eventWrapper.getType() == this.getType();
        }
        return super.equals(object);
    }

    public int getFieldID() {
        return this.theFieldID;
    }

    public VRMLNodeType getFieldNode() {
        return this.theNode;
    }

    public Object getUserData() {
        try {
            return this.theNode.getUserData(this.theFieldID);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting user data", invalidFieldException);
        }
    }

    public String get1Value(int n) {
        if (this.isStored) {
            return this.storedValue[n];
        }
        try {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
            if (n < 0 || n >= vRMLFieldData.numElements) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return vRMLFieldData.stringArrayValue[n];
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting field value");
        }
    }

    public String[] getValue() {
        String[] stringArray = new String[this.size()];
        this.getValue(stringArray);
        return stringArray;
    }

    public void getValue(String[] stringArray) {
        if (this.isStored) {
            System.arraycopy(this.storedValue, 0, stringArray, 0, this.storedValue.length);
        } else {
            try {
                VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
                if (vRMLFieldData.numElements != 0) {
                    System.arraycopy(vRMLFieldData.stringArrayValue, 0, stringArray, 0, vRMLFieldData.numElements);
                }
            }
            catch (InvalidFieldException invalidFieldException) {
                throw new RuntimeException("Error getting field value.");
            }
        }
    }

    public int hashCode() {
        return this.theNode.hashCode() + this.theFieldID;
    }

    public void loadOutputValue() {
        this.isStored = false;
        int n = this.size();
        if (this.storedValue == null || this.storedValue.length != n) {
            this.storedValue = new String[n];
        }
        this.getValue(this.storedValue);
        this.isStored = true;
    }

    public int size() {
        if (this.isStored) {
            return this.storedValue.length;
        }
        try {
            return this.theNode.getFieldValue((int)this.theFieldID).numElements;
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting field value.");
        }
    }

    public void removeVrmlEventListener(VrmlEventListener vrmlEventListener) {
        this.theEventAdapterFactory.getAdapter(this.theNode).removeListener(this.theFieldID, vrmlEventListener);
    }

    public void setUserData(Object object) {
        try {
            this.theNode.setUserData(this.theFieldID, object);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error setting user data");
        }
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
    }

    public void reset() {
        this.theNode = null;
        this.theFieldID = -1;
        this.isStored = false;
    }
}

