/*
 * Decompiled with CFR 0.152.
 */
package vrml.eai;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import vrml.eai.Browser;
import vrml.eai.BrowserFactoryImpl;
import vrml.eai.ConnectionException;
import vrml.eai.NoSuchBrowserException;
import vrml.eai.NotSupportedException;
import vrml.eai.VrmlComponent;
import vrml.eai.VrmlException;

public class BrowserFactory {
    private static final String PROPERTIES_FILE_NAME = "vrml.properties";
    private static final String XJ3D_PROPERTIES_FILE = "config/2.0/spec/vrml.properties";
    private static final String FACTORY_CLASS = "vrml.eai.factory.class";
    private static final String DEFAULT_FACTORY_CLASS = "vrml.eai.DefaultBrowserImpl";
    private static BrowserFactoryImpl factory = null;
    private static Properties vrml_properties = null;
    static /* synthetic */ Class class$vrml$eai$BrowserFactory;

    private BrowserFactory() {
    }

    public static synchronized void setBrowserFactoryImpl(BrowserFactoryImpl browserFactoryImpl) {
        if (factory != null) {
            throw new VrmlException("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = browserFactoryImpl;
    }

    public static VrmlComponent createVrmlComponent(String[] stringArray) throws NotSupportedException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        VrmlComponent vrmlComponent = factory.createComponent(stringArray);
        return vrmlComponent;
    }

    public static Browser getBrowser(Applet applet) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        return factory.getBrowser(applet);
    }

    public static Browser getBrowser(Applet applet, String string, int n) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        return factory.getBrowser(applet, string, n);
    }

    public static Browser getBrowser(InetAddress inetAddress, int n) throws NotSupportedException, NoSuchBrowserException, UnknownHostException, ConnectionException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        return factory.getBrowser(inetAddress, n);
    }

    private static void loadFactoryImpl() {
        try {
            String string = vrml_properties.getProperty(FACTORY_CLASS, DEFAULT_FACTORY_CLASS);
            Class<?> clazz = Class.forName(string);
            factory = (BrowserFactoryImpl)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Unable to find vrml browser factory implementation\n" + classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            System.out.println("Error instantiating the vrml browser factory " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            System.out.println("The nominated browser factory is not an instance of vrml.eai.BrowserFactoryImpl");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        vrml_properties = new Properties();
        try {
            InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ClassLoader.getSystemResourceAsStream(BrowserFactory.PROPERTIES_FILE_NAME);
                }
            });
            if (inputStream == null) {
                inputStream = (class$vrml$eai$BrowserFactory == null ? (class$vrml$eai$BrowserFactory = BrowserFactory.class$("vrml.eai.BrowserFactory")) : class$vrml$eai$BrowserFactory).getClassLoader().getResourceAsStream(PROPERTIES_FILE_NAME);
            }
            if (inputStream == null) {
                inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ClassLoader.getSystemResourceAsStream(BrowserFactory.XJ3D_PROPERTIES_FILE);
                    }
                });
            }
            if (inputStream == null) {
                inputStream = (class$vrml$eai$BrowserFactory == null ? (class$vrml$eai$BrowserFactory = BrowserFactory.class$("vrml.eai.BrowserFactory")) : class$vrml$eai$BrowserFactory).getClassLoader().getResourceAsStream(XJ3D_PROPERTIES_FILE);
            }
            if (inputStream == null) {
                vrml_properties.put(FACTORY_CLASS, DEFAULT_FACTORY_CLASS);
            } else {
                vrml_properties.load(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }
}

