/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.oplimits;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.OperationLimits;
import pt.lsts.neptus.plugins.oplimits.RectangleEditor;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.ParallelepipedElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.GuiUtils;

public class OperationLimitsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected OperationLimits limits;
    JCheckBox minSpeedCheck;
    JCheckBox maxSpeedCheck;
    JCheckBox minAltitudeCheck;
    JCheckBox maxAltitudeCheck;
    JCheckBox areaCheck;
    JCheckBox maxDepthCheck;
    JCheckBox maxVRateCheck;
    JFormattedTextField minSpeedField;
    JFormattedTextField maxSpeedField;
    JFormattedTextField minAltitudeField;
    JFormattedTextField maxAltitudeField;
    JFormattedTextField maxDepthField;
    JFormattedTextField maxVRateField;
    MissionType mt = null;

    public OperationLimitsPanel(MissionType mt, boolean editArea) {
        this.mt = mt;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BoxLayout(this, 1));
        this.maxDepthCheck = new JCheckBox(I18n.text((String)"Maximum Depth (m)"));
        this.minAltitudeCheck = new JCheckBox(I18n.text((String)"Minimum Altitude (m)"));
        this.maxAltitudeCheck = new JCheckBox(I18n.text((String)"Maximum Altitude (m)"));
        this.minSpeedCheck = new JCheckBox(I18n.text((String)"Minimum Speed (m/s)"));
        this.maxSpeedCheck = new JCheckBox(I18n.text((String)"Maximum Speed (m/s)"));
        this.areaCheck = new JCheckBox(I18n.text((String)"Area Limits"));
        this.maxVRateCheck = new JCheckBox(I18n.text((String)"Maximum Vertical Rate (m/s)"));
        this.maxDepthField = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat((int)1));
        this.maxAltitudeField = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat((int)1));
        this.minAltitudeField = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat((int)1));
        this.maxSpeedField = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat((int)1));
        this.minSpeedField = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat((int)1));
        this.maxVRateField = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat((int)1));
        JPanel tmp = new JPanel(new GridLayout(0, 2, 2, 10));
        tmp.add(this.maxDepthCheck);
        tmp.add(this.maxDepthField);
        tmp.add(this.maxAltitudeCheck);
        tmp.add(this.maxAltitudeField);
        tmp.add(this.minAltitudeCheck);
        tmp.add(this.minAltitudeField);
        tmp.add(this.maxSpeedCheck);
        tmp.add(this.maxSpeedField);
        tmp.add(this.minSpeedCheck);
        tmp.add(this.minSpeedField);
        tmp.add(this.maxVRateCheck);
        tmp.add(this.maxVRateField);
        tmp.add(this.areaCheck);
        JButton b = new JButton(I18n.text((String)"Select..."));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParallelepipedElement rectangle;
                RectangleEditor editor = new RectangleEditor(OperationLimitsPanel.this.mt);
                if (OperationLimitsPanel.this.limits.getOpAreaLat() != null) {
                    editor.pp = new ParallelepipedElement(MapGroup.getMapGroupInstance((MissionType)OperationLimitsPanel.this.mt), null);
                    editor.pp.setWidth(OperationLimitsPanel.this.limits.getOpAreaWidth().doubleValue());
                    editor.pp.setLength(OperationLimitsPanel.this.limits.getOpAreaLength().doubleValue());
                    editor.pp.setYawDeg(Math.toDegrees(OperationLimitsPanel.this.limits.getOpRotationRads()));
                    LocationType lt = new LocationType();
                    lt.setLatitudeDegs(OperationLimitsPanel.this.limits.getOpAreaLat().doubleValue());
                    lt.setLongitudeDegs(OperationLimitsPanel.this.limits.getOpAreaLon().doubleValue());
                    editor.pp.setCenterLocation(lt);
                    editor.pp.setMyColor(Color.red);
                    editor.btnOk.setEnabled(true);
                }
                if ((rectangle = editor.showDialog(OperationLimitsPanel.this)) != null) {
                    double[] lld = rectangle.getCenterLocation().getAbsoluteLatLonDepth();
                    OperationLimitsPanel.this.limits.setOpAreaLat(Double.valueOf(lld[0]));
                    OperationLimitsPanel.this.limits.setOpAreaLon(Double.valueOf(lld[1]));
                    OperationLimitsPanel.this.limits.setOpAreaLength(Double.valueOf(rectangle.getLength()));
                    OperationLimitsPanel.this.limits.setOpAreaWidth(Double.valueOf(rectangle.getWidth()));
                    OperationLimitsPanel.this.limits.setOpRotationRads(Double.valueOf(rectangle.getYawRad()));
                }
            }
        });
        tmp.add(b);
        if (!editArea) {
            b.setEnabled(false);
        }
        this.add(tmp);
    }

    public void setLimits(OperationLimits limits) {
        this.limits = limits;
        this.minSpeedCheck.setSelected(limits.getMinSpeed() != null);
        this.maxSpeedCheck.setSelected(limits.getMaxSpeed() != null);
        this.minAltitudeCheck.setSelected(limits.getMinAltitude() != null);
        this.maxAltitudeCheck.setSelected(limits.getMaxAltitude() != null);
        this.maxDepthCheck.setSelected(limits.getMaxDepth() != null);
        this.areaCheck.setSelected(limits.getOpAreaLat() != null);
        this.maxVRateCheck.setSelected(limits.getMaxVertRate() != null);
        this.minSpeedField.setText(limits.getMinSpeed() == null ? "" : "" + limits.getMinSpeed());
        this.maxSpeedField.setText(limits.getMaxSpeed() == null ? "" : "" + limits.getMaxSpeed());
        this.minAltitudeField.setText(limits.getMinAltitude() == null ? "" : "" + limits.getMinAltitude());
        this.maxAltitudeField.setText(limits.getMaxAltitude() == null ? "" : "" + limits.getMaxAltitude());
        this.maxDepthField.setText(limits.getMaxDepth() == null ? "" : "" + limits.getMaxDepth());
        this.maxVRateField.setText(limits.getMaxVertRate() == null ? "" : "" + limits.getMaxVertRate());
    }

    public OperationLimits getLimits() {
        if (this.minSpeedCheck.isSelected()) {
            this.limits.setMinSpeed(Double.valueOf(this.minSpeedField.getText()));
        } else {
            this.limits.setMinSpeed(null);
        }
        if (this.maxSpeedCheck.isSelected()) {
            this.limits.setMaxSpeed(Double.valueOf(this.maxSpeedField.getText()));
        } else {
            this.limits.setMaxSpeed(null);
        }
        if (this.minAltitudeCheck.isSelected()) {
            this.limits.setMinAltitude(Double.valueOf(this.minAltitudeField.getText()));
        } else {
            this.limits.setMinAltitude(null);
        }
        if (this.maxAltitudeCheck.isSelected()) {
            this.limits.setMaxAltitude(Double.valueOf(this.maxAltitudeField.getText()));
        } else {
            this.limits.setMaxAltitude(null);
        }
        if (this.maxVRateCheck.isSelected()) {
            this.limits.setMaxVertRate(Double.valueOf(this.maxVRateField.getText()));
        } else {
            this.limits.setMaxVertRate(null);
        }
        if (this.maxDepthCheck.isSelected()) {
            this.limits.setMaxDepth(Double.valueOf(this.maxDepthField.getText()));
        } else {
            this.limits.setMaxDepth(null);
        }
        if (!this.areaCheck.isSelected()) {
            this.limits.setOpAreaLat(null);
            this.limits.setOpAreaLon(null);
            this.limits.setOpAreaLength(null);
            this.limits.setOpAreaWidth(null);
            this.limits.setOpRotationRads(null);
        }
        return this.limits;
    }

    public static void main(String[] args) {
        GuiUtils.setLookAndFeel();
        OperationLimits limits = new OperationLimits();
        limits.setMaxSpeed(Double.valueOf(100.0));
        OperationLimitsPanel panel = new OperationLimitsPanel(new MissionType(), true);
        panel.setLimits(limits);
        GuiUtils.testFrame((JComponent)panel);
    }
}

