/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.oplimits;

import com.google.common.eventbus.Subscribe;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import pt.lsts.imc.GetOperationalLimits;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.OperationalLimits;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.OperationLimits;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.oplimits.OperationLimitsPanel;
import pt.lsts.neptus.plugins.oplimits.RectangleEditor;
import pt.lsts.neptus.renderer2d.CustomInteractionSupport;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.ParallelepipedElement;
import pt.lsts.neptus.types.map.PathElement;
import pt.lsts.neptus.util.ByteUtil;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;

@PluginDescription(name="Operation Limits", category=PluginDescription.CATEGORY.PLANNING, icon="pt/lsts/neptus/plugins/oplimits/lock.png", documentation="oplimits/oplimits.html")
public class OperationLimitsSubPanel
extends ConsolePanel
implements ConfigurationListener,
MainVehicleChangeListener,
NeptusMessageListener,
Renderer2DPainter,
StateRendererInteraction {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Operation Limits File", description="Where to store and load operational limits")
    public File operationLimitsFile = new File(".", "conf/oplimits.xml");
    @NeptusProperty(name="Separate Operational Areas Per Vehicle", description="If selected, each vehicle will have its own operational limits file")
    public boolean separateOpAreas = true;
    @NeptusProperty
    public boolean showOnMap = true;
    protected byte[] lastMD5 = null;
    protected OperationLimits limits = null;
    protected ToolbarSwitch sw;
    protected InteractionAdapter adapter = new InteractionAdapter(null);
    protected AbstractAction updateAction;
    protected AbstractAction editLimits;
    protected AbstractAction sendAction;
    protected AbstractAction showOpArea;
    protected AbstractAction clearRect;
    protected boolean editing = false;
    protected PathElement rectangle = null;
    protected ParallelepipedElement pp = null;
    protected ParallelepipedElement selection = null;
    protected JDialog parentDialog = null;
    protected LocationType[] points = new LocationType[4];
    protected int clickCount = 0;
    protected Point2D lastDragPoint = null;
    protected boolean dragging = false;
    protected JLabel label = new JLabel("<html></html>");

    protected void createActions() {
        this.editLimits = new AbstractAction(I18n.text((String)"Operation Limits"), ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/oplimits/edit.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OperationLimitsPanel panel = new OperationLimitsPanel(OperationLimitsSubPanel.this.getConsole().getMission(), true);
                OperationLimits before = OperationLimits.loadXml((String)OperationLimitsSubPanel.this.limits.asXml());
                panel.setLimits(OperationLimitsSubPanel.this.limits);
                final JDialog dialog = new JDialog((Frame)OperationLimitsSubPanel.this.getConsole(), I18n.text((String)"Set Operation Limits"));
                dialog.getContentPane().setLayout(new BorderLayout());
                dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                dialog.add(panel);
                JButton okButton = new JButton(new AbstractAction(I18n.text((String)"Ok")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.dispose();
                    }
                });
                GuiUtils.reactEnterKeyPress((JButton)okButton);
                dialog.getContentPane().add((Component)okButton, "South");
                dialog.pack();
                GuiUtils.centerParent((Window)dialog, (Window)OperationLimitsSubPanel.this.getConsole());
                dialog.setVisible(true);
                int resp = JOptionPane.showConfirmDialog((Component)OperationLimitsSubPanel.this.getConsole(), I18n.text((String)"Do you want to save changes?"), I18n.text((String)"Operation Limits"), 0);
                if (resp == 0) {
                    OperationLimitsSubPanel.this.limits = panel.getLimits();
                    OperationLimitsSubPanel.this.storeXml(OperationLimitsSubPanel.this.limits.asXml());
                    OperationLimitsSubPanel.this.updateAction.putValue("SmallIcon", ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/oplimits/update_request.png"));
                    OperationLimitsSubPanel.this.updateAction.putValue("ShortDescription", I18n.text((String)"Local operational limits have changes"));
                    if (OperationLimitsSubPanel.this.editing) {
                        OperationLimitsSubPanel.this.setActive(true, null);
                    }
                } else {
                    OperationLimitsSubPanel.this.limits.setOpAreaLat(before.getOpAreaLat());
                    OperationLimitsSubPanel.this.limits.setOpAreaLon(before.getOpAreaLon());
                    OperationLimitsSubPanel.this.limits.setOpAreaLength(before.getOpAreaLength());
                    OperationLimitsSubPanel.this.limits.setOpAreaWidth(before.getOpAreaWidth());
                    OperationLimitsSubPanel.this.limits.setOpRotationRads(before.getOpRotationRads());
                }
            }
        };
        this.sendAction = new AbstractAction(I18n.text((String)"Send to Vehicle"), ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/oplimits/up.png")){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                OperationalLimits msg = OperationLimitsSubPanel.this.getLimitsMessage();
                OperationLimitsSubPanel operationLimitsSubPanel = OperationLimitsSubPanel.this;
                synchronized (operationLimitsSubPanel) {
                    OperationLimitsSubPanel.this.lastMD5 = msg.payloadMD5();
                    OperationLimitsSubPanel.this.send((IMCMessage)msg);
                    OperationLimitsSubPanel.this.send((IMCMessage)new GetOperationalLimits());
                }
            }
        };
        this.updateAction = new AbstractAction(I18n.text((String)"Download limits from vehicle"), ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/oplimits/update_ok.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OperationLimitsSubPanel.this.updateAction.putValue("SmallIcon", ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/oplimits/update_request.png"));
                OperationLimitsSubPanel.this.updateAction.putValue("ShortDescription", I18n.text((String)"Request sent but limits not yet received"));
                OperationLimitsSubPanel.this.send(IMCDefinition.getInstance().create("GetOperationalLimits", new Object[0]));
            }
        };
        this.showOpArea = new AbstractAction(I18n.text((String)"Show Operational Area on map"), ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/oplimits/visibility.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OperationLimitsSubPanel.this.showOnMap = ((AbstractButton)e.getSource()).isSelected();
                OperationLimitsSubPanel.this.showOnMap(OperationLimitsSubPanel.this.showOnMap);
            }
        };
        this.clearRect = new AbstractAction(I18n.text((String)"Clear operational area")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OperationLimitsSubPanel.this.pp = null;
                OperationLimitsSubPanel.this.rectangle = null;
                OperationLimitsSubPanel.this.setLimitsFromSelection(OperationLimitsSubPanel.this.pp);
                OperationLimitsSubPanel.this.clickCount = 0;
            }
        };
    }

    protected OperationalLimits getLimitsMessage() {
        long bmask = 0L;
        OperationalLimits oplimits = new OperationalLimits();
        if (this.limits.getMaxDepth() != null) {
            bmask |= 1L;
            oplimits.setMaxDepth(this.limits.getMaxDepth().doubleValue());
        }
        if (this.limits.getMaxAltitude() != null) {
            bmask |= 4L;
            oplimits.setMaxAltitude(this.limits.getMaxAltitude().doubleValue());
        }
        if (this.limits.getMinAltitude() != null) {
            bmask |= 2L;
            oplimits.setMinAltitude(this.limits.getMinAltitude().doubleValue());
        }
        if (this.limits.getMaxSpeed() != null) {
            bmask |= 0x10L;
            oplimits.setMaxSpeed(this.limits.getMaxSpeed().doubleValue());
        }
        if (this.limits.getMinSpeed() != null) {
            bmask |= 8L;
            oplimits.setMinSpeed(this.limits.getMinSpeed().doubleValue());
        }
        if (this.limits.getMaxVertRate() != null) {
            bmask |= 0x20L;
            oplimits.setMaxVrate(this.limits.getMaxVertRate().doubleValue());
        }
        if (this.limits.getOpAreaLat() != null) {
            bmask |= 0x40L;
            oplimits.setLat(Math.toRadians(this.limits.getOpAreaLat()));
            oplimits.setLon(Math.toRadians(this.limits.getOpAreaLon()));
            oplimits.setLength(this.limits.getOpAreaLength().doubleValue());
            oplimits.setWidth(this.limits.getOpAreaWidth().doubleValue());
            oplimits.setOrientation(this.limits.getOpRotationRads().doubleValue());
        }
        oplimits.setMask((short)bmask);
        return oplimits;
    }

    public OperationLimitsSubPanel(ConsoleLayout console) {
        super(console);
        this.label.setOpaque(true);
        this.label.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.label.setBackground(new Color(255, 255, 255, 128));
        this.removeAll();
        this.createActions();
        this.setSize(new Dimension(95, 40));
        this.setLayout(new BorderLayout());
        JLabel lbl = new JLabel(I18n.text((String)"Operational Limits"));
        lbl.setFont(new Font("Arial", 1, 6));
        this.add(lbl, "North");
        JPanel tmp = new JPanel();
        tmp.setLayout(new BoxLayout(tmp, 2));
        tmp.add((Component)new ToolbarButton(this.editLimits));
        tmp.add((Component)new ToolbarButton(this.sendAction));
        this.sw = (ToolbarSwitch)tmp.add((Component)new ToolbarSwitch(this.showOpArea));
        this.sw.setSelected(this.showOnMap);
        tmp.add((Component)new ToolbarButton(this.updateAction));
        this.add(tmp, "Center");
    }

    public String[] getObservedMessages() {
        return new String[]{"OperationalLimits"};
    }

    public void messageArrived(IMCMessage message) {
        final IMCMessage msg = message;
        if (message.getMgid() == 504) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    OperationLimitsSubPanel operationLimitsSubPanel = OperationLimitsSubPanel.this;
                    synchronized (operationLimitsSubPanel) {
                        if (OperationLimitsSubPanel.this.lastMD5 != null) {
                            if (!Arrays.equals(msg.payloadMD5(), OperationLimitsSubPanel.this.lastMD5)) {
                                int option = JOptionPane.showConfirmDialog((Component)OperationLimitsSubPanel.this.getConsole(), I18n.text((String)"Replace current operational limits with received ones?"), I18n.text((String)"Operation Limits"), 0);
                                if (option != 0) {
                                    return;
                                }
                            } else {
                                OperationLimitsSubPanel.this.post(Notification.success((String)I18n.text((String)"Operation Limits"), (String)I18n.text((String)"Syncronized")).src(OperationLimitsSubPanel.this.getConsole().getMainSystem()));
                            }
                        }
                    }
                    try {
                        OperationalLimits received = OperationalLimits.clone((IMCMessage)msg);
                        OperationLimitsSubPanel.this.lastMD5 = msg.payloadMD5();
                        if ((received.getMask() & 1) != 0) {
                            OperationLimitsSubPanel.this.limits.setMaxDepth(Double.valueOf(received.getMaxDepth()));
                        } else {
                            OperationLimitsSubPanel.this.limits.setMaxDepth(null);
                        }
                        if ((received.getMask() & 4) != 0) {
                            OperationLimitsSubPanel.this.limits.setMaxAltitude(Double.valueOf(received.getMaxAltitude()));
                        } else {
                            OperationLimitsSubPanel.this.limits.setMaxAltitude(null);
                        }
                        if ((received.getMask() & 2) != 0) {
                            OperationLimitsSubPanel.this.limits.setMinAltitude(Double.valueOf(received.getMinAltitude()));
                        } else {
                            OperationLimitsSubPanel.this.limits.setMinAltitude(null);
                        }
                        if ((received.getMask() & 0x10) != 0) {
                            OperationLimitsSubPanel.this.limits.setMaxSpeed(Double.valueOf(received.getMaxSpeed()));
                        } else {
                            OperationLimitsSubPanel.this.limits.setMaxSpeed(null);
                        }
                        if ((received.getMask() & 8) != 0) {
                            OperationLimitsSubPanel.this.limits.setMinSpeed(Double.valueOf(received.getMinSpeed()));
                        } else {
                            OperationLimitsSubPanel.this.limits.setMinSpeed(null);
                        }
                        if ((received.getMask() & 0x20) != 0) {
                            OperationLimitsSubPanel.this.limits.setMaxVertRate(Double.valueOf(received.getMaxVrate()));
                        } else {
                            OperationLimitsSubPanel.this.limits.setMaxVertRate(null);
                        }
                        if ((received.getMask() & 0x40) != 0) {
                            OperationLimitsSubPanel.this.limits.setOpAreaLat(Double.valueOf(Math.toDegrees(received.getLat())));
                            OperationLimitsSubPanel.this.limits.setOpAreaLon(Double.valueOf(Math.toDegrees(received.getLon())));
                            OperationLimitsSubPanel.this.limits.setOpAreaLength(Double.valueOf(received.getLength()));
                            OperationLimitsSubPanel.this.limits.setOpAreaWidth(Double.valueOf(received.getWidth()));
                            OperationLimitsSubPanel.this.limits.setOpRotationRads(Double.valueOf(received.getOrientation()));
                        } else {
                            OperationLimitsSubPanel.this.limits.setOpAreaLat(null);
                            OperationLimitsSubPanel.this.limits.setOpAreaLon(null);
                            OperationLimitsSubPanel.this.limits.setOpAreaLength(null);
                            OperationLimitsSubPanel.this.limits.setOpAreaWidth(null);
                            OperationLimitsSubPanel.this.limits.setOpRotationRads(null);
                        }
                        OperationLimitsSubPanel.this.pp = OperationLimitsSubPanel.this.getSelectionFromLimits(OperationLimitsSubPanel.this.limits);
                        OperationLimitsSubPanel.this.updateAction.putValue("SmallIcon", ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/oplimits/update_ok.png"));
                        OperationLimitsSubPanel.this.updateAction.putValue("ShortDescription", I18n.text((String)"Download limits from vehicle"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    protected void showOnMap(boolean show) {
        if (show) {
            Vector renders = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
            for (ILayerPainter str2d : renders) {
                str2d.addPostRenderPainter((Renderer2DPainter)this, I18n.text((String)"Operational Limits"));
            }
        } else {
            Vector renders = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
            for (ILayerPainter str2d : renders) {
                str2d.removePostRenderPainter((Renderer2DPainter)this);
            }
        }
    }

    protected boolean storeXml(String xml) {
        if (!this.separateOpAreas && this.operationLimitsFile.canRead()) {
            NeptusLog.pub().info((Object)("<###>saving to " + this.operationLimitsFile.getAbsolutePath()));
            return FileUtil.saveToFile((String)this.operationLimitsFile.getAbsolutePath(), (String)xml);
        }
        if (this.getConsole().getMainSystem() != null) {
            File f = new File("conf/oplimits/" + this.getConsole().getMainSystem() + ".xml");
            f.getParentFile().mkdirs();
            NeptusLog.pub().info((Object)("<###>saving to " + f.getAbsolutePath()));
            return FileUtil.saveToFile((String)f.getAbsolutePath(), (String)xml);
        }
        this.operationLimitsFile = new File("conf/oplimits/limits.xml");
        this.operationLimitsFile.getParentFile().mkdirs();
        NeptusLog.pub().info((Object)("<###>saving to " + this.operationLimitsFile.getAbsolutePath()));
        return FileUtil.saveToFile((String)this.operationLimitsFile.getAbsolutePath(), (String)xml);
    }

    protected String getOpLimitsXml() {
        File f;
        if (!this.separateOpAreas && this.operationLimitsFile.canRead()) {
            return FileUtil.getFileAsString((String)this.operationLimitsFile.getAbsolutePath());
        }
        if (this.getConsole().getMainSystem() != null && (f = new File("conf/oplimits/" + this.getConsole().getMainSystem() + ".xml")).canRead()) {
            return FileUtil.getFileAsString((File)f);
        }
        return new OperationLimits().asXml();
    }

    public void initSubPanel() {
        this.limits = OperationLimits.loadXml((String)this.getOpLimitsXml());
        this.showOnMap(this.showOnMap);
        Vector panels = this.getConsole().getSubPanelsOfInterface(CustomInteractionSupport.class);
        for (CustomInteractionSupport cis : panels) {
            cis.addInteraction((StateRendererInteraction)this);
        }
    }

    public void propertiesChanged() {
        boolean previously = this.sw.isSelected();
        this.sw.setSelected(this.showOnMap);
        if (previously != this.sw.isSelected()) {
            this.showOnMap(this.showOnMap);
        }
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange e) {
        this.showOnMap(false);
        this.pp = this.getSelectionFromLimits(this.limits);
        this.clickCount = 0;
        this.showOnMap(this.showOnMap);
        this.updateAction.actionPerformed(null);
    }

    public Image getIconImage() {
        return ImageUtils.getImage((String)PluginUtils.getPluginIcon(((Object)((Object)this)).getClass()));
    }

    public Cursor getMouseCursor() {
        return this.adapter.getMouseCursor();
    }

    public boolean isExclusive() {
        return true;
    }

    public void keyPressed(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyPressed(event, source);
    }

    public void keyReleased(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyReleased(event, source);
    }

    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseClicked(event, source);
        boolean handled = false;
        if (event.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            popup.add(this.editLimits);
            popup.add(this.clearRect);
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(this.showOpArea);
            popup.add(item);
            item.setSelected(this.showOnMap);
            popup.addSeparator();
            popup.add(this.sendAction);
            popup.add(this.updateAction);
            handled = true;
            popup.show((Component)source, event.getX(), event.getY());
        } else {
            if (this.rectangle == null) {
                this.points[0] = source.getRealWorldLocation((Point2D)event.getPoint());
                this.rectangle = new PathElement(source.getMapGroup(), null, this.points[0]);
                this.rectangle.setShape(true);
                this.rectangle.setFinished(true);
                this.rectangle.setStroke((Stroke)new BasicStroke(2.0f));
                this.rectangle.addPoint(0.0, 0.0, 0.0, false);
                this.clickCount = 1;
                handled = true;
            } else if (this.clickCount == 1) {
                ++this.clickCount;
                this.points[1] = source.getRealWorldLocation((Point2D)event.getPoint());
                double[] offsets = this.points[1].getOffsetFrom(this.rectangle.getCenterLocation());
                this.rectangle.addPoint(offsets[1], offsets[0], 0.0, false);
                handled = true;
            } else if (this.clickCount == 2) {
                ++this.clickCount;
                LocationType loc = source.getRealWorldLocation((Point2D)event.getPoint());
                double[] offsets = loc.getOffsetFrom(this.rectangle.getCenterLocation());
                double[] offsets2 = this.points[1].getOffsetFrom(this.points[0]);
                double px = offsets[1];
                double py = offsets[0];
                double lx1 = 0.0;
                double ly1 = 0.0;
                double lx2 = offsets2[1];
                double ly2 = offsets2[0];
                double angle = this.points[0].getXYAngle(this.points[1]) + 1.5707963267948966;
                double dist = MathMiscUtils.pointLineDistance((double)px, (double)py, (double)lx1, (double)ly1, (double)lx2, (double)ly2);
                this.points[2] = new LocationType(this.points[0]);
                this.points[3] = new LocationType(this.points[1]);
                this.points[2].translatePosition(-Math.cos(angle) * dist, -Math.sin(angle) * dist, 0.0);
                this.points[3].translatePosition(-Math.cos(angle) * dist, -Math.sin(angle) * dist, 0.0);
                double inc = 1.5707963267948966;
                if ((int)angle != (int)this.points[2].getXYAngle(loc)) {
                    inc = 4.71238898038469;
                }
                this.rectangle.addPoint(lx2 + Math.sin(angle + inc) * dist, ly2 + Math.cos(angle + inc) * dist, 0.0, false);
                this.rectangle.addPoint(Math.sin(angle + inc) * dist, Math.cos(angle + inc) * dist, 0.0, false);
                this.pp = new ParallelepipedElement(null, null);
                this.pp.setCenterLocation(RectangleEditor.centroid(this.points));
                this.pp.setWidth(this.points[0].getDistanceInMeters(this.points[1]));
                this.pp.setLength(this.points[0].getDistanceInMeters(this.points[2]));
                this.pp.setHeight(0.0);
                this.pp.setYaw(Math.toDegrees(this.points[0].getXYAngle(this.points[2])));
                this.pp.setMyColor(Color.red);
                double d = RectangleEditor.centroid(this.points).getDistanceInMeters(loc) - RectangleEditor.centroid(this.points[0], this.points[1]).getDistanceInMeters(loc);
                if (d > 0.0) {
                    this.pp.setCenterLocation(new LocationType(this.pp.getCenterLocation().translatePosition(this.points[0].getOffsetFrom(this.points[2]))));
                }
                this.setLimitsFromSelection(this.pp);
                handled = true;
            }
            this.repaint();
        }
        if (!handled) {
            this.adapter.mouseClicked(event, source);
        }
    }

    public void keyTyped(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyTyped(event, source);
    }

    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        if (this.dragging) {
            double my = event.getPoint().getY() - this.lastDragPoint.getY();
            if (event.isShiftDown()) {
                this.pp.rotateRight(my);
            } else {
                LocationType prev = source.getRealWorldLocation(this.lastDragPoint);
                LocationType now = source.getRealWorldLocation((Point2D)event.getPoint());
                double[] offsets = now.getOffsetFrom(prev);
                this.pp.getCenterLocation().translatePosition(offsets[0], offsets[1], 0.0);
            }
            source.repaint();
        } else {
            this.adapter.mouseDragged(event, source);
        }
        this.lastDragPoint = event.getPoint();
    }

    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        boolean handled = false;
        if (this.editing) {
            this.lastDragPoint = event.getPoint();
            if (this.pp != null && this.pp.containsPoint(source.getRealWorldLocation(this.lastDragPoint), source)) {
                this.dragging = true;
                handled = true;
            }
        }
        if (!handled) {
            this.adapter.mousePressed(event, source);
        }
    }

    public void mouseMoved(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseMoved(event, source);
    }

    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseReleased(event, source);
        if (this.dragging) {
            this.dragging = false;
            this.setLimitsFromSelection(this.pp);
        }
        this.lastDragPoint = null;
    }

    public void mouseExited(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseExited(event, source);
    }

    public void focusGained(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusGained(event, source);
    }

    public void focusLost(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusLost(event, source);
    }

    public void wheelMoved(MouseWheelEvent event, StateRenderer2D source) {
        this.adapter.wheelMoved(event, source);
    }

    public void paint(Graphics2D g2, StateRenderer2D renderer) {
        Graphics2D g = (Graphics2D)g2.create();
        if (this.limits != null && !this.editing) {
            this.limits.paint(g, renderer);
        } else {
            if (this.limits != null) {
                NumberFormat nf = GuiUtils.getNeptusDecimalFormat((int)1);
                StringBuilder sb = new StringBuilder("<html><h3>" + I18n.text((String)"Operational Limits") + "</h3><font color='red'>");
                if (this.limits.getMaxDepth() != null && !this.limits.getMaxDepth().isNaN()) {
                    sb.append(I18n.text((String)"Max Depth") + ": <b>" + nf.format(this.limits.getMaxDepth()) + " m</b><br>");
                }
                if (this.limits.getMaxAltitude() != null && !this.limits.getMaxAltitude().isNaN()) {
                    sb.append(I18n.text((String)"Max Altitude") + ": <b>" + nf.format(this.limits.getMaxAltitude()) + " m</b><br>");
                }
                if (this.limits.getMinAltitude() != null && !this.limits.getMinAltitude().isNaN()) {
                    sb.append(I18n.text((String)"Min Altitude") + ": <b>" + nf.format(this.limits.getMinAltitude()) + " m</b><br>");
                }
                if (this.limits.getMinSpeed() != null && !this.limits.getMinSpeed().isNaN()) {
                    sb.append(I18n.text((String)"Min Speed") + ": <b>" + nf.format(this.limits.getMinSpeed()) + " m/s</b><br>");
                }
                if (this.limits.getMaxSpeed() != null && !this.limits.getMaxSpeed().isNaN()) {
                    sb.append(I18n.text((String)"Max Speed") + ": <b>" + nf.format(this.limits.getMaxSpeed()) + " m/s</b><br>");
                }
                sb.append("</font></html>");
                this.label.setText(sb.toString());
                Dimension dim = this.label.getPreferredSize();
                this.label.setBounds(10, 10, (int)dim.getWidth(), (int)dim.getHeight());
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.translate(10, 10);
                this.label.paint(g2d);
            }
            if (this.clickCount == 1) {
                g.setColor(Color.red.darker());
                Point2D pt = renderer.getScreenPosition(this.points[0]);
                g.draw(new Line2D.Double(pt.getX() - 5.0, pt.getY() - 5.0, pt.getX() + 5.0, pt.getY() + 5.0));
                g.draw(new Line2D.Double(pt.getX() - 5.0, pt.getY() + 5.0, pt.getX() + 5.0, pt.getY() - 5.0));
                g.dispose();
                return;
            }
            if (this.pp != null) {
                this.pp.paint((Graphics2D)g.create(), renderer, -renderer.getRotation());
            } else if (this.rectangle != null) {
                this.rectangle.setMyColor(Color.red);
                this.rectangle.setFill(true);
                this.rectangle.paint((Graphics2D)g.create(), renderer, -renderer.getRotation());
            }
            g.dispose();
        }
    }

    public OperationLimits setLimitsFromSelection(ParallelepipedElement selection) {
        if (selection == null) {
            this.limits.setOpAreaLat(null);
            this.limits.setOpAreaLon(null);
            this.limits.setOpRotationRads(null);
            this.limits.setOpAreaWidth(null);
            this.limits.setOpAreaLength(null);
        } else {
            double[] lld = selection.getCenterLocation().getAbsoluteLatLonDepth();
            this.limits.setOpAreaLat(Double.valueOf(lld[0]));
            this.limits.setOpAreaLon(Double.valueOf(lld[1]));
            this.limits.setOpAreaLength(Double.valueOf(selection.getLength()));
            this.limits.setOpAreaWidth(Double.valueOf(selection.getWidth()));
            this.limits.setOpRotationRads(Double.valueOf(selection.getYawRad()));
        }
        byte[] newMD5 = this.getLimitsMessage().payloadMD5();
        if (this.lastMD5 == null || !ByteUtil.equal((byte[])newMD5, (byte[])this.lastMD5)) {
            this.lastMD5 = this.getLimitsMessage().payloadMD5();
            this.updateAction.putValue("SmallIcon", ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/oplimits/update_request.png"));
            this.updateAction.putValue("ShortDescription", I18n.text((String)"Local operational limits have changes"));
        }
        return this.limits;
    }

    public ParallelepipedElement getSelectionFromLimits(OperationLimits limits) {
        if (limits.getOpAreaLat() == null) {
            this.pp = null;
        } else {
            this.pp = new ParallelepipedElement(null, null);
            this.pp.setWidth(limits.getOpAreaWidth().doubleValue());
            this.pp.setLength(limits.getOpAreaLength().doubleValue());
            this.pp.setYawDeg(Math.toDegrees(limits.getOpRotationRads()));
            LocationType lt = new LocationType();
            lt.setLatitudeDegs(limits.getOpAreaLat().doubleValue());
            lt.setLongitudeDegs(limits.getOpAreaLon().doubleValue());
            this.pp.setCenterLocation(lt);
            this.pp.setMyColor(Color.red);
        }
        if (this.pp == null) {
            this.clickCount = 0;
        }
        return this.pp;
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        this.showOnMap(!mode ? this.sw.getState() : mode);
        this.sw.setEnabled(!mode);
        this.adapter.setActive(mode, source);
        this.editing = mode;
        if (this.editing && this.limits != null) {
            this.getSelectionFromLimits(this.limits);
        }
        if (!this.editing && this.pp != null) {
            this.setLimitsFromSelection(this.pp);
        }
        this.repaint();
    }

    public void setAssociatedSwitch(ToolbarSwitch tswitch) {
    }

    public void paintInteraction(Graphics2D g, StateRenderer2D source) {
        this.adapter.paintInteraction(g, source);
    }

    public void cleanSubPanel() {
    }
}

