/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.oplimits;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.ParallelepipedElement;
import pt.lsts.neptus.types.map.PathElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@LayerPriority(priority=60)
public class RectangleEditor
extends JPanel
implements Renderer2DPainter,
StateRendererInteraction {
    private static final long serialVersionUID = 107770334195610476L;
    protected InteractionAdapter adapter = new InteractionAdapter(null);
    protected StateRenderer2D renderer;
    protected PathElement rectangle = null;
    protected ParallelepipedElement pp = null;
    protected ParallelepipedElement selection = null;
    protected JDialog parentDialog = null;
    protected LocationType[] points = new LocationType[4];
    protected double width = Double.NaN;
    protected double length = Double.NaN;
    protected double rotationRads = Double.NaN;
    protected double latDegs = Double.NaN;
    protected double lonDegs = Double.NaN;
    protected JButton btnOk;
    protected JButton btnCancel;
    protected JButton btnClear;
    protected int clickCount = 0;
    protected Point2D lastDragPoint = null;

    public ParallelepipedElement getSelectedRectangle() {
        return this.selection;
    }

    public RectangleEditor(MissionType mission) {
        this.renderer = new StateRenderer2D(MapGroup.getMapGroupInstance((MissionType)mission));
        this.renderer.setActiveInteraction((StateRendererInteraction)this);
        this.renderer.addPostRenderPainter((Renderer2DPainter)this, "Rectangle Editor");
        this.renderer.setCursor(Cursor.getDefaultCursor());
        this.setLayout(new BorderLayout());
        JPanel bottom = new JPanel(new FlowLayout(2, 2, 2));
        this.btnOk = new JButton(I18n.text((String)"OK"));
        this.btnCancel = new JButton(I18n.text((String)"Cancel"));
        this.btnClear = new JButton(I18n.text((String)"Clear"));
        this.btnOk.setPreferredSize(new Dimension(80, 22));
        this.btnCancel.setPreferredSize(new Dimension(80, 22));
        this.btnClear.setPreferredSize(new Dimension(80, 22));
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RectangleEditor.this.btnOk.setEnabled(false);
                RectangleEditor.this.rectangle = null;
                RectangleEditor.this.pp = null;
                RectangleEditor.this.repaint();
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RectangleEditor.this.selection = RectangleEditor.this.pp;
                if (RectangleEditor.this.parentDialog != null) {
                    RectangleEditor.this.parentDialog.dispose();
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RectangleEditor.this.pp = null;
                if (RectangleEditor.this.parentDialog != null) {
                    RectangleEditor.this.parentDialog.dispose();
                }
            }
        });
        bottom.add(this.btnClear);
        bottom.add(this.btnCancel);
        bottom.add(this.btnOk);
        this.btnOk.setEnabled(false);
        this.add((Component)this.renderer, "Center");
        this.add((Component)bottom, "South");
    }

    public ParallelepipedElement showDialog(Component caller) {
        this.parentDialog = new JDialog(SwingUtilities.getWindowAncestor(caller));
        this.parentDialog.add(this);
        this.parentDialog.setModal(true);
        this.parentDialog.setSize(600, 400);
        this.parentDialog.setVisible(true);
        return this.getSelectedRectangle();
    }

    public void paint(Graphics2D g2, StateRenderer2D renderer) {
        Graphics2D g = (Graphics2D)g2.create();
        if (this.clickCount == 1) {
            g.setColor(Color.red.darker());
            Point2D pt = renderer.getScreenPosition(this.points[0]);
            g.draw(new Line2D.Double(pt.getX() - 5.0, pt.getY() - 5.0, pt.getX() + 5.0, pt.getY() + 5.0));
            g.draw(new Line2D.Double(pt.getX() - 5.0, pt.getY() + 5.0, pt.getX() + 5.0, pt.getY() - 5.0));
            g.dispose();
            return;
        }
        if (this.pp != null) {
            this.pp.paint((Graphics2D)g.create(), renderer, -renderer.getRotation());
        } else if (this.rectangle != null) {
            this.rectangle.setMyColor(Color.red);
            this.rectangle.setFill(true);
            this.rectangle.paint((Graphics2D)g.create(), renderer, -renderer.getRotation());
        }
        g.dispose();
    }

    public Image getIconImage() {
        return this.adapter.getIconImage();
    }

    public Cursor getMouseCursor() {
        return Cursor.getDefaultCursor();
    }

    public boolean isExclusive() {
        return true;
    }

    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseClicked(event, source);
        if (event.getButton() == 3) {
            this.rectangle = null;
            this.pp = null;
            this.clickCount = 0;
            this.repaint();
            return;
        }
        if (this.rectangle == null) {
            this.points[0] = source.getRealWorldLocation((Point2D)event.getPoint());
            this.rectangle = new PathElement(source.getMapGroup(), null, this.points[0]);
            this.rectangle.setShape(true);
            this.rectangle.setFinished(true);
            this.rectangle.setStroke((Stroke)new BasicStroke(2.0f));
            this.rectangle.addPoint(0.0, 0.0, 0.0, false);
            this.clickCount = 1;
        } else if (this.clickCount == 1) {
            ++this.clickCount;
            this.points[1] = source.getRealWorldLocation((Point2D)event.getPoint());
            double[] offsets = this.points[1].getOffsetFrom(this.rectangle.getCenterLocation());
            this.rectangle.addPoint(offsets[1], offsets[0], 0.0, false);
        } else if (this.clickCount == 2) {
            ++this.clickCount;
            LocationType loc = source.getRealWorldLocation((Point2D)event.getPoint());
            double[] offsets = loc.getOffsetFrom(this.rectangle.getCenterLocation());
            double[] offsets2 = this.points[1].getOffsetFrom(this.points[0]);
            double px = offsets[1];
            double py = offsets[0];
            double lx1 = 0.0;
            double ly1 = 0.0;
            double lx2 = offsets2[1];
            double ly2 = offsets2[0];
            double angle = this.points[0].getXYAngle(this.points[1]) + 1.5707963267948966;
            double dist = MathMiscUtils.pointLineDistance((double)px, (double)py, (double)lx1, (double)ly1, (double)lx2, (double)ly2);
            this.points[2] = new LocationType(this.points[0]);
            this.points[3] = new LocationType(this.points[1]);
            this.points[2].translatePosition(-Math.cos(angle) * dist, -Math.sin(angle) * dist, 0.0);
            this.points[3].translatePosition(-Math.cos(angle) * dist, -Math.sin(angle) * dist, 0.0);
            double inc = 1.5707963267948966;
            if ((int)angle != (int)this.points[2].getXYAngle(loc)) {
                inc = 4.71238898038469;
            }
            this.rectangle.addPoint(lx2 + Math.sin(angle + inc) * dist, ly2 + Math.cos(angle + inc) * dist, 0.0, false);
            this.rectangle.addPoint(Math.sin(angle + inc) * dist, Math.cos(angle + inc) * dist, 0.0, false);
            this.pp = new ParallelepipedElement(this.rectangle.getMapGroup(), this.rectangle.getParentMap());
            this.pp.setCenterLocation(RectangleEditor.centroid(this.points));
            this.pp.setWidth(this.points[0].getDistanceInMeters(this.points[1]));
            this.pp.setLength(this.points[0].getDistanceInMeters(this.points[2]));
            this.pp.setHeight(0.0);
            this.pp.setYaw(Math.toDegrees(this.points[0].getXYAngle(this.points[2])));
            this.pp.setMyColor(Color.red);
            double d = RectangleEditor.centroid(this.points).getDistanceInMeters(loc) - RectangleEditor.centroid(this.points[0], this.points[1]).getDistanceInMeters(loc);
            if (d > 0.0) {
                this.pp.setCenterLocation(new LocationType(this.pp.getCenterLocation().translatePosition(this.points[0].getOffsetFrom(this.points[2]))));
            }
            this.btnOk.setEnabled(true);
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        this.adapter.mousePressed(event, source);
        this.lastDragPoint = event.getPoint();
    }

    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        if (this.pp != null && this.pp.containsPoint(source.getRealWorldLocation(this.lastDragPoint), source)) {
            double mx = event.getPoint().getX() - this.lastDragPoint.getX();
            double my = event.getPoint().getY() - this.lastDragPoint.getY();
            if (event.isShiftDown()) {
                this.pp.rotateRight(my);
            } else {
                this.pp.getCenterLocation().translatePosition(-my / (double)source.getZoom(), mx / (double)source.getZoom(), 0.0);
            }
        } else if (!event.isShiftDown()) {
            this.adapter.mouseDragged(event, source);
        }
        this.lastDragPoint = event.getPoint();
        this.repaint();
    }

    public void mouseMoved(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseMoved(event, source);
    }

    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseReleased(event, source);
        this.lastDragPoint = null;
    }

    public void wheelMoved(MouseWheelEvent event, StateRenderer2D source) {
        this.adapter.wheelMoved(event, source);
    }

    public void keyPressed(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyPressed(event, source);
    }

    public void keyReleased(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyReleased(event, source);
    }

    public void keyTyped(KeyEvent event, StateRenderer2D source) {
        this.adapter.keyTyped(event, source);
    }

    public void mouseExited(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseExited(event, source);
    }

    public void focusGained(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusGained(event, source);
    }

    public void focusLost(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusLost(event, source);
    }

    public static LocationType centroid(LocationType ... points) {
        double latSum = 0.0;
        double lonSum = 0.0;
        double depthSum = 0.0;
        for (LocationType l : points) {
            double[] lld = l.getAbsoluteLatLonDepth();
            latSum += lld[0];
            lonSum += lld[1];
            depthSum += lld[2];
        }
        LocationType l = new LocationType();
        l.setLatitudeDegs(latSum / (double)points.length);
        l.setLongitudeDegs(lonSum / (double)points.length);
        l.setDepth(depthSum / (double)points.length);
        return l;
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        this.adapter.setActive(mode, source);
    }

    public void setAssociatedSwitch(ToolbarSwitch tswitch) {
    }

    public void paintInteraction(Graphics2D g, StateRenderer2D source) {
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        GuiUtils.setLookAndFeel();
        MissionType mission = new MissionType("/home/zp/workspace/Neptus/missions/APDL/missao-apdl.nmisz");
        RectangleEditor editor = new RectangleEditor(mission);
        NeptusLog.pub().info((Object)("<###> " + editor.showDialog(new JFrame())));
    }
}

