/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.NeptusMRA;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.vtk.ctd3d.CTD3DToolbar;
import pt.lsts.neptus.plugins.vtk.ctd3d.InteractorStyleCTD3D;
import pt.lsts.neptus.plugins.vtk.ctd3d.LoadData;
import pt.lsts.neptus.plugins.vtk.ctd3d.Window;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudCTD;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudHandlerCTD;
import pt.lsts.neptus.plugins.vtk.utils.Utils;
import pt.lsts.neptus.plugins.vtk.visualization.AxesWidget;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import pt.lsts.neptus.plugins.vtk.visualization.ScalarBar;
import pt.lsts.neptus.util.ImageUtils;
import vtk.vtkDataArray;
import vtk.vtkProp;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkScalarsToColors;

@PluginDescription(author="hfq", name="CTD 3D", icon="images/menus/3d.png")
public class CTD3D
extends JPanel
implements MRAVisualization,
PropertiesProvider {
    private static final long serialVersionUID = 1L;
    private IMraLogGroup source;
    public Canvas canvas;
    private Window winCanvas;
    protected InteractorStyleCTD3D interactorStyle;
    private CTD3DToolbar toolbar;
    public PointCloudCTD pointcloud;
    public ScalarBar scalarBar;
    private boolean isFirstRender = true;

    public CTD3D(MRAPanel mraPanel) {
        if (!Utils.hasTryedToLoadVtkLib) {
            Utils.loadVTKLibraries();
        }
    }

    @Override
    public String getName() {
        return I18n.text((String)"CTD 3D");
    }

    public Component getComponent(IMraLogGroup source, double timestep) {
        this.source = source;
        this.setLayout(new BorderLayout());
        this.canvas = new Canvas();
        this.canvas.LightFollowCameraOn();
        this.canvas.GetRenderer().AutomaticLightCreationOn();
        this.canvas.setEnabled(true);
        this.winCanvas = new Window(this.canvas, source);
        this.interactorStyle = this.winCanvas.getInteractorStyle();
        this.loadData();
        this.pointcloud.createActorFromPoints();
        this.pointcloud.generateHandler();
        this.pointcloud.getPolyData().GetPointData().SetScalars((vtkDataArray)((PointCloudHandlerCTD)this.pointcloud.getColorHandler()).getColorsTemperature());
        this.canvas.GetRenderer().AddActor((vtkProp)this.pointcloud.getCloudLODActor());
        this.setScalarBar(new ScalarBar(I18n.text((String)"Temperature Color Map")));
        this.scalarBar.setScalarBarHorizontalProperties();
        this.scalarBar.setUpScalarBarLookupTable((vtkScalarsToColors)((PointCloudHandlerCTD)this.pointcloud.getColorHandler()).getLutTemperature());
        this.scalarBar.getScalarBarActor().Modified();
        this.canvas.GetRenderer().AddActor((vtkProp)this.scalarBar.getScalarBarActor());
        AxesWidget axesWidget = new AxesWidget((vtkRenderWindowInteractor)this.canvas.getRenderWindowInteractor());
        axesWidget.createAxesWidget();
        this.toolbar = new CTD3DToolbar(this);
        this.toolbar.createtoolBar();
        this.add((Component)this.toolbar, "West");
        this.add((Component)((Object)this.canvas));
        this.toolbar.getTempToggle().setSelected(true);
        return this;
    }

    private void loadData() {
        LoadData loadData = new LoadData(this.source);
        loadData.loadCTDData();
        this.pointcloud = loadData.getPointcloud();
    }

    public boolean canBeApplied(IMraLogGroup source) {
        return NeptusMRA.vtkEnabled && source.getLsfIndex().getEntityId("CTD") != 255 && source.getLsfIndex().containsMessagesOfType(new String[]{"Conductivity"});
    }

    public ImageIcon getIcon() {
        return ImageUtils.getIcon((String)"images/menus/3d.png");
    }

    public Double getDefaultTimeStep() {
        return null;
    }

    public boolean supportsVariableTimeSteps() {
        return false;
    }

    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }

    public void onHide() {
    }

    public void onShow() {
        if (this.isFirstRender) {
            this.canvas.lock();
            this.canvas.GetRenderer().GetActiveCamera().SetPosition(1.0, -1.0, -100.0);
            this.canvas.GetRenderer().GetActiveCamera().SetViewUp(0.0, 1.0, -1.0);
            this.canvas.GetRenderer().ResetCamera();
            this.canvas.RenderSecured();
            this.canvas.unlock();
            this.isFirstRender = false;
        }
    }

    public void onCleanup() {
    }

    public DefaultProperty[] getProperties() {
        return PluginUtils.getPluginProperties((Object)this);
    }

    public void setProperties(Property[] properties) {
        PluginUtils.setPluginProperties((Object)this, (Property[])properties);
    }

    public String getPropertiesDialogTitle() {
        return "CTD 3D Properties";
    }

    public String[] getPropertiesErrors(Property[] properties) {
        return PluginUtils.validatePluginProperties((Object)this, (Property[])properties);
    }

    public ScalarBar getScalarBar() {
        return this.scalarBar;
    }

    public void setScalarBar(ScalarBar scalarBar) {
        this.scalarBar = scalarBar;
    }
}

