/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.LinkedHashMap;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.MRAProperties;
import pt.lsts.neptus.mra.NeptusMRA;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.vtk.filters.StatisticalOutlierRemoval;
import pt.lsts.neptus.plugins.vtk.mravisualizer.EventsHandler;
import pt.lsts.neptus.plugins.vtk.mravisualizer.InteractorStyleVis3D;
import pt.lsts.neptus.plugins.vtk.mravisualizer.LoadToPointCloud;
import pt.lsts.neptus.plugins.vtk.mravisualizer.Vis3DMenuBar;
import pt.lsts.neptus.plugins.vtk.mravisualizer.Vis3DToolBar;
import pt.lsts.neptus.plugins.vtk.mravisualizer.Window;
import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudHandlerXYZ;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudXYZ;
import pt.lsts.neptus.plugins.vtk.surface.PointCloudMesh;
import pt.lsts.neptus.plugins.vtk.utils.Utils;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import pt.lsts.neptus.plugins.vtk.visualization.Text3D;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import vtk.vtkDataArray;
import vtk.vtkLODActor;
import vtk.vtkProp;
import vtk.vtkScalarsToColors;

@PluginDescription(author="hfq", name="Bathymetry 3D", icon="images/menus/3d.png")
public class VtkMRAVis
extends JPanel
implements MRAVisualization,
PropertiesProvider {
    private static final long serialVersionUID = 8057825167454469065L;
    @NeptusProperty(name="Depth exaggeration multiplier", description="Multiplier value for depth exaggeration.")
    public static int zExaggeration = 10;
    private Canvas canvas;
    private Window winCanvas;
    private InteractorStyleVis3D interactorStyle;
    private EventsHandler events;
    public vtkLODActor noBeamsTxtActor;
    public Text3D noBeamsText;
    private Vis3DMenuBar menuBar;
    private Vis3DToolBar toolbar;
    private LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud = new LinkedHashMap();
    private LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh = new LinkedHashMap();
    public IMraLogGroup source;
    public File file;
    private Boolean componentEnabled = false;
    private Boolean isFirstRender = true;
    private boolean mbFound = false;
    private static final String FILE_83P_EXT = ".83P";
    private MRAPanel mraPanel = null;

    public VtkMRAVis(MRAPanel panel) {
        this.mraPanel = panel;
        if (!Utils.hasTryedToLoadVtkLib) {
            Utils.loadVTKLibraries();
        }
    }

    @Override
    public String getName() {
        return I18n.text((String)"3D Bathymetry");
    }

    public Component getComponent(IMraLogGroup source, double timestep) {
        if (!this.componentEnabled.booleanValue()) {
            this.componentEnabled = true;
            this.source = source;
            this.setCanvas(new Canvas());
            this.getCanvas().LightFollowCameraOn();
            this.getCanvas().setEnabled(true);
            this.winCanvas = new Window(this.getCanvas(), this.interactorStyle, this.linkedHashMapCloud, this.linkedHashMapMesh, source);
            this.interactorStyle = this.winCanvas.getInteracStyle();
            this.setEvents(this.interactorStyle.getEventsHandler());
            this.setLayout(new BorderLayout());
            this.menuBar = new Vis3DMenuBar(this);
            this.menuBar.createMenuBar();
            this.add((Component)this.menuBar, "North");
            this.toolbar = new Vis3DToolBar(this);
            this.toolbar.createToolBar();
            this.add((Component)this.toolbar, "West");
            this.add((Component)((Object)this.getCanvas()));
            this.loadCloud();
            if (!this.mbFound) {
                this.toolbar.remove(this.toolbar.multibeamToggle);
            }
            if (!source.getLsfIndex().containsMessagesOfType(new String[]{"Distance"})) {
                this.toolbar.remove(this.toolbar.dvlToggle);
            }
        }
        return this;
    }

    private void loadCloud() {
        if (this.mbFound) {
            PointCloudXYZ pointCloudMultibeam = new PointCloudXYZ();
            LoadToPointCloud load = new LoadToPointCloud(this.source, pointCloudMultibeam);
            NeptusLog.pub().info((Object)"Parsing Multibeam data.");
            pointCloudMultibeam.setCloudName("multibeam");
            load.parseMultibeamPointCloud();
            this.getLinkedHashMapCloud().put(pointCloudMultibeam.getCloudName(), pointCloudMultibeam);
            this.processPointCloud(pointCloudMultibeam, load);
            pointCloudMultibeam.getPolyData().GetPointData().SetScalars((vtkDataArray)((PointCloudHandlerXYZ)pointCloudMultibeam.getColorHandler()).getColorsZ());
            this.events.setSensorTypeInteraction(EventsHandler.SensorTypeInteraction.MULTIBEAM);
            this.toolbar.multibeamToggle.setSelected(true);
            this.setUpRenderer(pointCloudMultibeam);
        }
        if (this.source.getLsfIndex().containsMessagesOfType(new String[]{"Distance"})) {
            PointCloudXYZ pointCloudDVL = new PointCloudXYZ();
            LoadToPointCloud load2 = new LoadToPointCloud(this.source, pointCloudDVL);
            NeptusLog.pub().info((Object)"Parsing DVL data.");
            pointCloudDVL.setCloudName("dvl");
            load2.parseDVLPointCloud();
            this.getLinkedHashMapCloud().put(pointCloudDVL.getCloudName(), pointCloudDVL);
            this.processPointCloud(pointCloudDVL, load2);
            pointCloudDVL.getPolyData().GetPointData().SetScalars((vtkDataArray)((PointCloudHandlerXYZ)pointCloudDVL.getColorHandler()).getColorsZ());
            if (!this.mbFound) {
                this.events.setSensorTypeInteraction(EventsHandler.SensorTypeInteraction.DVL);
                this.toolbar.dvlToggle.setSelected(true);
                this.setUpRenderer(pointCloudDVL);
            }
        }
        if (!this.source.getLsfIndex().containsMessagesOfType(new String[]{"Distance"}) && !this.mbFound) {
            String msgErrorNoData = I18n.text((String)"No data Available!");
            GuiUtils.errorMessage((Component)this.mraPanel, (String)I18n.text((String)"Info"), (String)msgErrorNoData);
            Text3D noDataText = new Text3D();
            noDataText.buildText3D(msgErrorNoData, 2.0, 2.0, 2.0, 10.0);
            noDataText.getText3dActor().RotateY(180.0);
            this.getCanvas().GetRenderer().AddActor((vtkProp)noDataText.getText3dActor());
        }
    }

    public void loadCloudBySensorType(String sensorType) {
        PointCloudXYZ pointCloud = new PointCloudXYZ();
        LoadToPointCloud load = new LoadToPointCloud(this.source, pointCloud);
        if (sensorType.equals("dvl") && this.source.getLsfIndex().containsMessagesOfType(new String[]{"Distance"})) {
            pointCloud.setCloudName(sensorType);
            load.parseDVLPointCloud();
        } else if (sensorType.equals("multibeam")) {
            pointCloud.setCloudName("multibeam");
            load.parseMultibeamPointCloud();
        }
        this.getLinkedHashMapCloud().put(pointCloud.getCloudName(), pointCloud);
        this.processPointCloud(pointCloud, load);
        this.setUpRenderer(pointCloud);
    }

    private void processPointCloud(APointCloud<?> pointCloud, LoadToPointCloud load) {
        if (pointCloud.getCloudName().equals("multibeam")) {
            if (pointCloud.getNumberOfPoints() != 0) {
                if (MRAProperties.outliersRemoval) {
                    StatisticalOutlierRemoval statOutRem = new StatisticalOutlierRemoval();
                    statOutRem.setMeanK(20);
                    statOutRem.setStdMul(0.2);
                    statOutRem.applyFilter(load.getPoints());
                    pointCloud.setXYZPoints(statOutRem.getOutputPoints());
                } else {
                    pointCloud.setXYZPoints(load.getPoints());
                }
                pointCloud.createActorFromPoints();
                pointCloud.generateHandler();
                NeptusLog.pub().info((Object)"Created Actor for multibeam data");
            }
        } else {
            pointCloud.setXYZPoints(load.getPoints());
            pointCloud.createActorFromPoints();
            pointCloud.generateHandler();
            NeptusLog.pub().info((Object)"Created Actor for dvl data");
        }
    }

    private void setUpRenderer(APointCloud<?> pointCloud) {
        if (pointCloud.getNumberOfPoints() != 0) {
            this.getCanvas().GetRenderer().AddActor((vtkProp)pointCloud.getCloudLODActor());
            this.interactorStyle.getScalarBar().setUpScalarBarLookupTable((vtkScalarsToColors)((PointCloudHandlerXYZ)pointCloud.getColorHandler()).getLutZ());
            this.getCanvas().GetRenderer().AddActor((vtkProp)this.winCanvas.getInteracStyle().getScalarBar().getScalarBarActor());
        } else {
            String msgErrorMultibeam = I18n.text((String)"No beams on Log file!");
            GuiUtils.errorMessage((Component)this.mraPanel, (String)I18n.text((String)"Info"), (String)msgErrorMultibeam);
            this.noBeamsText = new Text3D();
            this.noBeamsText.buildText3D(msgErrorMultibeam, 2.0, 2.0, 2.0, 10.0);
            this.noBeamsText.getText3dActor().RotateY(180.0);
            this.getCanvas().GetRenderer().AddActor((vtkProp)this.noBeamsText.getText3dActor());
        }
    }

    public boolean canBeApplied(IMraLogGroup source) {
        if (NeptusMRA.vtkEnabled) {
            this.file = source.getFile("Data.lsf").getParentFile();
            try {
                if (this.file.isDirectory()) {
                    for (File temp : this.file.listFiles()) {
                        if (!temp.toString().endsWith(FILE_83P_EXT)) continue;
                        this.setLog(source);
                        this.mbFound = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.mbFound || source.getLsfIndex().containsMessagesOfType(new String[]{"Distance"});
        }
        return false;
    }

    public ImageIcon getIcon() {
        return ImageUtils.getIcon((String)"images/menus/3d.png");
    }

    public Double getDefaultTimeStep() {
        return null;
    }

    public boolean supportsVariableTimeSteps() {
        return false;
    }

    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }

    public void onHide() {
    }

    public void onShow() {
        if (this.isFirstRender.booleanValue()) {
            this.canvas.GetRenderer().GetActiveCamera().SetPosition(1.0, -1.0, -100.0);
            this.canvas.GetRenderer().GetActiveCamera().SetViewUp(0.0, 1.0, -1.0);
            this.getCanvas().GetRenderWindow().SetCurrentCursor(9);
            this.getCanvas().RenderSecured();
            this.getCanvas().GetRenderer().ResetCamera();
            this.isFirstRender = false;
        }
    }

    public void onCleanup() {
    }

    public IMraLogGroup getLog() {
        return this.source;
    }

    private void setLog(IMraLogGroup log) {
        this.source = log;
    }

    public DefaultProperty[] getProperties() {
        return PluginUtils.getPluginProperties((Object)this);
    }

    public void setProperties(Property[] properties) {
        PluginUtils.setPluginProperties((Object)this, (Property[])properties);
    }

    public String getPropertiesDialogTitle() {
        return I18n.text((String)"3D Bathymetry Properties");
    }

    public String[] getPropertiesErrors(Property[] properties) {
        return PluginUtils.validatePluginProperties((Object)this, (Property[])properties);
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    public LinkedHashMap<String, APointCloud<?>> getLinkedHashMapCloud() {
        return this.linkedHashMapCloud;
    }

    public void setLinkedHashMapCloud(LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud) {
        this.linkedHashMapCloud = linkedHashMapCloud;
    }

    public LinkedHashMap<String, PointCloudMesh> getLinkedHashMapMesh() {
        return this.linkedHashMapMesh;
    }

    public void setLinkedHashMapMesh(LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh) {
        this.linkedHashMapMesh = linkedHashMapMesh;
    }

    public EventsHandler getEvents() {
        return this.events;
    }

    private void setEvents(EventsHandler events) {
        this.events = events;
    }
}

