/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.ctd3d;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.vtk.CTD3D;
import pt.lsts.neptus.plugins.vtk.pointcloud.DepthExaggeration;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudCTD;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudHandlerCTD;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import pt.lsts.neptus.plugins.vtk.visualization.ScalarBar;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import vtk.vtkDataArray;
import vtk.vtkScalarsToColors;

public class CTD3DToolbar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    private static final short ICON_SIZE = 18;
    private static final ImageIcon ICON_TEMP = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/vtk/assets/temperature.png", (int)18, (int)18);
    private static final ImageIcon ICON_SALINITY = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/vtk/assets/salinity.png", (int)18, (int)18);
    private static final ImageIcon ICON_PRESSURE = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/vtk/assets/pressure.png", (int)18, (int)18);
    private static final ImageIcon ICON_Z = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/vtk/assets/zexaggerate.png", (int)18, (int)18);
    private static final ImageIcon ICON_RESETVIEWPORT = ImageUtils.getScaledIcon((String)"images/menus/camera.png", (int)18, (int)18);
    private JToggleButton tempToggle;
    private JToggleButton salinityToggle;
    private JToggleButton pressureToggle;
    private JToggleButton zexaggerToggle;
    private JButton resetViewportButton;
    private final PointCloudCTD pointcloud;
    private final ScalarBar scalarBar;
    private final Canvas canvas;
    ActionListener temperatureToggleAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CTD3DToolbar.this.tempToggle.isSelected()) {
                CTD3DToolbar.this.pointcloud.getPolyData().GetPointData().SetScalars((vtkDataArray)((PointCloudHandlerCTD)CTD3DToolbar.this.pointcloud.getColorHandler()).getColorsTemperature());
                CTD3DToolbar.this.scalarBar.setScalarBarTitle(I18n.text((String)"Temperature Color Map"));
                CTD3DToolbar.this.scalarBar.setScalarBarHorizontalProperties();
                CTD3DToolbar.this.scalarBar.setUpScalarBarLookupTable((vtkScalarsToColors)((PointCloudHandlerCTD)CTD3DToolbar.this.pointcloud.getColorHandler()).getLutTemperature());
                CTD3DToolbar.this.canvas.lock();
                CTD3DToolbar.this.canvas.Render();
                CTD3DToolbar.this.canvas.unlock();
            }
        }
    };
    ActionListener salinityToggleAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CTD3DToolbar.this.salinityToggle.isSelected()) {
                CTD3DToolbar.this.pointcloud.getPolyData().GetPointData().SetScalars((vtkDataArray)((PointCloudHandlerCTD)CTD3DToolbar.this.pointcloud.getColorHandler()).getColorsSalinity());
                CTD3DToolbar.this.scalarBar.setScalarBarTitle(I18n.text((String)"Salinity Color Map"));
                CTD3DToolbar.this.scalarBar.setScalarBarHorizontalProperties();
                CTD3DToolbar.this.scalarBar.setUpScalarBarLookupTable((vtkScalarsToColors)((PointCloudHandlerCTD)CTD3DToolbar.this.pointcloud.getColorHandler()).getLutSalinity());
                CTD3DToolbar.this.canvas.lock();
                CTD3DToolbar.this.canvas.Render();
                CTD3DToolbar.this.canvas.unlock();
            }
        }
    };
    ActionListener pressureToggleAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CTD3DToolbar.this.pressureToggle.isSelected()) {
                CTD3DToolbar.this.pointcloud.getPolyData().GetPointData().SetScalars((vtkDataArray)((PointCloudHandlerCTD)CTD3DToolbar.this.pointcloud.getColorHandler()).getColorsPressure());
                CTD3DToolbar.this.scalarBar.setScalarBarTitle(I18n.text((String)"Pressure Color Map"));
                CTD3DToolbar.this.scalarBar.setScalarBarHorizontalProperties();
                CTD3DToolbar.this.scalarBar.setUpScalarBarLookupTable((vtkScalarsToColors)((PointCloudHandlerCTD)CTD3DToolbar.this.pointcloud.getColorHandler()).getLutPressure());
                CTD3DToolbar.this.canvas.lock();
                CTD3DToolbar.this.canvas.Render();
                CTD3DToolbar.this.canvas.unlock();
            }
        }
    };
    ActionListener zexaggerToggleAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CTD3DToolbar.this.zexaggerToggle.isSelected()) {
                CTD3DToolbar.this.canvas.lock();
                DepthExaggeration.performDepthExaggeration(CTD3DToolbar.this.pointcloud.getPolyData(), 10);
                CTD3DToolbar.this.canvas.GetRenderer().ResetCamera();
                CTD3DToolbar.this.canvas.Render();
                CTD3DToolbar.this.canvas.unlock();
            } else if (!CTD3DToolbar.this.zexaggerToggle.isSelected()) {
                CTD3DToolbar.this.canvas.lock();
                DepthExaggeration.reverseDepthExaggeration(CTD3DToolbar.this.pointcloud.getPolyData(), 10);
                CTD3DToolbar.this.canvas.GetRenderer().ResetCamera();
                CTD3DToolbar.this.canvas.Render();
                CTD3DToolbar.this.canvas.unlock();
            }
        }
    };
    ActionListener resetViewportAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                CTD3DToolbar.this.canvas.lock();
                CTD3DToolbar.this.canvas.GetRenderer().ResetCamera();
                CTD3DToolbar.this.canvas.GetRenderer().GetActiveCamera().SetViewUp(0.0, 0.0, -1.0);
                CTD3DToolbar.this.canvas.Render();
                CTD3DToolbar.this.canvas.unlock();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    };

    public CTD3DToolbar(CTD3D ctd3dInit) {
        this.canvas = ctd3dInit.canvas;
        this.pointcloud = ctd3dInit.pointcloud;
        this.scalarBar = ctd3dInit.scalarBar;
    }

    public void createtoolBar() {
        this.setOrientation(1);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder()));
        this.setTempToggle(new JToggleButton());
        this.getTempToggle().setToolTipText(I18n.text((String)"See Temperature data color map") + ".");
        this.getTempToggle().setIcon(ICON_TEMP);
        this.getTempToggle().addActionListener(this.temperatureToggleAction);
        this.setSalinityToggle(new JToggleButton());
        this.getSalinityToggle().setToolTipText(I18n.text((String)"See Salinity data color map") + ".");
        this.getSalinityToggle().setIcon(ICON_SALINITY);
        this.getSalinityToggle().addActionListener(this.salinityToggleAction);
        this.setPressureToggle(new JToggleButton());
        this.getPressureToggle().setToolTipText(I18n.text((String)"See Pressure data color map") + ".");
        this.getPressureToggle().setIcon(ICON_PRESSURE);
        this.getPressureToggle().addActionListener(this.pressureToggleAction);
        ButtonGroup groupToggles = new ButtonGroup();
        groupToggles.add(this.getTempToggle());
        groupToggles.add(this.getSalinityToggle());
        groupToggles.add(this.getPressureToggle());
        this.setZexaggerToggle(new JToggleButton());
        this.getZexaggerToggle().setToolTipText(I18n.text((String)"Enable/Disable Z Exaggeration") + ".");
        this.getZexaggerToggle().setIcon(ICON_Z);
        this.getZexaggerToggle().addActionListener(this.zexaggerToggleAction);
        this.resetViewportButton = new JButton();
        this.resetViewportButton.setToolTipText(I18n.text((String)"Reset Viewport") + ".");
        this.resetViewportButton.setIcon(ICON_RESETVIEWPORT);
        this.resetViewportButton.addActionListener(this.resetViewportAction);
        this.add(this.getTempToggle());
        this.add(this.getSalinityToggle());
        this.add(this.getPressureToggle());
        this.addSeparator();
        this.add(this.getZexaggerToggle());
        this.addSeparator();
        this.add(this.resetViewportButton);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D graphic2d = (Graphics2D)g;
        Color color1 = this.getBackground();
        Color color2 = Color.GRAY;
        GradientPaint gradPaint = new GradientPaint(0.0f, 0.0f, color1, this.getWidth(), this.getHeight(), color2);
        graphic2d.setPaint(gradPaint);
        graphic2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public JToggleButton getTempToggle() {
        return this.tempToggle;
    }

    private void setTempToggle(JToggleButton tempToggle) {
        this.tempToggle = tempToggle;
    }

    public JToggleButton getSalinityToggle() {
        return this.salinityToggle;
    }

    private void setSalinityToggle(JToggleButton salinityToggle) {
        this.salinityToggle = salinityToggle;
    }

    public JToggleButton getPressureToggle() {
        return this.pressureToggle;
    }

    private void setPressureToggle(JToggleButton pressureToggle) {
        this.pressureToggle = pressureToggle;
    }

    public JToggleButton getZexaggerToggle() {
        return this.zexaggerToggle;
    }

    public void setZexaggerToggle(JToggleButton zexaggerToggle) {
        this.zexaggerToggle = zexaggerToggle;
    }

    public static void main(String[] args) {
        CTD3DToolbar toolbar = new CTD3DToolbar(null);
        toolbar.createtoolBar();
        GuiUtils.testFrame((JComponent)toolbar, (String)("Test toolbar: " + toolbar.getClass().getSimpleName()), (int)43, (int)554);
    }
}

