/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.ctd3d;

import pt.lsts.imc.Depth;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Pressure;
import pt.lsts.imc.Salinity;
import pt.lsts.imc.Temperature;
import pt.lsts.imc.lsf.IndexScanner;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudCTD;
import pt.lsts.neptus.types.coord.LocationType;
import vtk.vtkDoubleArray;
import vtk.vtkPoints;

public class LoadData {
    private final IMraLogGroup source;
    private final PointCloudCTD pointcloud;
    private final vtkPoints points;
    private final vtkDoubleArray tempArray;
    private final vtkDoubleArray salinityArray;
    private final vtkDoubleArray pressureArray;

    public LoadData(IMraLogGroup source) {
        this.source = source;
        this.pointcloud = new PointCloudCTD();
        this.points = this.pointcloud.getXYZPoints();
        this.tempArray = new vtkDoubleArray();
        this.salinityArray = new vtkDoubleArray();
        this.pressureArray = new vtkDoubleArray();
    }

    public void loadCTDData() {
        LsfIndex lsfIndex = this.source.getLsfIndex();
        IndexScanner indexScanner = new IndexScanner(lsfIndex);
        LocationType initLoc = null;
        int count = 0;
        while (true) {
            EstimatedState state;
            Temperature temp = (Temperature)indexScanner.next(Temperature.class, "CTD");
            Salinity salinity = (Salinity)indexScanner.next(Salinity.class, "CTD");
            Pressure pressure = (Pressure)indexScanner.next(Pressure.class, "CTD");
            if (temp == null && salinity == null || (state = (EstimatedState)indexScanner.next(EstimatedState.class)) == null) break;
            SystemPositionAndAttitude pose = IMCUtils.parseState((IMCMessage)state);
            LocationType currentLoc = pose.getPosition();
            if (initLoc == null) {
                initLoc = new LocationType(currentLoc);
            }
            double[] pointPose = currentLoc.getOffsetFrom(initLoc);
            if (temp != null) {
                this.tempArray.InsertValue(count, temp.getValue());
            }
            if (salinity != null) {
                this.salinityArray.InsertValue(count, salinity.getValue());
            }
            this.points.InsertNextPoint(pointPose[0], pointPose[1], pose.getPosition().getDepth());
            if (pressure != null) {
                this.pressureArray.InsertValue(count, pressure.getValue());
            } else {
                Depth depth = (Depth)indexScanner.next(Depth.class);
                if (depth != null) {
                    this.pressureArray.InsertValue(count, depth.getValue());
                }
            }
            ++count;
        }
        this.pointcloud.setNumberOfPoints(this.points.GetNumberOfPoints());
        this.pointcloud.setXYZPoints(this.points);
        this.pointcloud.setTemperatures(this.tempArray);
        this.pointcloud.setSalinities(this.salinityArray);
        this.pointcloud.setPressures(this.pressureArray);
    }

    public PointCloudCTD getPointcloud() {
        return this.pointcloud;
    }
}

