/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.ctd3d;

import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.vtk.ctd3d.InteractorStyleCTD3D;
import pt.lsts.neptus.plugins.vtk.visualization.AWindow;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import vtk.vtkInteractorObserver;
import vtk.vtkRenderWindowInteractor;

public class Window
extends AWindow {
    private InteractorStyleCTD3D interactorStyle;

    public Window(Canvas canvas, IMraLogGroup source) {
        this(canvas, source, "CTD3D");
    }

    public Window(Canvas canvas, IMraLogGroup source, String windowName) {
        super(canvas, windowName, source);
        this.setRenderer(canvas.GetRenderer());
        this.setRenWin(canvas.GetRenderWindow());
        this.setRenWinInteractor((vtkRenderWindowInteractor)canvas.getRenderWindowInteractor());
        this.setUpRenderer();
        this.setUpRenWin();
        this.setUpRenWinInteractor();
        this.setUpInteractorStyle();
    }

    @Override
    public void setUpRenderer() {
        this.getRenderer().SetGradientBackground(true);
        this.getRenderer().SetBackground(0.0, 0.0, 0.0);
        this.getRenderer().SetBackground2(0.3, 0.7, 1.0);
    }

    @Override
    public void setUpRenWin() {
        this.getRenWin().SetWindowName(this.getWindowName());
        this.getRenWin().AlphaBitPlanesOff();
        this.getRenWin().PointSmoothingOff();
        this.getRenWin().LineSmoothingOff();
        this.getRenWin().SwapBuffersOn();
        this.getRenWin().SetStereoTypeToAnaglyph();
    }

    @Override
    public void setUpRenWinInteractor() {
        this.getRenWinInteractor().SetRenderWindow(this.getRenWin());
        this.getRenWinInteractor().SetDesiredUpdateRate(30.0);
    }

    @Override
    public void setUpInteractorStyle() {
        this.interactorStyle = new InteractorStyleCTD3D(this.getCanvas(), this.getRenderer(), this.getRenWinInteractor(), this.getSource());
        this.getRenWinInteractor().SetInteractorStyle((vtkInteractorObserver)this.interactorStyle);
    }

    public InteractorStyleCTD3D getInteractorStyle() {
        return this.interactorStyle;
    }
}

