/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.events;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.vtk.VtkMRAVis;
import pt.lsts.neptus.plugins.vtk.utils.Utils;
import pt.lsts.neptus.plugins.vtk.visualization.AInteractorStyleTrackballCamera;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import vtk.vtkPNGWriter;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkRenderer;
import vtk.vtkTextActor;
import vtk.vtkWindow;
import vtk.vtkWindowToImageFilter;

public abstract class AEventsHandler {
    private Canvas canvas;
    private AInteractorStyleTrackballCamera interactorStyle;
    private vtkRenderer renderer;
    private vtkRenderWindowInteractor interactor;
    protected vtkPNGWriter snapshotWriter;
    protected vtkWindowToImageFilter wif;
    private vtkTextActor textProcessingActor;
    private static String TEXT_PROCESS_ACTOR = I18n.text((String)"Processing Data");
    private vtkTextActor textZExagInfoActor;
    private static String TEXT_ZEXAG_INFO_ACTOR = I18n.textf((String)"Depth multiplied by: %currenZexag", (Object[])new Object[]{VtkMRAVis.zExaggeration});
    protected String msgHelp = "";
    private IMraLogGroup source;
    private static final String SNAPSHOT_FILE_EXT = ".png";

    public AEventsHandler(Canvas canvas, vtkRenderer renderer, vtkRenderWindowInteractor interactor, AInteractorStyleTrackballCamera interactorStyle, IMraLogGroup source) {
        this.canvas = canvas;
        this.renderer = renderer;
        this.interactor = interactor;
        this.interactorStyle = interactorStyle;
        this.source = source;
        this.setTextProcessingActor(new vtkTextActor());
        this.setTextZExagInfoActor(new vtkTextActor());
        this.wif = new vtkWindowToImageFilter();
        this.snapshotWriter = new vtkPNGWriter();
        this.snapshotWriter.SetInputConnection(this.wif.GetOutputPort());
        this.buildTextZExagInfoActor();
        this.buildTextProcessingActor();
    }

    public AEventsHandler(AInteractorStyleTrackballCamera interactorStyle, IMraLogGroup source) {
        this(interactorStyle.getCanvas(), interactorStyle.getCanvas().GetRenderer(), (vtkRenderWindowInteractor)interactorStyle.getCanvas().getRenderWindowInteractor(), interactorStyle, source);
    }

    protected abstract void init();

    public void takeSnapShot(final String prefixSnapshotName) {
        Utils.goToAWTThread(new Runnable(){

            @Override
            public void run() {
                try {
                    AEventsHandler.this.interactorStyle.FindPokedRenderer(AEventsHandler.this.interactor.GetEventPosition()[0], AEventsHandler.this.interactor.GetEventPosition()[1]);
                    AEventsHandler.this.wif.SetInput((vtkWindow)AEventsHandler.this.interactor.GetRenderWindow());
                    AEventsHandler.this.wif.Modified();
                    AEventsHandler.this.snapshotWriter.Modified();
                    String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmssmm").format(Calendar.getInstance().getTimeInMillis());
                    timeStamp = "snapshot_" + timeStamp;
                    NeptusLog.pub().info((Object)("Snapshot timeStamp: " + timeStamp));
                    if (AEventsHandler.this.source != null) {
                        AEventsHandler.this.snapshotWriter.SetFileName(AEventsHandler.this.source.getDir().getAbsolutePath() + "/" + prefixSnapshotName + timeStamp + AEventsHandler.SNAPSHOT_FILE_EXT);
                    } else {
                        NeptusLog.pub().info((Object)"Source is not defined, image will be saved on neptus root file.");
                        AEventsHandler.this.snapshotWriter.SetFileName(timeStamp + prefixSnapshotName + AEventsHandler.SNAPSHOT_FILE_EXT);
                    }
                    if (!AEventsHandler.this.canvas.isWindowSet()) {
                        AEventsHandler.this.canvas.lock();
                        AEventsHandler.this.canvas.Render();
                        AEventsHandler.this.canvas.unlock();
                    }
                    AEventsHandler.this.canvas.lock();
                    AEventsHandler.this.wif.Update();
                    AEventsHandler.this.canvas.unlock();
                    NeptusLog.pub().info((Object)("Snapshot saved: " + AEventsHandler.this.snapshotWriter.GetFileName()));
                    AEventsHandler.this.snapshotWriter.Write();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void resetViewport() {
        try {
            this.canvas.lock();
            this.renderer.ResetCamera();
            this.renderer.GetActiveCamera().SetViewUp(0.0, 0.0, -1.0);
            this.canvas.Render();
            this.canvas.unlock();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    protected abstract void setHelpMsg();

    public String getMsgHelp() {
        return this.msgHelp;
    }

    private void buildTextZExagInfoActor() {
        this.textZExagInfoActor.GetTextProperty().BoldOn();
        this.textZExagInfoActor.GetTextProperty().ItalicOn();
        this.textZExagInfoActor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.textZExagInfoActor.GetTextProperty().SetFontFamilyToArial();
        this.textZExagInfoActor.GetTextProperty().SetFontSize(12);
        this.textZExagInfoActor.SetInput(TEXT_ZEXAG_INFO_ACTOR);
        this.textZExagInfoActor.VisibilityOn();
    }

    private void buildTextProcessingActor() {
        this.textProcessingActor.GetTextProperty().BoldOn();
        this.textProcessingActor.GetTextProperty().ItalicOn();
        this.textProcessingActor.GetTextProperty().SetFontSize(40);
        this.textProcessingActor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.textProcessingActor.GetTextProperty().SetFontFamilyToArial();
        this.textProcessingActor.SetInput(TEXT_PROCESS_ACTOR);
        this.textProcessingActor.VisibilityOn();
    }

    protected Canvas getCanvas() {
        return this.canvas;
    }

    protected void setCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    protected AInteractorStyleTrackballCamera getInteractorStyle() {
        return this.interactorStyle;
    }

    protected void setInteractorStyle(AInteractorStyleTrackballCamera interactorStyle) {
        this.interactorStyle = interactorStyle;
    }

    protected vtkRenderer getRenderer() {
        return this.renderer;
    }

    protected void setRenderer(vtkRenderer renderer) {
        this.renderer = renderer;
    }

    protected vtkRenderWindowInteractor getInteractor() {
        return this.interactor;
    }

    protected void setInteractor(vtkRenderWindowInteractor interactor) {
        this.interactor = interactor;
    }

    public vtkTextActor getTextProcessingActor() {
        return this.textProcessingActor;
    }

    protected void setTextProcessingActor(vtkTextActor textProcessingActor) {
        this.textProcessingActor = textProcessingActor;
    }

    public vtkTextActor getTextZExagInfoActor() {
        return this.textZExagInfoActor;
    }

    protected void setTextZExagInfoActor(vtkTextActor textZExagInfoActor) {
        this.textZExagInfoActor = textZExagInfoActor;
    }

    protected IMraLogGroup getSource() {
        return this.source;
    }

    protected void setSource(IMraLogGroup source) {
        this.source = source;
    }
}

