/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.events;

import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import pt.lsts.neptus.plugins.vtk.events.PointPickingEvent;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import vtk.vtkCamera;

public class MouseEvent
implements MouseWheelListener,
MouseListener,
MouseMotionListener {
    private final Canvas canvas;
    private final vtkCamera camera;
    private final PointPickingEvent pointPickingEvent;

    public MouseEvent(Canvas canvas, PointPickingEvent pointPickingEvent) {
        this.canvas = canvas;
        this.camera = canvas.GetRenderer().GetActiveCamera();
        this.pointPickingEvent = pointPickingEvent;
        canvas.addMouseWheelListener(this);
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        if (notches < 0) {
            this.zoomIn();
        } else {
            this.zoomOut();
        }
    }

    private void zoomIn() {
        this.canvas.lock();
        double zoomFactor = 1.02;
        if (this.camera.GetParallelProjection() == 1) {
            this.camera.SetParallelScale(this.camera.GetParallelScale() / zoomFactor);
        } else {
            this.canvas.GetRenderer().GetActiveCamera().Dolly(Math.pow(1.1, zoomFactor));
            this.canvas.resetCameraClippingRange();
        }
        this.canvas.Render();
        this.canvas.unlock();
    }

    private void zoomOut() {
        this.canvas.lock();
        double zoomFactor = -1.02;
        if (this.camera.GetParallelProjection() == 1) {
            this.camera.SetParallelScale(this.camera.GetParallelScale() / zoomFactor);
        } else {
            this.canvas.GetRenderer().GetActiveCamera().Dolly(Math.pow(1.1, zoomFactor));
            this.canvas.resetCameraClippingRange();
        }
        this.canvas.Render();
        this.canvas.unlock();
    }

    @Override
    public void mouseDragged(java.awt.event.MouseEvent e) {
        if (this.canvas.GetRenderer().VisibleActorCount() == 0) {
            return;
        }
        this.canvas.setCtrlPressed((e.getModifiers() & 2) == 2 ? 1 : 0);
        this.canvas.setShiftPressed((e.getModifiers() & 1) == 1 ? 1 : 0);
        this.canvas.getRenderWindowInteractor().SetEventInformationFlipY(e.getX(), e.getY(), this.canvas.getCtrlPressed(), this.canvas.getShiftPressed(), '0', 0, "0");
        this.canvas.lock();
        this.canvas.getRenderWindowInteractor().MouseMoveEvent();
        this.canvas.unlock();
        this.canvas.UpdateLight();
    }

    @Override
    public void mouseMoved(java.awt.event.MouseEvent e) {
        this.canvas.setLastX(e.getX());
        this.canvas.setLastY(e.getY());
        this.canvas.setCtrlPressed((e.getModifiers() & 2) == 2 ? 1 : 0);
        this.canvas.setShiftPressed((e.getModifiers() & 1) == 1 ? 1 : 0);
        this.canvas.getRenderWindowInteractor().SetEventInformationFlipY(e.getX(), e.getY(), this.canvas.getCtrlPressed(), this.canvas.getShiftPressed(), '0', 0, "0");
        this.canvas.lock();
        this.canvas.getRenderWindowInteractor().MouseMoveEvent();
        this.canvas.unlock();
    }

    @Override
    public void mouseClicked(java.awt.event.MouseEvent e) {
    }

    @Override
    public void mousePressed(java.awt.event.MouseEvent e) {
        if (this.canvas.GetRenderer().VisibleActorCount() == 0) {
            return;
        }
        this.canvas.lock();
        this.canvas.GetRenderWindow().SetDesiredUpdateRate(5.0);
        this.canvas.setLastX(e.getX());
        this.canvas.setLastY(e.getY());
        this.canvas.setCtrlPressed((e.getModifiers() & 2) == 2 ? 1 : 0);
        this.canvas.setShiftPressed((e.getModifiers() & 1) == 1 ? 1 : 0);
        this.canvas.getRenderWindowInteractor().SetEventInformationFlipY(e.getX(), e.getY(), this.canvas.getCtrlPressed(), this.canvas.getShiftPressed(), '0', 0, "0");
        if ((e.getModifiers() & 0x10) == 16) {
            if (this.canvas.getCtrlPressed() == 0) {
                this.canvas.getRenderWindowInteractor().LeftButtonPressEvent();
            } else {
                this.pointPickingEvent.execute(e, e.getID());
            }
        } else if ((e.getModifiers() & 8) == 8) {
            this.canvas.getRenderWindowInteractor().RightButtonPressEvent();
        } else if ((e.getModifiers() & 4) == 4) {
            this.canvas.getRenderWindowInteractor().MiddleButtonPressEvent();
        }
        this.canvas.unlock();
    }

    @Override
    public void mouseReleased(java.awt.event.MouseEvent e) {
        this.canvas.GetRenderWindow().SetDesiredUpdateRate(0.01);
        this.canvas.setCtrlPressed((e.getModifiers() & 2) == 2 ? 1 : 0);
        this.canvas.setShiftPressed((e.getModifiers() & 1) == 1 ? 1 : 0);
        this.canvas.getRenderWindowInteractor().SetEventInformationFlipY(e.getX(), e.getY(), this.canvas.getCtrlPressed(), this.canvas.getShiftPressed(), '0', 0, "0");
        if ((e.getModifiers() & 0x10) == 16) {
            this.canvas.lock();
            this.canvas.getRenderWindowInteractor().LeftButtonReleaseEvent();
            this.canvas.unlock();
        }
        if ((e.getModifiers() & 8) == 8) {
            this.canvas.lock();
            this.canvas.getRenderWindowInteractor().RightButtonReleaseEvent();
            this.canvas.unlock();
        }
        if ((e.getModifiers() & 4) == 4) {
            this.canvas.lock();
            this.canvas.getRenderWindowInteractor().MiddleButtonReleaseEvent();
            this.canvas.unlock();
        }
    }

    @Override
    public void mouseEntered(java.awt.event.MouseEvent e) {
    }

    @Override
    public void mouseExited(java.awt.event.MouseEvent e) {
    }
}

