/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.events;

import java.awt.event.MouseEvent;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.vtk.pointtypes.PointXYZ;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import vtk.vtkCommand;
import vtk.vtkPointPicker;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkRenderer;

public class PointPickingEvent
extends vtkCommand {
    private int idx;
    private int idx2;
    private float x;
    private float y;
    private float z;
    private float x2;
    private float y2;
    private float z2;
    private boolean pickFirst = false;
    private final Canvas canvas;

    public PointPickingEvent(Canvas canvas) {
        this.canvas = canvas;
    }

    public void performSinglePick(vtkRenderWindowInteractor interactor) {
        vtkPointPicker picker = new vtkPointPicker();
        int mouseX = interactor.GetEventPosition()[0];
        int mouseY = interactor.GetEventPosition()[1];
        interactor.StartPickCallback();
        vtkRenderer ren = interactor.FindPokedRenderer(interactor.GetEventPosition()[0], interactor.GetEventPosition()[1]);
        picker.Pick((double)mouseX, (double)mouseY, 0.0, ren);
        if (!this.pickFirst) {
            this.idx = picker.GetPointId();
            if (picker.GetDataSet() != null) {
                double[] p = new double[3];
                picker.GetDataSet().GetPoint(this.idx, p);
                this.x = (float)p[0];
                this.y = (float)p[1];
                this.z = (float)p[2];
            }
            this.pickFirst = true;
        } else {
            this.idx2 = picker.GetPointId();
            if (picker.GetDataSet() != null) {
                double[] p = new double[3];
                picker.GetDataSet().GetPoint(this.idx2, p);
                this.x2 = (float)p[0];
                this.y2 = (float)p[1];
                this.z2 = (float)p[2];
            }
            this.pickFirst = false;
        }
    }

    public void execute(MouseEvent e, int eventId) {
        this.performSinglePick((vtkRenderWindowInteractor)this.canvas.getRenderWindowInteractor());
        NeptusLog.pub().info((Object)("1 - Point id: " + this.idx));
        NeptusLog.pub().info((Object)("1 Point picked - x: " + this.getPoint().getX() + " y: " + this.getPoint().getY() + " z: " + this.getPoint().getZ()));
        if (this.getPoint2() != null) {
            NeptusLog.pub().info((Object)("2 Point id: " + this.idx2));
            NeptusLog.pub().info((Object)("2 Point picked - x2: " + this.getPoint2().getX() + " y2: " + this.getPoint2().getY() + " z2: " + this.getPoint2().getZ()));
        }
    }

    public PointXYZ getPoint() {
        PointXYZ p = new PointXYZ();
        p.setX(this.x);
        p.setY(this.y);
        p.setZ(this.z);
        return p;
    }

    public PointXYZ getPoint2() {
        PointXYZ p = new PointXYZ();
        p.setX(this.x2);
        p.setY(this.y2);
        p.setZ(this.z2);
        return p;
    }

    public int getPointIndex() {
        return this.idx;
    }
}

