/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.filters;

import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.vtk.surface.PointCloudMesh;
import vtk.vtkActor;
import vtk.vtkCellArray;
import vtk.vtkContourFilter;
import vtk.vtkCutter;
import vtk.vtkDataObject;
import vtk.vtkDoubleArray;
import vtk.vtkImplicitFunction;
import vtk.vtkMapper;
import vtk.vtkPlane;
import vtk.vtkPolyDataMapper;
import vtk.vtkStripper;

public class Contours {
    private final PointCloudMesh mesh;
    private double[] scalarRange;
    private final vtkContourFilter contoursFilter;
    public vtkActor planeActor;
    private vtkActor isolinesActor;

    public Contours(PointCloudMesh mesh) {
        this.mesh = mesh;
        this.scalarRange = new double[2];
        this.contoursFilter = new vtkContourFilter();
    }

    public void generateTerrainContours() {
        this.scalarRange = this.mesh.getPolyData().GetScalarRange();
        NeptusLog.pub().info((Object)("Range: " + this.scalarRange[0] + "; " + this.scalarRange[1]));
        NeptusLog.pub().info((Object)("number of points: " + this.mesh.getPolyData().GetNumberOfPoints()));
        this.contoursFilter.SetInput((vtkDataObject)this.mesh.getPolyData());
        this.contoursFilter.GenerateValues(10, this.scalarRange[0], this.scalarRange[1]);
        this.contoursFilter.Update();
        NeptusLog.pub().info((Object)("Number of contours: " + this.contoursFilter.GetNumberOfContours()));
        NeptusLog.pub().info((Object)this.contoursFilter.GetInformation().toString());
        vtkStripper contourStripper = new vtkStripper();
        contourStripper.SetInputConnection(this.contoursFilter.GetOutputPort());
        contourStripper.Update();
        NeptusLog.pub().info((Object)("Number of polys: " + contourStripper.GetOutput().GetNumberOfPolys()));
        NeptusLog.pub().info((Object)("Memory size: " + contourStripper.GetOutput().GetActualMemorySize()));
        NeptusLog.pub().info((Object)("Number of contour lines: " + contourStripper.GetOutput().GetNumberOfLines()));
        NeptusLog.pub().info((Object)("Number of points: " + contourStripper.GetOutput().GetNumberOfPoints()));
        NeptusLog.pub().info((Object)("Maximum Length: " + contourStripper.GetMaximumLength()));
        NeptusLog.pub().info((Object)contourStripper.GetInformation().toString());
        vtkCellArray cells = new vtkCellArray();
        cells = contourStripper.GetOutput().GetLines();
        NeptusLog.pub().info((Object)("Number of cells: " + cells.GetNumberOfCells()));
        vtkDoubleArray labelScalars = new vtkDoubleArray();
        labelScalars.SetNumberOfComponents(1);
        labelScalars.SetName("Isovalues");
        vtkPolyDataMapper contourMapper = new vtkPolyDataMapper();
        contourMapper.SetInputConnection(contourStripper.GetOutputPort());
        contourMapper.ScalarVisibilityOff();
        this.setIsolinesActor(new vtkActor());
        this.getIsolinesActor().SetMapper((vtkMapper)contourMapper);
    }

    public void generateTerrainContoursThroughCutter() {
        vtkPolyDataMapper inputMapper = new vtkPolyDataMapper();
        inputMapper.SetInput(this.mesh.getPolyData());
        vtkPlane plane = new vtkPlane();
        plane.SetOrigin(this.mesh.getPolyData().GetCenter());
        plane.SetNormal(0.0, 0.0, -1.0);
        double[] bounds = this.mesh.getPolyData().GetBounds();
        double[] minBound = new double[]{bounds[0], bounds[2], bounds[4]};
        double[] maxBound = new double[]{bounds[1], bounds[3], bounds[5]};
        double[] center = new double[3];
        center[0] = this.mesh.getPolyData().GetCenter()[0];
        center[0] = this.mesh.getPolyData().GetCenter()[1];
        center[0] = this.mesh.getPolyData().GetCenter()[2];
        vtkCutter cutter = new vtkCutter();
        cutter.SetCutFunction((vtkImplicitFunction)plane);
        cutter.SetInput((vtkDataObject)this.mesh.getPolyData());
        cutter.GenerateValues(10, bounds[4], bounds[5]);
        NeptusLog.pub().info((Object)("number of contours: " + cutter.GetNumberOfContours()));
        vtkPolyDataMapper cutterMapper = new vtkPolyDataMapper();
        cutterMapper.SetInputConnection(cutter.GetOutputPort());
        cutterMapper.ScalarVisibilityOff();
        NeptusLog.pub().info((Object)("number of pieces on mapper: " + cutterMapper.GetNumberOfPieces()));
        NeptusLog.pub().info((Object)("Number of clipping planes: " + cutterMapper.GetClippingPlanes().GetNumberOfItems()));
        this.planeActor = new vtkActor();
        this.planeActor.GetProperty().SetColor(1.0, 1.0, 0.0);
        this.planeActor.GetProperty().SetLineWidth(2.0);
        this.planeActor.SetMapper((vtkMapper)cutterMapper);
    }

    public vtkActor getIsolinesActor() {
        return this.isolinesActor;
    }

    public void setIsolinesActor(vtkActor isolinesActor) {
        this.isolinesActor = isolinesActor;
    }
}

