/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.filters;

import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudXYZ;
import vtk.vtkCleanPolyData;

public class DownsamplePointCloud {
    protected int numberOfPoints = 0;
    public APointCloud<?> pointCloud;
    private PointCloudXYZ outputDownsampledCloud;
    private final double tolerance;
    public Boolean isDownsampleDone = false;

    public DownsamplePointCloud(APointCloud<?> pointCloud, double tolerance) {
        this.pointCloud = pointCloud;
        this.numberOfPoints = pointCloud.getNumberOfPoints();
        this.tolerance = tolerance;
        this.setOutputDownsampledCloud(new PointCloudXYZ());
        this.downsample();
    }

    private void downsample() {
        try {
            vtkCleanPolyData cleanPolyData = new vtkCleanPolyData();
            cleanPolyData.SetInputConnection(this.pointCloud.getPolyData().GetProducerPort());
            cleanPolyData.SetTolerance(this.tolerance);
            cleanPolyData.Update();
            this.outputDownsampledCloud.setCloudName("downsampledCloud");
            this.outputDownsampledCloud.setXYZPoints(cleanPolyData.GetOutput().GetPoints());
            this.outputDownsampledCloud.setNumberOfPoints(this.outputDownsampledCloud.getXYZPoints().GetNumberOfPoints());
            this.isDownsampleDone = true;
        }
        catch (Exception e) {
            NeptusLog.pub().info((Object)"Exception on cloud downsampling");
            e.printStackTrace();
        }
    }

    public PointCloudXYZ getOutputDownsampledCloud() {
        return this.outputDownsampledCloud;
    }

    private void setOutputDownsampledCloud(PointCloudXYZ outputDownsampledCloud) {
        this.outputDownsampledCloud = outputDownsampledCloud;
    }
}

