/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.filters;

import pt.lsts.neptus.NeptusLog;
import vtk.vtkIdList;
import vtk.vtkKdTree;
import vtk.vtkPoints;

public class RadiusOutlierRemoval {
    private double searchRadius = 1.0;
    private int minPtsNeighboursRadius = 4;
    private vtkPoints outputPoints;

    public void applyFilter(vtkPoints points) {
        try {
            NeptusLog.pub().info((Object)("Radius outliers removal start: " + System.currentTimeMillis()));
            vtkKdTree kdTree = new vtkKdTree();
            kdTree.BuildLocatorFromPoints(points);
            this.setOutputPoints(new vtkPoints());
            int outputId = 0;
            if (points.GetNumberOfPoints() != 0) {
                for (int i = 0; i < points.GetNumberOfPoints(); ++i) {
                    vtkIdList idsFoundPts = new vtkIdList();
                    kdTree.FindPointsWithinRadius(this.searchRadius, points.GetPoint(i), idsFoundPts);
                    if (idsFoundPts.GetNumberOfIds() <= this.minPtsNeighboursRadius) continue;
                    this.getOutputPoints().InsertPoint(outputId, points.GetPoint(i));
                    ++outputId;
                }
            } else {
                NeptusLog.pub().error((Object)"Pointcloud is empty, no points to process!");
            }
            NeptusLog.pub().info((Object)("Radius outliers removal end: " + System.currentTimeMillis()));
            NeptusLog.pub().info((Object)("Number of input points: " + points.GetNumberOfPoints()));
            NeptusLog.pub().info((Object)("Number of points on output: " + this.getOutputPoints().GetNumberOfPoints()));
            float perc = (float)this.getOutputPoints().GetNumberOfPoints() / (float)points.GetNumberOfPoints();
            NeptusLog.pub().info((Object)("Percentage of inlier points: " + perc));
            if ((double)perc >= 0.8) {
                this.setOutputPoints(this.outputPoints);
            } else {
                NeptusLog.pub().info((Object)"Relax your parameters for radius outliers removal");
                this.setOutputPoints(points);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double getSearchRadius() {
        return this.searchRadius;
    }

    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    public int getMinPtsNeighboursRadius() {
        return this.minPtsNeighboursRadius;
    }

    public void setMinPtsNeighboursRadius(int minPtsNeighboursRadius) {
        this.minPtsNeighboursRadius = minPtsNeighboursRadius;
    }

    public vtkPoints getOutputPoints() {
        return this.outputPoints;
    }

    public void setOutputPoints(vtkPoints outputPoints) {
        this.outputPoints = outputPoints;
    }
}

