/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.filters;

import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.vtk.utils.CalcUtils;
import vtk.vtkIdList;
import vtk.vtkKdTree;
import vtk.vtkPoints;

public class StatisticalOutlierRemoval {
    private int meanK = 30;
    private double stdMul = 1.0;
    private vtkPoints outputPoints;

    public void applyFilter(vtkPoints points) {
        try {
            NeptusLog.pub().info((Object)("Number of input points: " + points.GetNumberOfPoints()));
            NeptusLog.pub().info((Object)("Statistical outliers removal start: " + System.currentTimeMillis()));
            this.setOutputPoints(new vtkPoints());
            int outputId = 0;
            vtkKdTree kdTree = new vtkKdTree();
            kdTree.BuildLocatorFromPoints(points);
            double[] meanDistances = new double[points.GetNumberOfPoints()];
            double meanDistancesSum = 0.0;
            double sqSumDistances = 0.0;
            ++this.meanK;
            for (int i = 0; i < points.GetNumberOfPoints(); ++i) {
                vtkIdList idsFoundPts = new vtkIdList();
                kdTree.FindClosestNPoints(this.meanK, points.GetPoint(i), idsFoundPts);
                double distSum = 0.0;
                for (int k = 1; k < this.meanK; ++k) {
                    double dist = 0.0;
                    distSum += (dist += CalcUtils.distanceBetween2Points(points.GetPoint(i), points.GetPoint(idsFoundPts.GetId(k))));
                    sqSumDistances += dist * dist;
                }
                meanDistances[i] = distSum / (double)(this.meanK - 1);
                meanDistancesSum += meanDistances[i];
            }
            double mean = meanDistancesSum / (double)points.GetNumberOfPoints();
            double stddev = CalcUtils.stddev(meanDistancesSum, sqSumDistances, points.GetNumberOfPoints());
            double distanceThreshold = mean + this.stdMul * stddev;
            for (int c = 0; c < points.GetNumberOfPoints(); ++c) {
                if (!(meanDistances[c] <= distanceThreshold)) continue;
                this.getOutputPoints().InsertPoint(outputId, points.GetPoint(c));
                ++outputId;
            }
            NeptusLog.pub().info((Object)("Statistical outliers removal end: " + System.currentTimeMillis()));
            NeptusLog.pub().info((Object)("Number of points on output: " + this.getOutputPoints().GetNumberOfPoints()));
            float perc = (float)this.getOutputPoints().GetNumberOfPoints() / (float)points.GetNumberOfPoints();
            NeptusLog.pub().info((Object)("Percentage of inlier points: " + perc));
            if ((double)perc >= 0.9) {
                this.setOutputPoints(this.outputPoints);
            } else {
                NeptusLog.pub().info((Object)"Relax your parameters for radius outliers removal");
                this.setOutputPoints(points);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public vtkPoints getOutputPoints() {
        return this.outputPoints;
    }

    public void setOutputPoints(vtkPoints outputPoints) {
        this.outputPoints = outputPoints;
    }

    public int getMeanK() {
        return this.meanK;
    }

    public void setMeanK(int meanK) {
        this.meanK = meanK;
    }

    public double getStdMul() {
        return this.stdMul;
    }

    public void setStdMul(double stdMul) {
        this.stdMul = stdMul;
    }
}

