/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.io;

import java.io.File;
import java.nio.file.Path;
import pt.lsts.neptus.NeptusLog;
import vtk.vtk3DSImporter;
import vtk.vtkDataSetReader;
import vtk.vtkLODActor;
import vtk.vtkMapper;
import vtk.vtkOBJReader;
import vtk.vtkPLYReader;
import vtk.vtkPolyDataMapper;
import vtk.vtkSTLReader;
import vtk.vtkSimplePointsReader;
import vtk.vtkVRMLImporter;

public class Reader3D {
    protected static Path path = null;
    private static String absolutePath;
    protected static final String FILE_VTK_EXT = ".vtk";
    protected static final String FILE_OBJ_EXT = ".obj";
    protected static final String FILE_PLY_EXT = ".ply";
    protected static final String FILE_STL_EXT = ".stl";
    protected static final String FILE_XYZ_EXT = ".xyz";
    protected static final String FILE_3DS_EXT = ".3ds";
    protected static final String FILE_VRML_EXT = ".wrl";
    protected static vtkDataSetReader readVTK;
    protected static vtkOBJReader readOBJ;
    protected static vtkPLYReader readPLY;
    protected static vtkSTLReader readSTL;
    protected static vtkSimplePointsReader readXYZ;
    protected static vtk3DSImporter import3ds;
    protected static vtkVRMLImporter importVRML;
    private vtkLODActor actor;
    private ImporterOps impOp;

    public Reader3D(File file) {
        this.checkFileExtention(file);
        switch (this.impOp) {
            case VTK: {
                NeptusLog.pub().info((Object)"vtk data Set Reader chosen!");
                this.readVTKFile();
                break;
            }
            case OBJ: {
                NeptusLog.pub().info((Object)"obj reader chosen");
                this.readOBJFile();
                break;
            }
            case PLY: {
                NeptusLog.pub().info((Object)"ply reader chosen");
                this.readPLYFile();
                break;
            }
            case STL: {
                NeptusLog.pub().info((Object)"stl reader chosen");
                this.readSTLFile();
                break;
            }
            case XYZ: {
                NeptusLog.pub().info((Object)"xyz, simple points reader");
                this.readXYZfile();
                break;
            }
            default: {
                NeptusLog.pub().info((Object)"error file extention not found, not supposed to be here");
            }
        }
    }

    private void checkFileExtention(File file) {
        absolutePath = file.getAbsolutePath();
        try {
            if (file.isDirectory()) {
                String stringFile = file.toString();
                if (stringFile.endsWith(FILE_OBJ_EXT)) {
                    this.impOp = ImporterOps.OBJ;
                } else if (stringFile.endsWith(FILE_PLY_EXT)) {
                    this.impOp = ImporterOps.PLY;
                } else if (stringFile.endsWith(FILE_STL_EXT)) {
                    this.impOp = ImporterOps.STL;
                } else if (stringFile.endsWith(FILE_VTK_EXT)) {
                    this.impOp = ImporterOps.VTK;
                } else if (stringFile.endsWith(FILE_XYZ_EXT)) {
                    this.impOp = ImporterOps.XYZ;
                } else if (stringFile.endsWith(FILE_3DS_EXT)) {
                    this.impOp = ImporterOps.ThreeDS;
                } else if (stringFile.endsWith(FILE_VRML_EXT)) {
                    this.impOp = ImporterOps.WRL;
                } else {
                    NeptusLog.pub().info((Object)"File extention not supported, or invalid file");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readOBJFile() {
        readOBJ = new vtkOBJReader();
        try {
            readOBJ.SetFileName(absolutePath);
            readOBJ.Update();
            readOBJ.UpdateInformation();
            this.setActor(new vtkLODActor());
            vtkPolyDataMapper mapper = new vtkPolyDataMapper();
            mapper.SetInputConnection(readOBJ.GetOutputPort());
            this.actor.SetMapper((vtkMapper)mapper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readPLYFile() {
        readPLY = new vtkPLYReader();
        try {
            readPLY.SetFileName(absolutePath);
            readPLY.Update();
            readPLY.UpdateInformation();
            vtkPolyDataMapper mapper = new vtkPolyDataMapper();
            mapper.SetInputConnection(readPLY.GetOutputPort());
            this.actor.SetMapper((vtkMapper)mapper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readSTLFile() {
        readSTL = new vtkSTLReader();
        try {
            readSTL.SetFileName(absolutePath);
            readSTL.Update();
            readSTL.UpdateInformation();
            vtkPolyDataMapper mapper = new vtkPolyDataMapper();
            mapper.SetInputConnection(readSTL.GetOutputPort());
            this.actor.SetMapper((vtkMapper)mapper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readVTKFile() {
        readVTK = new vtkDataSetReader();
        try {
            readVTK.SetFileName(absolutePath);
            readVTK.Update();
            readVTK.UpdateInformation();
            vtkPolyDataMapper mapper = new vtkPolyDataMapper();
            mapper.SetInputConnection(readVTK.GetOutputPort());
            this.actor.SetMapper((vtkMapper)mapper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readXYZfile() {
        readXYZ = new vtkSimplePointsReader();
        try {
            readXYZ.SetFileName(absolutePath);
            readXYZ.Update();
            readXYZ.UpdateInformation();
            vtkPolyDataMapper mapper = new vtkPolyDataMapper();
            mapper.SetInputConnection(readXYZ.GetOutputPort());
            this.actor.SetMapper((vtkMapper)mapper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public vtkLODActor getActor() {
        return this.actor;
    }

    private void setActor(vtkLODActor actor) {
        this.actor = actor;
    }

    public static enum ImporterOps {
        VTK,
        OBJ,
        PLY,
        STL,
        XYZ,
        ThreeDS,
        WRL;

    }
}

