/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.io;

import java.io.File;
import java.io.IOException;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.vtk.utils.File3DUtils;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import pt.lsts.neptus.plugins.vtk.visualization.Text3D;
import vtk.vtkDataObject;
import vtk.vtkDataSetWriter;
import vtk.vtkOBJExporter;
import vtk.vtkPLYWriter;
import vtk.vtkPolyData;
import vtk.vtkProp;
import vtk.vtkRenderWindow;
import vtk.vtkSTLWriter;
import vtk.vtkVRMLExporter;
import vtk.vtkX3DExporter;

public class Writer3D {
    private vtkDataSetWriter exporterToVtk;
    private vtkOBJExporter exporterToOBJ;
    private vtkPLYWriter exporterToPLY;
    private vtkSTLWriter exporterToSTL;
    private vtkVRMLExporter exporterToVRML;
    private vtkX3DExporter exporterToX3D;

    public void save3dFileType(File3DUtils.FileType type, File file, vtkPolyData polydata, Canvas canvas) {
        switch (type) {
            case STL: {
                NeptusLog.pub().info((Object)"Saving STL File.");
                try {
                    Text3D text3d = new Text3D();
                    text3d.buildText3D(I18n.text((String)"Saving to a STL file") + ".", 2.0, 2.0, 2.0, 8.0);
                    canvas.GetRenderer().AddActor((vtkProp)text3d.getText3dActor());
                    this.exportToSTLFileFormat(file, polydata);
                    canvas.GetRenderer().RemoveActor((vtkProp)text3d.getText3dActor());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                break;
            }
            case OBJ: {
                NeptusLog.pub().info((Object)"Saving OBJ file.");
                try {
                    Text3D text3d = new Text3D();
                    text3d.buildText3D(I18n.text((String)"Saving to a OBJ file") + ".", 2.0, 2.0, 2.0, 8.0);
                    canvas.GetRenderer().AddActor((vtkProp)text3d.getText3dActor());
                    this.exportToOBJFileFormat(file, polydata, canvas.GetRenderWindow());
                    canvas.GetRenderer().RemoveActor((vtkProp)text3d.getText3dActor());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                break;
            }
            case PLY: {
                NeptusLog.pub().info((Object)"Saving PLY file.");
                try {
                    Text3D text3d = new Text3D();
                    text3d.buildText3D(I18n.text((String)"Saving to a PLY file") + ".", 2.0, 2.0, 2.0, 8.0);
                    canvas.GetRenderer().AddActor((vtkProp)text3d.getText3dActor());
                    this.exportToPLYFileFormat(file, polydata);
                    canvas.GetRenderer().RemoveActor((vtkProp)text3d.getText3dActor());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                break;
            }
            case VTK: {
                NeptusLog.pub().info((Object)"Saving VTK file.");
                try {
                    Text3D text3d = new Text3D();
                    text3d.buildText3D(I18n.text((String)"Saving to a VTK file") + ".", 2.0, 2.0, 2.0, 8.0);
                    canvas.GetRenderer().AddActor((vtkProp)text3d.getText3dActor());
                    this.exportToVTKFileFormat(file, polydata);
                    canvas.GetRenderer().RemoveActor((vtkProp)text3d.getText3dActor());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                break;
            }
            case WRL: {
                NeptusLog.pub().info((Object)"Saving WRL file.");
                try {
                    Text3D text3d = new Text3D();
                    text3d.buildText3D(I18n.text((String)"Saving to a WRL file") + ".", 2.0, 2.0, 2.0, 8.0);
                    canvas.GetRenderer().AddActor((vtkProp)text3d.getText3dActor());
                    this.exportToVRMLFileFormat(file, polydata, canvas.GetRenderWindow());
                    canvas.GetRenderer().RemoveActor((vtkProp)text3d.getText3dActor());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                break;
            }
            case X3D: {
                NeptusLog.pub().info((Object)"Saving X3D file.");
                try {
                    Text3D text3d = new Text3D();
                    text3d.buildText3D(I18n.text((String)"Saving to a X3D file") + ".", 2.0, 2.0, 2.0, 8.0);
                    canvas.GetRenderer().AddActor((vtkProp)text3d.getText3dActor());
                    this.exportToX3DFileFormat(file, polydata, canvas.GetRenderWindow());
                    canvas.GetRenderer().RemoveActor((vtkProp)text3d.getText3dActor());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                break;
            }
            default: {
                NeptusLog.pub().info((Object)"Default tyep... no way!!!");
            }
        }
    }

    public void exportToVTKFileFormat(File file, vtkPolyData poly) throws IOException {
        this.exporterToVtk = new vtkDataSetWriter();
        this.exporterToVtk.SetFileName(file.getAbsolutePath());
        this.exporterToVtk.SetInput((vtkDataObject)poly);
        this.exporterToVtk.Update();
        this.exporterToVtk.Write();
    }

    public void exportToVTKFileFormat(String path, vtkPolyData poly) throws IOException {
        this.exportToVTKFileFormat(new File(path), poly);
    }

    public void exportToOBJFileFormat(File file, vtkPolyData poly, vtkRenderWindow renWin) throws IOException {
        this.exporterToOBJ = new vtkOBJExporter();
        this.exporterToOBJ.SetFilePrefix(file.getParent() + "/cells");
        this.exporterToOBJ.SetInput(renWin);
        this.exporterToOBJ.Update();
        this.exporterToOBJ.Write();
    }

    public void exportToOBJFileFormat(String path, vtkPolyData poly, vtkRenderWindow renWin) throws IOException {
        this.exportToOBJFileFormat(new File(path), poly, renWin);
    }

    public void exportToPLYFileFormat(File file, vtkPolyData poly) throws IOException {
        this.exporterToPLY = new vtkPLYWriter();
        this.exporterToPLY.SetFileName(file.getAbsolutePath());
        this.exporterToPLY.SetInput((vtkDataObject)poly);
        this.exporterToPLY.SetFileTypeToBinary();
        this.exporterToPLY.Update();
        this.exporterToPLY.Write();
    }

    public void exportToPLYFileFormat(String path, vtkPolyData poly) throws IOException {
        this.exportToPLYFileFormat(new File(path), poly);
    }

    public void exportToSTLFileFormat(File file, vtkPolyData poly) throws IOException {
        this.exporterToSTL = new vtkSTLWriter();
        this.exporterToSTL.SetFileName(file.getAbsolutePath());
        this.exporterToSTL.SetInput((vtkDataObject)poly);
        this.exporterToSTL.Update();
        this.exporterToSTL.Write();
    }

    public void exportToSTLFileFormat(String path, vtkPolyData poly) throws IOException {
        this.exportToSTLFileFormat(new File(path), poly);
    }

    public void exportToVRMLFileFormat(File file, vtkPolyData poly, vtkRenderWindow renWin) throws IOException {
        this.exporterToVRML = new vtkVRMLExporter();
        this.exporterToVRML.SetFileName(file.getAbsolutePath());
        this.exporterToVRML.SetInput(renWin);
        this.exporterToVRML.SetSpeed(5.5);
        this.exporterToVRML.Update();
        this.exporterToVRML.Write();
    }

    public void exportToVRMLFileFormat(String path, vtkPolyData poly, vtkRenderWindow renWin) throws IOException {
        this.exportToVRMLFileFormat(new File(path), poly, renWin);
    }

    public void exportToX3DFileFormat(File file, vtkPolyData poly, vtkRenderWindow renWin) throws IOException {
        this.exporterToX3D = new vtkX3DExporter();
        this.exporterToX3D.SetFileName(file.getAbsolutePath());
        this.exporterToX3D.SetSpeed(5.5);
        this.exporterToX3D.SetInput(renWin);
        this.exporterToX3D.Update();
        this.exporterToX3D.Write();
    }

    public void exportToX3DFileFormat(String path, vtkPolyData poly, vtkRenderWindow renWin) throws IOException {
        this.exportToX3DFileFormat(new File(path), poly, renWin);
    }
}

