/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.mravisualizer;

import java.util.LinkedHashMap;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.vtk.events.AEventsHandler;
import pt.lsts.neptus.plugins.vtk.filters.Contours;
import pt.lsts.neptus.plugins.vtk.mravisualizer.InteractorStyleVis3D;
import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import pt.lsts.neptus.plugins.vtk.surface.Delauny2D;
import pt.lsts.neptus.plugins.vtk.surface.MeshSmoothingLaplacian;
import pt.lsts.neptus.plugins.vtk.surface.PointCloudMesh;
import vtk.vtkActorCollection;
import vtk.vtkPolyData;
import vtk.vtkProp;
import vtk.vtkRenderer;

public class EventsHandler
extends AEventsHandler {
    protected vtkRenderer renderer;
    protected LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud;
    protected LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh;
    private ColorMappingRelation colorMapRel;
    private SensorTypeInteraction sensorTypeInteraction;
    private RepresentationType representationType;

    public EventsHandler(InteractorStyleVis3D interactorStyle, LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud, LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh, IMraLogGroup source) {
        super(interactorStyle, source);
        this.renderer = interactorStyle.getRenderer();
        this.linkedHashMapCloud = linkedHashMapCloud;
        this.linkedHashMapMesh = linkedHashMapMesh;
        this.init();
    }

    @Override
    protected void init() {
        this.setSensorTypeInteraction(SensorTypeInteraction.NONE);
        this.setColorMapRel(ColorMappingRelation.ZMAP);
        this.setRepresentationType(RepresentationType.REP_POINTS);
        this.setHelpMsg();
    }

    protected APointCloud<?> searchForPointCloudOnRenderer() {
        vtkActorCollection actorCollection = new vtkActorCollection();
        actorCollection = this.getRenderer().GetActors();
        actorCollection.InitTraversal();
        APointCloud<?> pointCloud = null;
        for (int i = 0; i < actorCollection.GetNumberOfItems(); ++i) {
            if (actorCollection.GetNextActor().IsA("vtkActor2D") <= 0) continue;
        }
        return pointCloud;
    }

    @Override
    protected void setHelpMsg() {
        this.msgHelp = "<html><font size='2'><br><div align='center'><table border='1' align='center'><tr><th>Keys</th><th>" + I18n.text((String)"Description") + "</th></tr>" + "<tr><td>p, P</td><td>" + I18n.text((String)"Switch to a point-based representation") + "</td>" + "<tr><td>w, W </td><td>" + I18n.text((String)"Switch to a wireframe-based representation, when available") + "</td>" + "<tr><td>s, S</td><td>" + I18n.text((String)"Switch to a surface-based representation, when available") + "</td>" + "<tr><td>j, J</td><td>" + I18n.text((String)"Take a .PNG snapshot of the current window view") + "</td>" + "<tr><td>g, G</td><td>" + I18n.text((String)"Display scale grid (on/off)") + "</td>" + "<tr><td>u, U</td><td>" + I18n.text((String)"Display lookup table (on/off)") + "</td>" + "<tr><td>r, R</td><td>" + I18n.text((String)"Reset camera view along the current view direction") + "</td>" + "<tr><td>i, I</td><td>" + I18n.text((String)"Information about rendered cloud") + "</td>" + "<tr><td>f, F</td><td>" + I18n.text((String)"Fly Mode - point with mouse cursor the direction and press 'f' to fly") + "</td>" + "<tr><td>+/-</td><td>" + I18n.text((String)"Increment / Decrement overall point size") + "</td>" + "<tr><td>3</td><td>" + I18n.text((String)"Toggle into an out of stereo mode") + "</td>" + "<tr><td>7</td><td>" + I18n.text((String)"Color gradient in relation with X coords (north)") + "</td>" + "<tr><td>8</td><td>" + I18n.text((String)"Color gradient in relation with Y coords (west)") + "</td>" + "<tr><td>9</td><td>" + I18n.text((String)"Color gradient in relation with Z coords (depth)") + "</td>" + "<tr><th>Mouse</th><th>" + I18n.text((String)"Description") + "</th></tr>" + "<tr><td>" + I18n.text((String)"Left mouse button") + "</td><td>" + I18n.text((String)"Rotate camera around its focal point") + "</td>" + "<tr><td>" + I18n.text((String)"Middle mouse button") + "</td><td>" + I18n.text((String)"Pan camera") + "</td>" + "<tr><td>" + I18n.text((String)"Right mouse button") + "</td><td>" + I18n.text((String)"Zoom (In/Out) the camera") + "</td>" + "<tr><td>" + I18n.text((String)"Mouse wheel") + "</td><td>" + I18n.text((String)"Zoom (In/Out) the camera - Static focal point") + "</td>";
    }

    public void performMeshingOnCloud(APointCloud<?> pointCloud) {
        NeptusLog.pub().info((Object)("Create Mesh from pointcloud: " + pointCloud.getCloudName()));
        Delauny2D delauny = new Delauny2D();
        delauny.performDelauny(pointCloud);
        PointCloudMesh mesh = new PointCloudMesh();
        mesh.generateLODActorFromPolyData(delauny.getPolyData());
        this.linkedHashMapMesh.put(pointCloud.getCloudName(), mesh);
    }

    public void performMeshSmoothing(PointCloudMesh mesh) {
        NeptusLog.pub().info((Object)"Smooth mesh: ");
        MeshSmoothingLaplacian smoothing = new MeshSmoothingLaplacian();
        smoothing.performProcessing(mesh);
        mesh.setPolyData(new vtkPolyData());
        mesh.generateLODActorFromPolyData(smoothing.getPolyData());
    }

    public void performContouring(String cloudName) {
        if (this.linkedHashMapMesh.containsKey(cloudName)) {
            Contours contours = this.linkedHashMapMesh.get(cloudName).getContours();
            contours.generateTerrainContours();
            this.renderer.AddActor((vtkProp)this.linkedHashMapMesh.get(cloudName).getContours().getIsolinesActor());
        }
    }

    public void addActorToRenderer(String cloudName) {
        switch (this.getRepresentationType()) {
            case REP_POINTS: {
                if (!this.linkedHashMapCloud.containsKey(cloudName)) break;
                this.renderer.AddActor((vtkProp)this.linkedHashMapCloud.get(cloudName).getCloudLODActor());
                break;
            }
            case REP_WIREFRAME: {
                if (!this.linkedHashMapMesh.containsKey(cloudName)) break;
                this.linkedHashMapMesh.get(cloudName).getMeshCloudLODActor().GetProperty().SetRepresentationToWireframe();
                this.renderer.AddActor((vtkProp)this.linkedHashMapMesh.get(cloudName).getMeshCloudLODActor());
                break;
            }
            case REP_SOLID: {
                if (!this.linkedHashMapMesh.containsKey(cloudName)) break;
                this.linkedHashMapMesh.get(cloudName).getMeshCloudLODActor().GetProperty().SetRepresentationToSurface();
                this.renderer.AddActor((vtkProp)this.linkedHashMapMesh.get(cloudName).getMeshCloudLODActor());
                break;
            }
        }
    }

    public void removeCloudFromRenderer(String cloudName) {
        if (this.linkedHashMapCloud.containsKey(cloudName)) {
            this.renderer.RemoveActor((vtkProp)this.linkedHashMapCloud.get(cloudName).getCloudLODActor());
        }
    }

    public void removeMeshFromRenderer(String cloudName) {
        if (this.linkedHashMapMesh.containsKey(cloudName)) {
            this.renderer.RemoveActor((vtkProp)this.linkedHashMapMesh.get(cloudName).getMeshCloudLODActor());
        }
    }

    public SensorTypeInteraction getSensorTypeInteraction() {
        return this.sensorTypeInteraction;
    }

    public void setSensorTypeInteraction(SensorTypeInteraction sensorTypeInteraction) {
        this.sensorTypeInteraction = sensorTypeInteraction;
    }

    public RepresentationType getRepresentationType() {
        return this.representationType;
    }

    public void setRepresentationType(RepresentationType representationType) {
        this.representationType = representationType;
    }

    protected ColorMappingRelation getColorMapRel() {
        return this.colorMapRel;
    }

    protected void setColorMapRel(ColorMappingRelation colorMapRel) {
        this.colorMapRel = colorMapRel;
    }

    public static enum RepresentationType {
        REP_POINTS,
        REP_WIREFRAME,
        REP_SOLID;

    }

    public static enum SensorTypeInteraction {
        NONE,
        DVL,
        MULTIBEAM,
        ALL;

    }

    private static enum ColorMappingRelation {
        XMAP,
        YMAP,
        ZMAP,
        IMAP;

    }
}

