/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.mravisualizer;

import java.util.LinkedHashMap;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.vtk.mravisualizer.EventsHandler;
import pt.lsts.neptus.plugins.vtk.mravisualizer.KeyboardEvent;
import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import pt.lsts.neptus.plugins.vtk.surface.PointCloudMesh;
import pt.lsts.neptus.plugins.vtk.visualization.AInteractorStyleTrackballCamera;
import pt.lsts.neptus.plugins.vtk.visualization.AxesWidget;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import pt.lsts.neptus.plugins.vtk.visualization.Compass;
import pt.lsts.neptus.plugins.vtk.visualization.ScalarBar;
import vtk.vtkCamera;
import vtk.vtkLegendScaleActor;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkRenderer;
import vtk.vtkScalarBarActor;

public class InteractorStyleVis3D
extends AInteractorStyleTrackballCamera {
    public LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud;
    public LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh;
    private EventsHandler events;
    public vtkCamera camera = new vtkCamera();
    public KeyboardEvent keyboardEvent;
    public InteractorKeyboardModifier interactModifier;
    protected boolean wireframeRepEnabled = false;
    protected boolean solidRepEnabled = false;
    protected boolean pointRepEnabled = true;
    protected boolean compassEnabled;
    protected Compass compass = new Compass();
    protected boolean gridEnabled;
    protected vtkLegendScaleActor gridActor = new vtkLegendScaleActor();
    protected boolean lutEnabled;
    private vtkScalarBarActor lutActor = new vtkScalarBarActor();
    private ScalarBar scalarBar;
    private AxesWidget axesWidget;

    public InteractorStyleVis3D(Canvas canvas, vtkRenderer renderer, vtkRenderWindowInteractor renWinInteractor, LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud, LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh, IMraLogGroup source) {
        super(canvas, renderer, renWinInteractor);
        this.camera = renderer.GetActiveCamera();
        this.linkedHashMapCloud = linkedHashMapCloud;
        this.linkedHashMapMesh = linkedHashMapMesh;
        this.setScalarBar(new ScalarBar());
        this.setEventsHandler(new EventsHandler(this, linkedHashMapCloud, linkedHashMapMesh, source));
        this.keyboardEvent = new KeyboardEvent(this.getCanvas(), this.linkedHashMapCloud, this, this.getEventsHandler());
        this.setAxesWidget(new AxesWidget(renWinInteractor));
        this.onInitialize();
    }

    @Override
    protected void onInitialize() {
        this.UseTimersOn();
        this.HandleObserversOn();
        this.AutoAdjustCameraClippingRangeOn();
        this.getAxesWidget().createAxesWidget();
        this.gridEnabled = false;
        this.lutEnabled = true;
        this.getScalarBar().setScalarBarHorizontalProperties();
        this.compassEnabled = false;
        this.getInteractor().AddObserver("RenderEvent", (Object)this, "callbackFunctionFPS");
        this.getCanvas().addKeyListener(this.keyboardEvent);
    }

    void callbackPointCoords() {
    }

    public vtkScalarBarActor getLutActor() {
        return this.lutActor;
    }

    public void setLutActor(vtkScalarBarActor lutActor) {
        this.lutActor = lutActor;
    }

    public ScalarBar getScalarBar() {
        return this.scalarBar;
    }

    public void setScalarBar(ScalarBar scalarBar) {
        this.scalarBar = scalarBar;
    }

    public EventsHandler getEventsHandler() {
        return this.events;
    }

    private void setEventsHandler(EventsHandler events) {
        this.events = events;
    }

    public AxesWidget getAxesWidget() {
        return this.axesWidget;
    }

    private void setAxesWidget(AxesWidget axesWidget) {
        this.axesWidget = axesWidget;
    }

    private static enum InteractorKeyboardModifier {
        INTERACTOR_KB_MOD_ALT,
        INTERACTOR_KB_MOD_CTRL,
        INTERACTOR_KB_MOD_SHIFT;

    }
}

