/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.mravisualizer;

import java.util.LinkedHashMap;
import java.util.Set;
import pt.lsts.neptus.plugins.vtk.events.AKeyboardEvent;
import pt.lsts.neptus.plugins.vtk.mravisualizer.EventsHandler;
import pt.lsts.neptus.plugins.vtk.mravisualizer.InteractorStyleVis3D;
import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudHandlerXYZ;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudHandlerXYZI;
import pt.lsts.neptus.plugins.vtk.visualization.AInteractorStyleTrackballCamera;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import vtk.vtkAbstractPropPicker;
import vtk.vtkActorCollection;
import vtk.vtkAssemblyPath;
import vtk.vtkDataArray;
import vtk.vtkLODActor;
import vtk.vtkProp;
import vtk.vtkScalarsToColors;

public class KeyboardEvent
extends AKeyboardEvent {
    private InteractorStyleVis3D interactorStyle;
    private final EventsHandler events;
    private final LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud;
    private Set<String> setOfClouds;
    private APointCloud<?> pointCloud;
    private boolean markerEnabled = false;
    public ColorMappingRelation colorMapRel;

    public KeyboardEvent(Canvas canvas, LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud, InteractorStyleVis3D interactorStyle, EventsHandler events) {
        super(canvas);
        this.setInteractorStyle(interactorStyle);
        this.events = events;
        this.linkedHashMapCloud = linkedHashMapCloud;
        this.colorMapRel = ColorMappingRelation.zMap;
    }

    @Override
    public void handleEvents(int keyCode) {
        switch (keyCode) {
            case 74: {
                this.events.takeSnapShot("Bathymetry_");
                break;
            }
            case 85: {
                try {
                    if (!this.interactorStyle.lutEnabled) {
                        vtkActorCollection actorCollection = new vtkActorCollection();
                        actorCollection = this.getRenderer().GetActors();
                        actorCollection.InitTraversal();
                        for (int i = 0; i < actorCollection.GetNumberOfItems(); ++i) {
                            if (actorCollection.GetNextActor().IsA("vtkActor2D") > 0) continue;
                            this.setOfClouds = this.linkedHashMapCloud.keySet();
                            for (String skey : this.setOfClouds) {
                                this.pointCloud = this.linkedHashMapCloud.get(skey);
                                switch (this.colorMapRel) {
                                    case xMap: {
                                        this.interactorStyle.getScalarBar().setUpScalarBarLookupTable((vtkScalarsToColors)((PointCloudHandlerXYZ)this.pointCloud.getColorHandler()).getLutX());
                                        break;
                                    }
                                    case yMap: {
                                        this.interactorStyle.getScalarBar().setUpScalarBarLookupTable((vtkScalarsToColors)((PointCloudHandlerXYZ)this.pointCloud.getColorHandler()).getLutY());
                                        break;
                                    }
                                    case zMap: {
                                        this.interactorStyle.getScalarBar().setUpScalarBarLookupTable((vtkScalarsToColors)((PointCloudHandlerXYZ)this.pointCloud.getColorHandler()).getLutZ());
                                        break;
                                    }
                                    case iMap: {
                                        if (!(this.pointCloud.getColorHandler() instanceof PointCloudHandlerXYZI)) break;
                                        this.interactorStyle.getScalarBar().setUpScalarBarLookupTable((vtkScalarsToColors)((PointCloudHandlerXYZI)this.pointCloud.getColorHandler()).getLutI());
                                        break;
                                    }
                                }
                            }
                        }
                        this.getCanvas().lock();
                        this.getRenderer().AddActor((vtkProp)this.interactorStyle.getScalarBar().getScalarBarActor());
                        this.getCanvas().unlock();
                        this.interactorStyle.lutEnabled = true;
                    } else {
                        this.getCanvas().lock();
                        this.getRenderer().RemoveActor((vtkProp)this.interactorStyle.getScalarBar().getScalarBarActor());
                        this.getCanvas().unlock();
                        this.interactorStyle.lutEnabled = false;
                    }
                    this.getCanvas().lock();
                    this.getCanvas().Render();
                    this.getCanvas().unlock();
                }
                catch (Exception e6) {
                    e6.printStackTrace();
                }
                break;
            }
            case 71: {
                try {
                    if (!this.interactorStyle.gridEnabled) {
                        this.interactorStyle.gridActor.TopAxisVisibilityOn();
                        this.getCanvas().lock();
                        this.getRenderer().AddViewProp((vtkProp)this.interactorStyle.gridActor);
                        this.getCanvas().unlock();
                        this.interactorStyle.gridEnabled = true;
                    } else {
                        this.getCanvas().lock();
                        this.getRenderer().RemoveViewProp((vtkProp)this.interactorStyle.gridActor);
                        this.getCanvas().unlock();
                        this.interactorStyle.gridEnabled = false;
                    }
                    this.getCanvas().lock();
                    this.getCanvas().Render();
                    this.getCanvas().unlock();
                }
                catch (Exception e5) {
                    e5.printStackTrace();
                }
                break;
            }
            case 77: {
                try {
                    this.getCanvas().lock();
                    this.markerEnabled = !this.markerEnabled;
                    this.getCanvas().unlock();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                break;
            }
            case 73: {
                break;
            }
            case 521: {
                try {
                    vtkActorCollection actorCollection = new vtkActorCollection();
                    actorCollection = this.getRenderer().GetActors();
                    actorCollection.InitTraversal();
                    for (int i = 0; i < actorCollection.GetNumberOfItems(); ++i) {
                        vtkLODActor tempActor = new vtkLODActor();
                        tempActor = (vtkLODActor)actorCollection.GetNextActor();
                        this.setOfClouds = this.linkedHashMapCloud.keySet();
                        for (String sKey : this.setOfClouds) {
                            double pointSize;
                            this.pointCloud = this.linkedHashMapCloud.get(sKey);
                            if (!tempActor.equals(this.pointCloud.getCloudLODActor()) || !((pointSize = tempActor.GetProperty().GetPointSize()) <= 9.0)) continue;
                            this.getCanvas().lock();
                            tempActor.GetProperty().SetPointSize(pointSize + 1.0);
                            this.getCanvas().Render();
                            this.getCanvas().unlock();
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            case 45: {
                try {
                    vtkActorCollection actorCollection = new vtkActorCollection();
                    actorCollection = this.getRenderer().GetActors();
                    actorCollection.InitTraversal();
                    for (int i = 0; i < actorCollection.GetNumberOfItems(); ++i) {
                        vtkLODActor tempActor = new vtkLODActor();
                        tempActor = (vtkLODActor)actorCollection.GetNextActor();
                        this.setOfClouds = this.linkedHashMapCloud.keySet();
                        for (String sKey : this.setOfClouds) {
                            double pointSize;
                            this.pointCloud = this.linkedHashMapCloud.get(sKey);
                            if (!tempActor.equals(this.pointCloud.getCloudLODActor()) || !((pointSize = tempActor.GetProperty().GetPointSize()) > 1.0)) continue;
                            this.getCanvas().lock();
                            tempActor.GetProperty().SetPointSize(pointSize - 1.0);
                            this.getCanvas().Render();
                            this.getCanvas().unlock();
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            case 55: {
                try {
                    if (this.colorMapRel == ColorMappingRelation.xMap) break;
                    this.setOfClouds = this.linkedHashMapCloud.keySet();
                    for (String sKey : this.setOfClouds) {
                        this.pointCloud = this.linkedHashMapCloud.get(sKey);
                        this.pointCloud.getPolyData().GetPointData().SetScalars((vtkDataArray)((PointCloudHandlerXYZ)this.pointCloud.getColorHandler()).getColorsX());
                        if (this.interactorStyle.lutEnabled) {
                            this.interactorStyle.getScalarBar().setUpScalarBarLookupTable((vtkScalarsToColors)((PointCloudHandlerXYZ)this.pointCloud.getColorHandler()).getLutX());
                        }
                        this.colorMapRel = ColorMappingRelation.xMap;
                    }
                    this.getCanvas().lock();
                    this.getCanvas().Render();
                    this.getCanvas().unlock();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 56: {
                try {
                    if (this.colorMapRel == ColorMappingRelation.yMap) break;
                    this.setOfClouds = this.linkedHashMapCloud.keySet();
                    for (String sKey : this.setOfClouds) {
                        this.pointCloud = this.linkedHashMapCloud.get(sKey);
                        this.pointCloud.getPolyData().GetPointData().SetScalars((vtkDataArray)((PointCloudHandlerXYZ)this.pointCloud.getColorHandler()).getColorsY());
                        if (this.interactorStyle.lutEnabled) {
                            this.interactorStyle.getScalarBar().setUpScalarBarLookupTable((vtkScalarsToColors)((PointCloudHandlerXYZ)this.pointCloud.getColorHandler()).getLutY());
                        }
                        this.colorMapRel = ColorMappingRelation.yMap;
                    }
                    this.getCanvas().lock();
                    this.getCanvas().Render();
                    this.getCanvas().unlock();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 57: {
                try {
                    if (this.colorMapRel == ColorMappingRelation.zMap) break;
                    this.setOfClouds = this.linkedHashMapCloud.keySet();
                    for (String sKey : this.setOfClouds) {
                        this.pointCloud = this.linkedHashMapCloud.get(sKey);
                        this.pointCloud.getPolyData().GetPointData().SetScalars((vtkDataArray)((PointCloudHandlerXYZ)this.pointCloud.getColorHandler()).getColorsZ());
                        if (this.interactorStyle.lutEnabled) {
                            this.interactorStyle.getScalarBar().setUpScalarBarLookupTable((vtkScalarsToColors)((PointCloudHandlerXYZ)this.pointCloud.getColorHandler()).getLutZ());
                        }
                        this.colorMapRel = ColorMappingRelation.zMap;
                    }
                    this.getCanvas().lock();
                    this.getCanvas().Render();
                    this.getCanvas().unlock();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 82: {
                try {
                    this.getCanvas().lock();
                    this.getRenderer().GetActiveCamera().SetViewUp(0.0, 0.0, -1.0);
                    this.getRenderer().ResetCamera();
                    this.getCanvas().Render();
                    this.getCanvas().unlock();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 70: {
                this.getCanvas().lock();
                vtkAssemblyPath path = null;
                this.interactorStyle.FindPokedRenderer(this.getInteractor().GetEventPosition()[0], this.getInteractor().GetEventPosition()[1]);
                this.getInteractor().GetPicker().Pick((double)this.getInteractor().GetEventPosition()[0], (double)this.getInteractor().GetEventPosition()[1], 0.0, this.getRenderer());
                vtkAbstractPropPicker picker = (vtkAbstractPropPicker)this.getInteractor().GetPicker();
                if (picker != null) {
                    path = picker.GetPath();
                }
                if (path != null) {
                    this.getInteractor().FlyTo(this.getRenderer(), picker.GetPickPosition()[0], picker.GetPickPosition()[1], picker.GetPickPosition()[2]);
                }
                this.getCanvas().unlock();
                break;
            }
        }
    }

    @Override
    protected void setInteractorStyle(AInteractorStyleTrackballCamera interactorStyle) {
        this.interactorStyle = (InteractorStyleVis3D)interactorStyle;
    }

    private static enum ColorMappingRelation {
        xMap,
        yMap,
        zMap,
        iMap;

    }
}

