/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.mravisualizer;

import java.util.Date;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mra.MRAProperties;
import pt.lsts.neptus.mra.api.BathymetryInfo;
import pt.lsts.neptus.mra.api.BathymetryParser;
import pt.lsts.neptus.mra.api.BathymetryParserFactory;
import pt.lsts.neptus.mra.api.BathymetryPoint;
import pt.lsts.neptus.mra.api.BathymetrySwath;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.importers.lsf.DVLBathymetryParser;
import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.bathymetry.TidePredictionFactory;
import pt.lsts.neptus.util.bathymetry.TidePredictionFinder;
import vtk.vtkPoints;
import vtk.vtkShortArray;

public class LoadToPointCloud {
    public IMraLogGroup source;
    public IMraLog state;
    public BathymetryInfo batInfo;
    public BathymetryParser parser;
    public APointCloud<?> pointCloud;
    private TidePredictionFinder finder;
    private boolean alreadyTriedToLoadTideFinder = false;
    private vtkPoints points;
    private vtkShortArray intensities;

    public LoadToPointCloud(IMraLogGroup log, APointCloud<?> pointCloud) {
        this.source = log;
        this.pointCloud = pointCloud;
    }

    private double getTideOffset(long timestampMillis) {
        try {
            if (this.finder == null) {
                return 0.0;
            }
            Float ret = this.finder.getTidePrediction(new Date(timestampMillis), false);
            return ret == null || ret.isNaN() || ret.isInfinite() ? 0.0 : (double)ret.floatValue();
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e.getMessage(), (Throwable)e);
            return 0.0;
        }
    }

    public void parseMultibeamPointCloud() {
        BathymetrySwath bs;
        this.parser = BathymetryParserFactory.build((IMraLogGroup)this.source, (String)"multibeam");
        this.getOrCreateTideDataProvider();
        this.parser.rewind();
        this.setPoints(new vtkPoints());
        this.setIntensities(new vtkShortArray());
        int countPoints = 0;
        LocationType initLoc = null;
        while ((bs = this.parser.nextSwath()) != null) {
            double[] offset;
            LocationType tempLoc;
            BathymetryPoint p;
            int c;
            LocationType loc = bs.getPose().getPosition();
            if (initLoc == null) {
                initLoc = new LocationType(loc);
            }
            double tideOffset = this.getTideOffset(bs.getTimestamp());
            if (!MRAProperties.approachToIgnorePts) {
                for (c = 0; c < bs.getNumBeams(); c += MRAProperties.ptsToIgnore) {
                    p = bs.getData()[c];
                    if (p == null) continue;
                    tempLoc = new LocationType(loc);
                    tempLoc.translatePosition((double)p.north, (double)p.east, 0.0);
                    offset = tempLoc.getOffsetFrom(initLoc);
                    this.getPoints().InsertNextPoint(offset[0], offset[1], (double)p.depth - tideOffset);
                    if (this.parser.getHasIntensity()) {
                        this.getIntensities().InsertValue(c, (int)p.intensity);
                    }
                    ++countPoints;
                }
                continue;
            }
            for (c = 0; c < bs.getNumBeams(); ++c) {
                if (Math.random() > 1.0 / (double)MRAProperties.ptsToIgnore || (p = bs.getData()[c]) == null) continue;
                tempLoc = new LocationType(loc);
                tempLoc.translatePosition((double)p.north, (double)p.east, 0.0);
                offset = tempLoc.getOffsetFrom(initLoc);
                this.getPoints().InsertNextPoint(offset[0], offset[1], (double)p.depth - tideOffset);
                ++countPoints;
            }
        }
        this.parser.getBathymetryInfo().totalNumberOfPoints = countPoints;
        this.batInfo = this.parser.getBathymetryInfo();
        this.pointCloud.setNumberOfPoints(this.parser.getBathymetryInfo().totalNumberOfPoints);
        NeptusLog.pub().info((Object)("Total number of points: " + this.parser.getBathymetryInfo().totalNumberOfPoints));
        NeptusLog.pub().info((Object)("Number of points on multibeamtopointcloud: " + this.getPoints().GetNumberOfPoints()));
    }

    public void parseDVLPointCloud() {
        this.parser = BathymetryParserFactory.build((IMraLogGroup)this.source, (String)"dvl");
        if (this.parser instanceof DVLBathymetryParser) {
            BathymetrySwath bs;
            this.getOrCreateTideDataProvider();
            NeptusLog.pub().info((Object)"Parsing dvl points to vtk points");
            this.parser.rewind();
            this.setPoints(new vtkPoints());
            int countPoints = 0;
            LocationType initLoc = null;
            while ((bs = this.parser.nextSwath()) != null) {
                LocationType loc = bs.getPose().getPosition();
                if (initLoc == null) {
                    initLoc = new LocationType(loc);
                }
                double tideOffset = this.getTideOffset(bs.getTimestamp());
                for (int c = 0; c < bs.getNumBeams(); ++c) {
                    BathymetryPoint p = bs.getData()[c];
                    if (p == null) continue;
                    LocationType tempLoc = new LocationType(loc);
                    tempLoc.translatePosition((double)p.north, (double)p.east, 0.0);
                    double[] offset = tempLoc.getOffsetFrom(initLoc);
                    this.getPoints().InsertNextPoint(offset[0], offset[1], (double)p.depth - tideOffset);
                    ++countPoints;
                }
            }
            NeptusLog.pub().info((Object)("number of points: " + countPoints));
            this.parser.getBathymetryInfo().totalNumberOfPoints = countPoints;
            this.batInfo = this.parser.getBathymetryInfo();
            this.pointCloud.setNumberOfPoints(this.parser.getBathymetryInfo().totalNumberOfPoints);
        }
    }

    private void getOrCreateTideDataProvider() {
        if (!this.alreadyTriedToLoadTideFinder && this.finder == null) {
            this.finder = TidePredictionFactory.create((LsfIndex)this.source.getLsfIndex());
        }
        if (this.finder == null) {
            NeptusLog.pub().warn((Object)"No tides data found!!");
        }
        this.alreadyTriedToLoadTideFinder = true;
    }

    public vtkPoints getPoints() {
        return this.points;
    }

    public void setPoints(vtkPoints points) {
        this.points = points;
    }

    public vtkShortArray getIntensities() {
        return this.intensities;
    }

    public void setIntensities(vtkShortArray intensities) {
        this.intensities = intensities;
    }

    public void showIntensities() {
        NeptusLog.pub().info((Object)("Number of intensities values: " + this.getIntensities().GetSize()));
        for (int i = 0; i < this.getIntensities().GetSize(); ++i) {
        }
    }
}

