/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.mravisualizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.vtk.VtkMRAVis;
import pt.lsts.neptus.plugins.vtk.io.Writer3D;
import pt.lsts.neptus.plugins.vtk.mravisualizer.EventsHandler;
import pt.lsts.neptus.plugins.vtk.mravisualizer.VisAction;
import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import pt.lsts.neptus.plugins.vtk.surface.PointCloudMesh;
import pt.lsts.neptus.plugins.vtk.utils.File3DUtils;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import vtk.vtkActorCollection;
import vtk.vtkLODActor;
import vtk.vtkPolyData;
import vtk.vtkRenderer;

public class Vis3DMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private final VtkMRAVis vtkInit;
    private final Canvas canvas;
    private final vtkRenderer renderer;
    private final EventsHandler events;
    private final LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud;
    private final LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh;
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu viewMenu;
    private JMenu toolsMenu;
    private JMenu helpMenu;
    private AbstractAction saveFile;
    private AbstractAction saveFileAsPointCloud;
    private AbstractAction saveFileAsMesh;
    private AbstractAction configs;
    private AbstractAction resetViewportCamera;
    private AbstractAction takeSnapShot;
    private AbstractAction help;

    public Vis3DMenuBar(VtkMRAVis vtkInit) {
        this.vtkInit = vtkInit;
        this.events = vtkInit.getEvents();
        this.canvas = vtkInit.getCanvas();
        this.renderer = vtkInit.getCanvas().GetRenderer();
        this.linkedHashMapCloud = vtkInit.getLinkedHashMapCloud();
        this.linkedHashMapMesh = vtkInit.getLinkedHashMapMesh();
    }

    public void createMenuBar() {
        this.setUpFileMenu();
        this.setUpEditMenu();
        this.setUpViewMenu();
        this.setUpToolsMenu();
        this.setUpHelpMenu();
        JLabel label = new JLabel(I18n.text((String)"3D Bathymetry Visualization"));
        label.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        label.setFont(new Font("Verdana", 3, 10));
        label.setForeground(Color.BLACK);
        this.add(label);
        this.add(this.fileMenu);
        this.add(this.editMenu);
        this.add(this.viewMenu);
        this.add(this.toolsMenu);
        this.add(this.helpMenu);
    }

    private void setUpFileMenu() {
        this.fileMenu = new JMenu(I18n.text((String)"File"));
        this.saveFile = new VisAction(I18n.text((String)"Save file"), ImageUtils.getIcon((String)"images/menus/save.png"), I18n.text((String)"Save file"), KeyStroke.getKeyStroke(83, 128, true)){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.saveFileAsPointCloud = new VisAction(I18n.text((String)"Save pointcloud as") + "...", ImageUtils.getIcon((String)"images/menus/saveas.png"), I18n.text((String)"Save a pointcloud to a file") + ".", KeyStroke.getKeyStroke(80, 128, true)){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(Vis3DMenuBar.this.vtkInit.getLog().getFile("Data.lsf").getParentFile());
                FileFilter filefilter = GuiUtils.getCustomFileFilter((String)(I18n.text((String)"3D files ") + "*.vtk" + ", *.stl" + ", *.ply" + ", *.obj" + ", *.wrl" + " *.x3d"), (String[])File3DUtils.TYPES_3D_FILES);
                chooser.setFileFilter(filefilter);
                int ans = chooser.showDialog(Vis3DMenuBar.this.vtkInit, I18n.text((String)"Save as") + "...");
                if (ans == 0) {
                    if (chooser.getSelectedFile().exists() && (ans = JOptionPane.showConfirmDialog(Vis3DMenuBar.this.vtkInit, I18n.text((String)"Are you sure you want to overwrite existing file") + "?", I18n.text((String)"Save file as") + "...", 0)) != 0) {
                        return;
                    }
                    File dst = chooser.getSelectedFile();
                    String ext = File3DUtils.getExtension(dst);
                    NeptusLog.pub().info((Object)("Extension: " + ext));
                    File3DUtils.FileType type = null;
                    type = File3DUtils.getFileType(ext);
                    NeptusLog.pub().info((Object)("Filetype: " + type.toString()));
                    Writer3D writer3d = new Writer3D();
                    vtkPolyData poly = new vtkPolyData();
                    vtkActorCollection actorCollection = new vtkActorCollection();
                    actorCollection = Vis3DMenuBar.this.renderer.GetActors();
                    actorCollection.InitTraversal();
                    int numItems = actorCollection.GetNumberOfItems();
                    for (int i = 0; i < numItems; ++i) {
                        vtkLODActor tempActor = new vtkLODActor();
                        tempActor = (vtkLODActor)actorCollection.GetNextActor();
                        Set setOfClouds = Vis3DMenuBar.this.linkedHashMapCloud.keySet();
                        for (String cloudsKey : setOfClouds) {
                            APointCloud pointCloud = (APointCloud)Vis3DMenuBar.this.linkedHashMapCloud.get(cloudsKey);
                            if (!tempActor.equals(pointCloud.getCloudLODActor())) continue;
                            poly = pointCloud.getPolyData();
                        }
                    }
                    writer3d.save3dFileType(type, chooser.getSelectedFile(), poly, Vis3DMenuBar.this.canvas);
                }
            }
        };
        this.saveFileAsMesh = new VisAction(I18n.text((String)"Save generated pointcloud mesh as") + "...", ImageUtils.getIcon((String)"images/menus/saveas.png"), I18n.text((String)"Save mesh to a file") + ".", KeyStroke.getKeyStroke(77, 128, true)){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(Vis3DMenuBar.this.vtkInit.getLog().getFile("Data.lsf").getParentFile());
                FileFilter filefilter = GuiUtils.getCustomFileFilter((String)(I18n.text((String)"3D files ") + "*.vtk" + ", *.stl" + ", *.ply" + ", *.obj" + ", *.wrl" + " *.x3d"), (String[])File3DUtils.TYPES_3D_FILES);
                chooser.setFileFilter(filefilter);
                int ans = chooser.showDialog(Vis3DMenuBar.this.vtkInit, I18n.text((String)"Save as") + "...");
                if (ans == 0) {
                    if (chooser.getSelectedFile().exists() && (ans = JOptionPane.showConfirmDialog(Vis3DMenuBar.this.vtkInit, I18n.text((String)"Are you sure you want to overwrite existing file") + "?", I18n.text((String)"Save file as") + "...", 0)) != 0) {
                        return;
                    }
                    File dst = chooser.getSelectedFile();
                    String ext = File3DUtils.getExtension(dst);
                    NeptusLog.pub().info((Object)("Extension: " + ext));
                    File3DUtils.FileType type = File3DUtils.getFileType(ext);
                    NeptusLog.pub().info((Object)("Filetype: " + type.toString()));
                    Writer3D writer3d = new Writer3D();
                    vtkPolyData poly = new vtkPolyData();
                    vtkActorCollection actorCollection = new vtkActorCollection();
                    actorCollection = Vis3DMenuBar.this.renderer.GetActors();
                    actorCollection.InitTraversal();
                    int numItems = actorCollection.GetNumberOfItems();
                    for (int i = 0; i < numItems; ++i) {
                        vtkLODActor tempActor = new vtkLODActor();
                        tempActor = (vtkLODActor)actorCollection.GetNextActor();
                        Set setOfMeshs = Vis3DMenuBar.this.linkedHashMapMesh.keySet();
                        for (String meshsKey : setOfMeshs) {
                            PointCloudMesh pointCloud = (PointCloudMesh)Vis3DMenuBar.this.linkedHashMapMesh.get(meshsKey);
                            if (!tempActor.equals(pointCloud.getMeshCloudLODActor())) continue;
                            poly = pointCloud.getPolyData();
                        }
                    }
                    writer3d.save3dFileType(type, chooser.getSelectedFile(), poly, Vis3DMenuBar.this.canvas);
                }
            }
        };
        this.fileMenu.add(this.saveFile);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveFileAsPointCloud);
        this.fileMenu.add(this.saveFileAsMesh);
    }

    private void setUpEditMenu() {
        this.editMenu = new JMenu(I18n.text((String)"Edit"));
        this.configs = new VisAction(I18n.text((String)"Configurations"), ImageUtils.getIcon((String)"images/menus/configure.png"), I18n.text((String)"3DVisualizer configurations") + ".", KeyStroke.getKeyStroke(69, 128, true)){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)Vis3DMenuBar.this.vtkInit, (boolean)true);
            }
        };
        this.editMenu.add(this.configs);
    }

    private void setUpViewMenu() {
        this.viewMenu = new JMenu(I18n.text((String)"View"));
        this.resetViewportCamera = new VisAction(I18n.text((String)"Reset Viewport"), ImageUtils.getIcon((String)"images/menus/camera.png"), I18n.text((String)"Reset Viewport") + ".", KeyStroke.getKeyStroke(82, 128, true)){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vis3DMenuBar.this.events.resetViewport();
            }
        };
        this.viewMenu.add(this.resetViewportCamera);
    }

    private void setUpToolsMenu() {
        this.toolsMenu = new JMenu(I18n.text((String)"Tools"));
        this.takeSnapShot = new VisAction(I18n.text((String)"Take SnapShot"), ImageUtils.getIcon((String)"images/menus/camera.png"), I18n.text((String)"Take SnapShot from current Viewport") + "."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vis3DMenuBar.this.events.takeSnapShot("Bathymetry_");
            }
        };
        this.toolsMenu.add(this.takeSnapShot);
    }

    private void setUpHelpMenu() {
        this.helpMenu = new JMenu(I18n.text((String)"Help"));
        this.help = new VisAction(I18n.text((String)"Help"), ImageUtils.getIcon((String)"images/menus/info.png"), I18n.text((String)"Help 3D Visualizer") + ".", KeyStroke.getKeyStroke(72, 128)){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtils.htmlMessage((Component)(ConfigFetch.getSuperParentFrame() == null ? Vis3DMenuBar.this.vtkInit : ConfigFetch.getSuperParentAsFrame()), (String)(I18n.text((String)"3D Visualization Interaction Help") + "."), (String)("(" + I18n.text((String)"3D Multibeam keyboard and mouse interation") + ")"), (String)Vis3DMenuBar.this.events.getMsgHelp(), (Dialog.ModalityType)Dialog.ModalityType.MODELESS);
            }
        };
        this.helpMenu.add(this.help);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D graphic2d = (Graphics2D)g;
        Color color1 = this.getBackground();
        Color color2 = Color.GRAY;
        GradientPaint gradPaint = new GradientPaint(0.0f, 0.0f, color1, this.getWidth(), this.getHeight(), color2);
        graphic2d.setPaint(gradPaint);
        graphic2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }
}

