/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.mravisualizer;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.vtk.VtkMRAVis;
import pt.lsts.neptus.plugins.vtk.mravisualizer.EventsHandler;
import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import pt.lsts.neptus.plugins.vtk.pointcloud.DepthExaggeration;
import pt.lsts.neptus.plugins.vtk.surface.PointCloudMesh;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import vtk.vtkProp;

public class Vis3DToolBar
extends JToolBar {
    private static final short ICON_SIZE = 18;
    private static final ImageIcon ICON_MULTIBEAM = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/vtk/assets/multibeam.png", (int)18, (int)18);
    private static final ImageIcon ICON_DVL = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/vtk/assets/dvl.png", (int)18, (int)18);
    private static final ImageIcon ICON_POINTS = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/vtk/assets/points.png", (int)18, (int)18);
    private static final ImageIcon ICON_WIREFRAME = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/vtk/assets/wire.png", (int)18, (int)18);
    private static final ImageIcon ICON_SOLID = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/vtk/assets/textures.png", (int)18, (int)18);
    private static final ImageIcon ICON_Z = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/vtk/assets/zexaggerate.png", (int)18, (int)18);
    private static final ImageIcon ICON_CONTOURS = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/vtk/assets/contours.png", (int)18, (int)18);
    private static final ImageIcon ICON_MESHING = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/vtk/assets/meshing.png", (int)18, (int)18);
    private static final ImageIcon ICON_SMOOTHING = ImageUtils.getScaledIcon((String)"pt/lsts/neptus/plugins/vtk/assets/smoothing.png", (int)18, (int)18);
    private static final ImageIcon ICON_RESETVIEWPORT = ImageUtils.getScaledIcon((String)"images/menus/camera.png", (int)18, (int)18);
    private static final String MB_CLOUD_NAME = "multibeam";
    private static final String DVL_CLOUD_NAME = "dvl";
    private VtkMRAVis vtkInit;
    private Canvas canvas;
    private EventsHandler events;
    private LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud;
    private LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh;
    public JToggleButton multibeamToggle;
    public JToggleButton dvlToggle;
    private JToggleButton rawPointsToggle;
    private JToggleButton wireframeToggle;
    private JToggleButton solidToggle;
    private JToggleButton zExaggerationToggle;
    private JToggleButton contoursToggle;
    private JToggleButton meshingToggle;
    private JToggleButton smoothingMeshToggle;
    private JButton resetViewportButton;
    ActionListener sensorTypeInteracActionMutibeam = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            EventsHandler.SensorTypeInteraction sensorTypeInt = Vis3DToolBar.this.events.getSensorTypeInteraction();
            if (Vis3DToolBar.this.multibeamToggle.isSelected()) {
                sensorTypeInt = Vis3DToolBar.this.dvlToggle.isSelected() ? EventsHandler.SensorTypeInteraction.ALL : EventsHandler.SensorTypeInteraction.MULTIBEAM;
                Vis3DToolBar.this.events.setSensorTypeInteraction(sensorTypeInt);
                if (!Vis3DToolBar.this.linkedHashMapCloud.containsKey(Vis3DToolBar.MB_CLOUD_NAME)) {
                    Vis3DToolBar.this.vtkInit.loadCloudBySensorType(Vis3DToolBar.MB_CLOUD_NAME);
                }
                Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                Vis3DToolBar.this.canvas.Render();
            } else if (!Vis3DToolBar.this.multibeamToggle.isSelected()) {
                sensorTypeInt = Vis3DToolBar.this.dvlToggle.isSelected() ? EventsHandler.SensorTypeInteraction.DVL : EventsHandler.SensorTypeInteraction.NONE;
                Vis3DToolBar.this.events.setSensorTypeInteraction(sensorTypeInt);
                if (Vis3DToolBar.this.linkedHashMapCloud.containsKey(Vis3DToolBar.MB_CLOUD_NAME)) {
                    Vis3DToolBar.this.events.removeCloudFromRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                    Vis3DToolBar.this.events.removeMeshFromRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                }
                Vis3DToolBar.this.canvas.Render();
            }
            if (Vis3DToolBar.this.multibeamToggle.isSelected() && Vis3DToolBar.this.dvlToggle.isSelected()) {
                sensorTypeInt = EventsHandler.SensorTypeInteraction.ALL;
            }
            if (!Vis3DToolBar.this.multibeamToggle.isSelected() && !Vis3DToolBar.this.dvlToggle.isSelected()) {
                sensorTypeInt = EventsHandler.SensorTypeInteraction.NONE;
            }
            NeptusLog.pub().info((Object)("Sensor representation type: " + Vis3DToolBar.this.events.getSensorTypeInteraction().toString()));
            NeptusLog.pub().info((Object)("Representation type: " + Vis3DToolBar.this.events.getRepresentationType().toString()));
        }
    };
    ActionListener sensorTypeInteracActionDVL = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            EventsHandler.SensorTypeInteraction sensorTypeInt = Vis3DToolBar.this.events.getSensorTypeInteraction();
            if (Vis3DToolBar.this.dvlToggle.isSelected()) {
                sensorTypeInt = Vis3DToolBar.this.multibeamToggle.isSelected() ? EventsHandler.SensorTypeInteraction.ALL : EventsHandler.SensorTypeInteraction.DVL;
                Vis3DToolBar.this.events.setSensorTypeInteraction(sensorTypeInt);
                if (!Vis3DToolBar.this.linkedHashMapCloud.containsKey(Vis3DToolBar.DVL_CLOUD_NAME)) {
                    Vis3DToolBar.this.vtkInit.loadCloudBySensorType(Vis3DToolBar.DVL_CLOUD_NAME);
                }
                Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                Vis3DToolBar.this.canvas.Render();
            } else if (!Vis3DToolBar.this.dvlToggle.isSelected()) {
                sensorTypeInt = Vis3DToolBar.this.multibeamToggle.isSelected() ? EventsHandler.SensorTypeInteraction.MULTIBEAM : EventsHandler.SensorTypeInteraction.NONE;
                Vis3DToolBar.this.events.setSensorTypeInteraction(sensorTypeInt);
                Vis3DToolBar.this.events.removeCloudFromRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                Vis3DToolBar.this.events.removeMeshFromRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                Vis3DToolBar.this.canvas.Render();
            }
            if (Vis3DToolBar.this.multibeamToggle.isSelected() && Vis3DToolBar.this.dvlToggle.isSelected()) {
                sensorTypeInt = EventsHandler.SensorTypeInteraction.ALL;
            }
            if (!Vis3DToolBar.this.multibeamToggle.isSelected() && !Vis3DToolBar.this.dvlToggle.isSelected()) {
                sensorTypeInt = EventsHandler.SensorTypeInteraction.NONE;
            }
            NeptusLog.pub().info((Object)("Sensor representation type: " + Vis3DToolBar.this.events.getSensorTypeInteraction().toString()));
            NeptusLog.pub().info((Object)("Representation type: " + Vis3DToolBar.this.events.getRepresentationType().toString()));
        }
    };
    ActionListener renderRepresentationTypeAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Vis3DToolBar.this.rawPointsToggle.isSelected()) {
                Vis3DToolBar.this.events.setRepresentationType(EventsHandler.RepresentationType.REP_POINTS);
                Vis3DToolBar.this.canvas.lock();
                Set meshsKeySet = Vis3DToolBar.this.linkedHashMapMesh.keySet();
                if (meshsKeySet.size() > 0) {
                    for (String key : meshsKeySet) {
                        Vis3DToolBar.this.events.removeMeshFromRenderer(key);
                    }
                }
                switch (Vis3DToolBar.this.events.getSensorTypeInteraction()) {
                    case ALL: {
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                        break;
                    }
                    case MULTIBEAM: {
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                        break;
                    }
                    case DVL: {
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                        break;
                    }
                }
                Vis3DToolBar.this.canvas.Render();
                Vis3DToolBar.this.canvas.unlock();
            } else if (Vis3DToolBar.this.wireframeToggle.isSelected()) {
                if (!Vis3DToolBar.this.meshingToggle.isSelected()) {
                    Vis3DToolBar.this.meshingToggle.doClick();
                }
                Vis3DToolBar.this.events.setRepresentationType(EventsHandler.RepresentationType.REP_WIREFRAME);
                Vis3DToolBar.this.canvas.lock();
                Set cloudKeySet = Vis3DToolBar.this.linkedHashMapCloud.keySet();
                for (String key : cloudKeySet) {
                    Vis3DToolBar.this.events.removeCloudFromRenderer(key);
                }
                Set meshsKeySet = Vis3DToolBar.this.linkedHashMapMesh.keySet();
                if (meshsKeySet.size() > 0) {
                    for (String key : meshsKeySet) {
                        Vis3DToolBar.this.events.removeMeshFromRenderer(key);
                    }
                }
                switch (Vis3DToolBar.this.events.getSensorTypeInteraction()) {
                    case ALL: {
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                        break;
                    }
                    case MULTIBEAM: {
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                        break;
                    }
                    case DVL: {
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                        break;
                    }
                }
                Vis3DToolBar.this.canvas.Render();
                Vis3DToolBar.this.canvas.unlock();
            } else if (Vis3DToolBar.this.solidToggle.isSelected()) {
                if (!Vis3DToolBar.this.meshingToggle.isSelected()) {
                    Vis3DToolBar.this.meshingToggle.doClick();
                }
                Vis3DToolBar.this.events.setRepresentationType(EventsHandler.RepresentationType.REP_SOLID);
                Vis3DToolBar.this.canvas.lock();
                Set cloudKeySet = Vis3DToolBar.this.linkedHashMapCloud.keySet();
                for (String key : cloudKeySet) {
                    Vis3DToolBar.this.events.removeCloudFromRenderer(key);
                }
                Set meshsKeySet = Vis3DToolBar.this.linkedHashMapMesh.keySet();
                if (meshsKeySet.size() > 0) {
                    for (String key : meshsKeySet) {
                        Vis3DToolBar.this.events.removeMeshFromRenderer(key);
                    }
                }
                switch (Vis3DToolBar.this.events.getSensorTypeInteraction()) {
                    case ALL: {
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                        break;
                    }
                    case MULTIBEAM: {
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                        break;
                    }
                    case DVL: {
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                        break;
                    }
                }
                Vis3DToolBar.this.canvas.Render();
                Vis3DToolBar.this.canvas.unlock();
            }
            NeptusLog.pub().info((Object)("Sensor representation type: " + Vis3DToolBar.this.events.getSensorTypeInteraction().toString()));
            NeptusLog.pub().info((Object)("Representation type: " + Vis3DToolBar.this.events.getRepresentationType().toString()));
        }
    };
    ActionListener zExaggerToggleAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Vis3DToolBar.this.zExaggerationToggle.isSelected()) {
                Vis3DToolBar.this.canvas.lock();
                if (Vis3DToolBar.this.linkedHashMapCloud.containsKey(Vis3DToolBar.MB_CLOUD_NAME)) {
                    DepthExaggeration.performDepthExaggeration(((APointCloud)Vis3DToolBar.this.linkedHashMapCloud.get(Vis3DToolBar.MB_CLOUD_NAME)).getPolyData(), VtkMRAVis.zExaggeration);
                }
                if (Vis3DToolBar.this.linkedHashMapCloud.containsKey(Vis3DToolBar.DVL_CLOUD_NAME)) {
                    DepthExaggeration.performDepthExaggeration(((APointCloud)Vis3DToolBar.this.linkedHashMapCloud.get(Vis3DToolBar.DVL_CLOUD_NAME)).getPolyData(), VtkMRAVis.zExaggeration);
                }
                Vis3DToolBar.this.canvas.GetRenderer().ResetCamera();
                Vis3DToolBar.this.canvas.Render();
                Vis3DToolBar.this.canvas.unlock();
            } else if (!Vis3DToolBar.this.zExaggerationToggle.isSelected()) {
                Vis3DToolBar.this.canvas.lock();
                if (Vis3DToolBar.this.linkedHashMapCloud.containsKey(Vis3DToolBar.MB_CLOUD_NAME)) {
                    DepthExaggeration.reverseDepthExaggeration(((APointCloud)Vis3DToolBar.this.linkedHashMapCloud.get(Vis3DToolBar.MB_CLOUD_NAME)).getPolyData(), VtkMRAVis.zExaggeration);
                }
                if (Vis3DToolBar.this.linkedHashMapCloud.containsKey(Vis3DToolBar.DVL_CLOUD_NAME)) {
                    DepthExaggeration.reverseDepthExaggeration(((APointCloud)Vis3DToolBar.this.linkedHashMapCloud.get(Vis3DToolBar.DVL_CLOUD_NAME)).getPolyData(), VtkMRAVis.zExaggeration);
                }
                Vis3DToolBar.this.canvas.GetRenderer().ResetCamera();
                Vis3DToolBar.this.canvas.Render();
                Vis3DToolBar.this.canvas.unlock();
            }
        }
    };
    ActionListener contoursToogleAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Vis3DToolBar.this.contoursToggle.isSelected()) {
                switch (Vis3DToolBar.this.events.getSensorTypeInteraction()) {
                    case ALL: {
                        Vis3DToolBar.this.events.performContouring(Vis3DToolBar.MB_CLOUD_NAME);
                        Vis3DToolBar.this.events.performContouring(Vis3DToolBar.DVL_CLOUD_NAME);
                        break;
                    }
                    case DVL: {
                        Vis3DToolBar.this.events.performContouring(Vis3DToolBar.DVL_CLOUD_NAME);
                        break;
                    }
                    case MULTIBEAM: {
                        Vis3DToolBar.this.events.performContouring(Vis3DToolBar.MB_CLOUD_NAME);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                }
            }
        }
    };
    ActionListener meshingAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Vis3DToolBar.this.meshingToggle.isSelected()) {
                Vis3DToolBar.this.canvas.lock();
                Vis3DToolBar.this.events.getTextProcessingActor().SetDisplayPosition(Vis3DToolBar.this.canvas.getWidth() / 3, Vis3DToolBar.this.canvas.getHeight() / 2);
                Vis3DToolBar.this.canvas.GetRenderer().AddActor((vtkProp)Vis3DToolBar.this.events.getTextProcessingActor());
                Vis3DToolBar.this.canvas.Render();
                Vis3DToolBar.this.canvas.unlock();
                Vis3DToolBar.this.canvas.lock();
                if (Vis3DToolBar.this.linkedHashMapCloud.containsKey(Vis3DToolBar.MB_CLOUD_NAME) && !Vis3DToolBar.this.linkedHashMapMesh.containsKey(Vis3DToolBar.MB_CLOUD_NAME)) {
                    Vis3DToolBar.this.events.removeCloudFromRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                    Vis3DToolBar.this.events.performMeshingOnCloud((APointCloud)Vis3DToolBar.this.linkedHashMapCloud.get(Vis3DToolBar.MB_CLOUD_NAME));
                    if (Vis3DToolBar.this.events.getSensorTypeInteraction() == EventsHandler.SensorTypeInteraction.MULTIBEAM || Vis3DToolBar.this.events.getSensorTypeInteraction() == EventsHandler.SensorTypeInteraction.ALL) {
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                    }
                }
                if (Vis3DToolBar.this.linkedHashMapCloud.containsKey(Vis3DToolBar.DVL_CLOUD_NAME) && !Vis3DToolBar.this.linkedHashMapMesh.containsKey(Vis3DToolBar.DVL_CLOUD_NAME)) {
                    Vis3DToolBar.this.events.removeCloudFromRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                    Vis3DToolBar.this.events.performMeshingOnCloud((APointCloud)Vis3DToolBar.this.linkedHashMapCloud.get(Vis3DToolBar.DVL_CLOUD_NAME));
                    if (Vis3DToolBar.this.events.getSensorTypeInteraction() == EventsHandler.SensorTypeInteraction.DVL || Vis3DToolBar.this.events.getSensorTypeInteraction() == EventsHandler.SensorTypeInteraction.ALL) {
                        Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                    }
                }
                Vis3DToolBar.this.canvas.unlock();
                Vis3DToolBar.this.canvas.lock();
                Vis3DToolBar.this.canvas.GetRenderer().RemoveActor((vtkProp)Vis3DToolBar.this.events.getTextProcessingActor());
                Vis3DToolBar.this.canvas.Render();
                Vis3DToolBar.this.canvas.unlock();
            } else {
                Vis3DToolBar.this.meshingToggle.setSelected(true);
            }
        }
    };
    ActionListener smoothingAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Vis3DToolBar.this.meshingToggle.isSelected()) {
                NeptusLog.pub().info((Object)"MeshingToogle is selected");
                if (Vis3DToolBar.this.smoothingMeshToggle.isSelected()) {
                    NeptusLog.pub().info((Object)"smoothingMeshToggle is selected");
                    Vis3DToolBar.this.canvas.lock();
                    Vis3DToolBar.this.events.getTextProcessingActor().SetDisplayPosition(Vis3DToolBar.this.canvas.getWidth() / 3, Vis3DToolBar.this.canvas.getHeight() / 2);
                    Vis3DToolBar.this.canvas.GetRenderer().AddActor((vtkProp)Vis3DToolBar.this.events.getTextProcessingActor());
                    Vis3DToolBar.this.canvas.Render();
                    Vis3DToolBar.this.canvas.unlock();
                    Vis3DToolBar.this.canvas.lock();
                    if (Vis3DToolBar.this.linkedHashMapMesh.containsKey(Vis3DToolBar.MB_CLOUD_NAME)) {
                        Vis3DToolBar.this.events.removeCloudFromRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                        Vis3DToolBar.this.events.removeMeshFromRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                        Vis3DToolBar.this.events.performMeshSmoothing((PointCloudMesh)Vis3DToolBar.this.linkedHashMapMesh.get(Vis3DToolBar.MB_CLOUD_NAME));
                        if (Vis3DToolBar.this.events.getSensorTypeInteraction() == EventsHandler.SensorTypeInteraction.MULTIBEAM || Vis3DToolBar.this.events.getSensorTypeInteraction() == EventsHandler.SensorTypeInteraction.ALL) {
                            Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.MB_CLOUD_NAME);
                        }
                    }
                    if (Vis3DToolBar.this.linkedHashMapMesh.containsKey(Vis3DToolBar.DVL_CLOUD_NAME)) {
                        Vis3DToolBar.this.events.removeCloudFromRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                        Vis3DToolBar.this.events.removeMeshFromRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                        Vis3DToolBar.this.events.performMeshSmoothing((PointCloudMesh)Vis3DToolBar.this.linkedHashMapMesh.get(Vis3DToolBar.DVL_CLOUD_NAME));
                        if (Vis3DToolBar.this.events.getSensorTypeInteraction() == EventsHandler.SensorTypeInteraction.DVL || Vis3DToolBar.this.events.getSensorTypeInteraction() == EventsHandler.SensorTypeInteraction.ALL) {
                            Vis3DToolBar.this.events.addActorToRenderer(Vis3DToolBar.DVL_CLOUD_NAME);
                        }
                    }
                    Vis3DToolBar.this.canvas.unlock();
                    Vis3DToolBar.this.canvas.lock();
                    Vis3DToolBar.this.canvas.GetRenderer().RemoveActor((vtkProp)Vis3DToolBar.this.events.getTextProcessingActor());
                    Vis3DToolBar.this.canvas.Render();
                    Vis3DToolBar.this.canvas.unlock();
                }
            } else {
                Vis3DToolBar.this.smoothingMeshToggle.setSelected(false);
            }
        }
    };
    ActionListener resetViewportAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Vis3DToolBar.this.events.resetViewport();
        }
    };

    private Vis3DToolBar() {
    }

    public Vis3DToolBar(VtkMRAVis vtkInit) {
        this.vtkInit = vtkInit;
        this.canvas = vtkInit.getCanvas();
        this.events = vtkInit.getEvents();
        this.linkedHashMapCloud = vtkInit.getLinkedHashMapCloud();
        this.linkedHashMapMesh = vtkInit.getLinkedHashMapMesh();
    }

    public void createToolBar() {
        this.setOrientation(1);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder()));
        this.multibeamToggle = new JToggleButton();
        this.multibeamToggle.setToolTipText(I18n.text((String)"See Multibeam data") + ".");
        this.multibeamToggle.setIcon(ICON_MULTIBEAM);
        this.dvlToggle = new JToggleButton();
        this.dvlToggle.setToolTipText(I18n.text((String)"See DVL data") + ".");
        this.dvlToggle.setIcon(ICON_DVL);
        this.rawPointsToggle = new JToggleButton();
        this.rawPointsToggle.setToolTipText(I18n.text((String)"Points based representation") + ".");
        this.rawPointsToggle.setIcon(ICON_POINTS);
        this.wireframeToggle = new JToggleButton();
        this.wireframeToggle.setToolTipText(I18n.text((String)"Wireframe based representation") + ".");
        this.wireframeToggle.setIcon(ICON_WIREFRAME);
        this.solidToggle = new JToggleButton();
        this.solidToggle.setToolTipText(I18n.text((String)"Solid based representation") + ".");
        this.solidToggle.setIcon(ICON_SOLID);
        ButtonGroup groupRepresentationType = new ButtonGroup();
        groupRepresentationType.add(this.rawPointsToggle);
        groupRepresentationType.add(this.wireframeToggle);
        groupRepresentationType.add(this.solidToggle);
        this.zExaggerationToggle = new JToggleButton();
        this.zExaggerationToggle.setToolTipText(I18n.text((String)"Exaggerate Z") + ".");
        this.zExaggerationToggle.setIcon(ICON_Z);
        this.contoursToggle = new JToggleButton();
        this.contoursToggle.setToolTipText(I18n.text((String)"Enable/Disable contouts") + ".");
        this.contoursToggle.setIcon(ICON_CONTOURS);
        this.meshingToggle = new JToggleButton();
        this.meshingToggle.setToolTipText(I18n.text((String)"Perform meshing on pointcloud") + ".");
        this.meshingToggle.setIcon(ICON_MESHING);
        this.smoothingMeshToggle = new JToggleButton();
        this.smoothingMeshToggle.setToolTipText(I18n.text((String)"Perform mesh smoothing") + ".");
        this.smoothingMeshToggle.setIcon(ICON_SMOOTHING);
        this.resetViewportButton = new JButton();
        this.resetViewportButton.setToolTipText(I18n.text((String)"Reset Viewport") + ".");
        this.resetViewportButton.setIcon(ICON_RESETVIEWPORT);
        this.multibeamToggle.addActionListener(this.sensorTypeInteracActionMutibeam);
        this.dvlToggle.addActionListener(this.sensorTypeInteracActionDVL);
        this.rawPointsToggle.addActionListener(this.renderRepresentationTypeAction);
        this.wireframeToggle.addActionListener(this.renderRepresentationTypeAction);
        this.solidToggle.addActionListener(this.renderRepresentationTypeAction);
        this.zExaggerationToggle.addActionListener(this.zExaggerToggleAction);
        this.contoursToggle.addActionListener(this.contoursToogleAction);
        this.meshingToggle.addActionListener(this.meshingAction);
        this.smoothingMeshToggle.addActionListener(this.smoothingAction);
        this.resetViewportButton.addActionListener(this.resetViewportAction);
        this.rawPointsToggle.setSelected(true);
        this.add(this.multibeamToggle);
        this.add(this.dvlToggle);
        this.addSeparator();
        this.add(this.rawPointsToggle);
        this.add(this.wireframeToggle);
        this.add(this.solidToggle);
        this.addSeparator();
        this.add(this.zExaggerationToggle);
        this.addSeparator();
        this.add(this.meshingToggle);
        this.add(this.smoothingMeshToggle);
        this.addSeparator();
        this.add(this.resetViewportButton);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D graphic2d = (Graphics2D)g;
        Color color1 = this.getBackground();
        Color color2 = Color.GRAY;
        GradientPaint gradPaint = new GradientPaint(0.0f, 0.0f, color1, this.getWidth(), this.getHeight(), color2);
        graphic2d.setPaint(gradPaint);
        graphic2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public static void main(String[] args) {
        Vis3DToolBar toolbar = new Vis3DToolBar();
        toolbar.createToolBar();
        GuiUtils.testFrame((JComponent)toolbar, (String)("Test toolbar: " + toolbar.getClass().getSimpleName()), (int)43, (int)554);
    }
}

