/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.mravisualizer;

import java.util.LinkedHashMap;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.plugins.vtk.mravisualizer.InteractorStyleVis3D;
import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import pt.lsts.neptus.plugins.vtk.surface.PointCloudMesh;
import pt.lsts.neptus.plugins.vtk.visualization.AWindow;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import vtk.vtkInteractorObserver;
import vtk.vtkPanel;
import vtk.vtkRenderWindowInteractor;

public class Window
extends AWindow {
    private InteractorStyleVis3D interacStyle;
    private LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud;
    private LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh;

    public Window(vtkPanel panel, InteractorStyleVis3D interactorStyle, LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud, LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh, IMraLogGroup source, String windowName) {
        super(panel, windowName);
        this.setRenderer(panel.GetRenderer());
        this.setRenWin(panel.GetRenderWindow());
        this.setInteracStyle(interactorStyle);
        this.setRenWinInteractor(panel.GetRenderWindow().GetInteractor());
        this.setLinkedHashMapCloud(linkedHashMapCloud);
        this.setLinkedHashMapMesh(linkedHashMapMesh);
        this.setSource(source);
        this.setUpRenderer();
        this.setUpRenWin();
        this.setUpRenWinInteractor();
        this.setUpInteractorStyle();
    }

    public Window(vtkPanel panel, InteractorStyleVis3D interactorStyle, LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud, LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh, IMraLogGroup source) {
        this(panel, interactorStyle, linkedHashMapCloud, linkedHashMapMesh, source, I18n.text((String)"Visualizer3D"));
    }

    public Window(Canvas canvas, InteractorStyleVis3D interactorStyle, LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud, LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh, IMraLogGroup source, String windowName) {
        super(canvas, windowName);
        this.setRenderer(canvas.GetRenderer());
        this.setRenWin(canvas.GetRenderWindow());
        this.setInteracStyle(interactorStyle);
        this.setRenWinInteractor((vtkRenderWindowInteractor)canvas.getRenderWindowInteractor());
        this.setLinkedHashMapCloud(linkedHashMapCloud);
        this.setLinkedHashMapMesh(linkedHashMapMesh);
        this.setSource(source);
        this.setUpRenderer();
        this.setUpRenWin();
        this.setUpRenWinInteractor();
        this.setUpInteractorStyle();
    }

    public Window(Canvas canvas, InteractorStyleVis3D interactorStyle, LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud, LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh, IMraLogGroup source) {
        this(canvas, interactorStyle, linkedHashMapCloud, linkedHashMapMesh, source, I18n.text((String)"Visualizer3D"));
    }

    @Override
    public void setUpRenderer() {
        this.getRenderer().SetGradientBackground(true);
        this.getRenderer().SetBackground(0.0, 0.0, 0.0);
        this.getRenderer().SetBackground2(0.3, 0.7, 1.0);
    }

    @Override
    public void setUpRenWin() {
        this.getRenWin().SetWindowName(this.getWindowName());
        this.getRenWin().AlphaBitPlanesOff();
        this.getRenWin().PointSmoothingOff();
        this.getRenWin().LineSmoothingOff();
        this.getRenWin().SwapBuffersOn();
        this.getRenWin().SetStereoTypeToAnaglyph();
    }

    @Override
    public void setUpRenWinInteractor() {
        this.getRenWinInteractor().SetRenderWindow(this.getRenWin());
        this.getRenWinInteractor().SetDesiredUpdateRate(30.0);
    }

    @Override
    public void setUpInteractorStyle() {
        this.setInteracStyle(new InteractorStyleVis3D(this.getCanvas(), this.getRenderer(), this.getRenWinInteractor(), this.getLinkedHashMapCloud(), this.getLinkedHashMapMesh(), this.getSource()));
        this.getRenWinInteractor().SetInteractorStyle((vtkInteractorObserver)this.getInteracStyle());
    }

    public InteractorStyleVis3D getInteracStyle() {
        return this.interacStyle;
    }

    private void setInteracStyle(InteractorStyleVis3D interacStyle) {
        this.interacStyle = interacStyle;
    }

    public LinkedHashMap<String, APointCloud<?>> getLinkedHashMapCloud() {
        return this.linkedHashMapCloud;
    }

    private void setLinkedHashMapCloud(LinkedHashMap<String, APointCloud<?>> linkedHashMapCloud) {
        this.linkedHashMapCloud = linkedHashMapCloud;
    }

    public LinkedHashMap<String, PointCloudMesh> getLinkedHashMapMesh() {
        return this.linkedHashMapMesh;
    }

    private void setLinkedHashMapMesh(LinkedHashMap<String, PointCloudMesh> linkedHashMapMesh) {
        this.linkedHashMapMesh = linkedHashMapMesh;
    }
}

