/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.pointcloud;

import pt.lsts.neptus.plugins.vtk.pointcloud.IPointCloudHandler;
import pt.lsts.neptus.plugins.vtk.pointtypes.APoint;
import vtk.vtkLODActor;
import vtk.vtkPoints;
import vtk.vtkPolyData;

public abstract class APointCloud<T extends APoint> {
    private String cloudName;
    private vtkPoints xyzPoints;
    private vtkPolyData polyData;
    private vtkLODActor cloudLODActor;
    private int numberOfPoints;
    private int memorySize;
    private double[] bounds;
    private IPointCloudHandler colorHandler;

    public APointCloud(String name) {
        this.setXYZPoints(new vtkPoints());
        this.setPolyData(new vtkPolyData());
        this.setCloudLODActor(new vtkLODActor());
        this.setBounds(new double[6]);
    }

    public APointCloud() {
        this("pointcloud");
    }

    public abstract T getPointAtIndex(int var1);

    public abstract void addPoint(T var1);

    public abstract void addPointAtIndex(T var1, int var2);

    public abstract void createActorFromPoints();

    public abstract void generateHandler();

    public String toString() {
        String info = this.getClass().getSimpleName() + "\n";
        info = info + this.getXYZPoints().Print();
        info = info + this.getXYZPoints().Print();
        return info;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public void setCloudName(String cloudName) {
        this.cloudName = cloudName;
    }

    public vtkPoints getXYZPoints() {
        return this.xyzPoints;
    }

    public void setXYZPoints(vtkPoints xyzPoints) {
        this.xyzPoints = xyzPoints;
    }

    public vtkPolyData getPolyData() {
        return this.polyData;
    }

    public void setPolyData(vtkPolyData polyData) {
        this.polyData = polyData;
    }

    public vtkLODActor getCloudLODActor() {
        return this.cloudLODActor;
    }

    public void setCloudLODActor(vtkLODActor cloudLODActor) {
        this.cloudLODActor = cloudLODActor;
    }

    public int getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public void setNumberOfPoints(int numberOfPoints) {
        this.numberOfPoints = numberOfPoints;
    }

    public double[] getBounds() {
        return this.bounds;
    }

    public void setBounds(double[] bounds) {
        this.bounds = bounds;
    }

    public IPointCloudHandler getColorHandler() {
        return this.colorHandler;
    }

    public void setColorHandler(IPointCloudHandler colorHandler) {
        this.colorHandler = colorHandler;
    }

    public int getMemorySize() {
        return this.memorySize;
    }

    public void setMemorySize(int memorySize) {
        this.memorySize = memorySize;
    }
}

