/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.pointcloud;

import vtk.vtkCellArray;
import vtk.vtkPoints;
import vtk.vtkPolyData;

public class DepthExaggeration {
    public static void performDepthExaggeration(vtkPolyData polyData, int zExaggeration) {
        try {
            int numberOfPoints = polyData.GetNumberOfPoints();
            polyData.GetPoints().FastDelete();
            polyData.GetVerts().FastDelete();
            vtkCellArray verts = new vtkCellArray();
            vtkPoints points = new vtkPoints();
            for (int i = 0; i < numberOfPoints; ++i) {
                double[] p = polyData.GetPoint(i);
                p[2] = p[2] * (double)zExaggeration;
                verts.InsertNextCell(1);
                verts.InsertCellPoint(points.InsertNextPoint(p));
            }
            polyData.SetPoints(points);
            polyData.SetVerts(verts);
            polyData.Modified();
            polyData.Update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reverseDepthExaggeration(vtkPolyData polyData, int zExaggeration) {
        try {
            int numberOfPoints = polyData.GetNumberOfPoints();
            polyData.GetPoints().FastDelete();
            polyData.GetVerts().FastDelete();
            vtkCellArray verts = new vtkCellArray();
            vtkPoints points = new vtkPoints();
            for (int i = 0; i < numberOfPoints; ++i) {
                double[] p = polyData.GetPoint(i);
                p[2] = p[2] / (double)zExaggeration;
                verts.InsertNextCell(1);
                verts.InsertCellPoint(points.InsertNextPoint(p));
            }
            polyData.SetPoints(points);
            polyData.SetVerts(verts);
            polyData.Modified();
            polyData.Update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

