/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.pointcloud;

import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudHandlerCTD;
import pt.lsts.neptus.plugins.vtk.pointtypes.PointXYZCTD;
import vtk.vtkDataObject;
import vtk.vtkDoubleArray;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkVertexGlyphFilter;

public class PointCloudCTD
extends APointCloud<PointXYZCTD> {
    private vtkDoubleArray temperatures;
    private vtkDoubleArray salinities;
    private vtkDoubleArray pressures;

    @Override
    public PointXYZCTD getPointAtIndex(int index) {
        if (this.getXYZPoints().GetNumberOfPoints() > index) {
            double[] p = this.getXYZPoints().GetPoint(index);
            double t = this.getTemperatures().GetValue(index);
            double s = this.getSalinities().GetValue(index);
            double pr = this.getPressures().GetValue(index);
            return new PointXYZCTD(p[0], p[1], p[2], s, t, pr);
        }
        return null;
    }

    @Override
    public void addPoint(PointXYZCTD p) {
        this.getXYZPoints().InsertNextPoint(p.getX(), p.getY(), p.getZ());
        int tempSize = this.getTemperatures().GetSize();
        this.getTemperatures().InsertValue(tempSize, p.getTemperature());
        int salSize = this.getSalinities().GetSize();
        this.getSalinities().InsertValue(salSize, p.getSalinity());
        int preSize = this.getPressures().GetSize();
        this.getPressures().InsertValue(preSize, p.getPressure());
    }

    @Override
    public void addPointAtIndex(PointXYZCTD p, int index) {
        this.getXYZPoints().InsertPoint(index, p.getX(), p.getY(), p.getZ());
        this.getTemperatures().InsertValue(index, p.getTemperature());
        this.getSalinities().InsertValue(index, p.getSalinity());
        this.getPressures().InsertValue(index, p.getPressure());
    }

    @Override
    public void createActorFromPoints() {
        try {
            this.getXYZPoints().Squeeze();
            this.getXYZPoints().Modified();
            this.getPolyData().Allocate(this.getNumberOfPoints(), this.getNumberOfPoints());
            this.getPolyData().SetPoints(this.getXYZPoints());
            vtkVertexGlyphFilter vertex = new vtkVertexGlyphFilter();
            vertex.AddInput((vtkDataObject)this.getPolyData());
            vertex.Update();
            this.getPolyData().ShallowCopy((vtkDataObject)vertex.GetOutput());
            this.getPolyData().Squeeze();
            this.getPolyData().Update();
            this.setBounds(this.getPolyData().GetBounds());
            vtkPolyDataMapper mapper = new vtkPolyDataMapper();
            mapper.SetInputConnection(this.getPolyData().GetProducerPort());
            this.getCloudLODActor().SetMapper((vtkMapper)mapper);
            this.getCloudLODActor().GetProperty().SetPointSize(10.0);
            this.getCloudLODActor().GetProperty().SetRepresentationToPoints();
            this.setMemorySize(mapper.GetInput().GetActualMemorySize());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void generateHandler() {
        this.setColorHandler(new PointCloudHandlerCTD(this));
        this.getColorHandler().generatePointCloudColors(true);
    }

    public vtkDoubleArray getTemperatures() {
        return this.temperatures;
    }

    public void setTemperatures(vtkDoubleArray temperatures) {
        this.temperatures = temperatures;
    }

    public vtkDoubleArray getSalinities() {
        return this.salinities;
    }

    public void setSalinities(vtkDoubleArray salinities) {
        this.salinities = salinities;
    }

    public vtkDoubleArray getPressures() {
        return this.pressures;
    }

    public void setPressures(vtkDoubleArray pressures) {
        this.pressures = pressures;
    }
}

