/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.pointcloud;

import pt.lsts.neptus.plugins.vtk.pointcloud.IPointCloudHandler;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudCTD;
import vtk.vtkDoubleArray;
import vtk.vtkLookupTable;
import vtk.vtkUnsignedCharArray;

public class PointCloudHandlerCTD
implements IPointCloudHandler {
    private final PointCloudCTD pointCloud;
    private final vtkDoubleArray temperatureArray;
    private final vtkDoubleArray salinityArray;
    private final vtkDoubleArray pressureArray;
    private vtkUnsignedCharArray colorsTemperature;
    private vtkUnsignedCharArray colorsSalinity;
    private vtkUnsignedCharArray colorsPressure;
    private vtkLookupTable lutTemperature;
    private vtkLookupTable lutSalinity;
    private vtkLookupTable lutPressure;

    public PointCloudHandlerCTD(PointCloudCTD pointCloud) {
        this.pointCloud = pointCloud;
        this.temperatureArray = pointCloud.getTemperatures();
        this.salinityArray = pointCloud.getSalinities();
        this.pressureArray = pointCloud.getPressures();
        this.setColorsTemperature(new vtkUnsignedCharArray());
        this.setColorsSalinity(new vtkUnsignedCharArray());
        this.setColorsPressure(new vtkUnsignedCharArray());
        this.setLutTemperature(new vtkLookupTable());
        this.setLutSalinity(new vtkLookupTable());
        this.setLutPressure(new vtkLookupTable());
    }

    @Override
    public void generatePointCloudColors(boolean isColorInverted) {
        if (!isColorInverted) {
            this.getLutTemperature().SetRange(this.temperatureArray.GetRange());
            this.getLutTemperature().SetScaleToLinear();
            this.getLutTemperature().Build();
            this.getLutSalinity().SetRange(this.salinityArray.GetRange());
            this.getLutSalinity().SetScaleToLinear();
            this.getLutSalinity().Build();
            this.getLutPressure().SetRange(this.pressureArray.GetRange());
            this.getLutPressure().SetScaleToLinear();
            this.getLutPressure().Build();
        } else {
            this.invertLUTTableColors();
        }
        this.getColorsTemperature().SetNumberOfComponents(3);
        this.getColorsTemperature().SetName("colorsTemp");
        this.getColorsSalinity().SetNumberOfComponents(3);
        this.getColorsSalinity().SetName("colorsSalinity");
        this.getColorsPressure().SetNumberOfComponents(3);
        this.getColorsPressure().SetName("colorsPressure");
        for (int i = 0; i < this.pointCloud.getNumberOfPoints(); ++i) {
            double temperature = this.temperatureArray.GetValue(i);
            double salinity = this.salinityArray.GetValue(i);
            double pressure = this.pressureArray.GetValue(i);
            double[] tempColor = new double[3];
            double[] salColor = new double[3];
            double[] pressColor = new double[3];
            this.lutTemperature.GetColor(temperature, tempColor);
            this.lutSalinity.GetColor(salinity, salColor);
            this.lutPressure.GetColor(pressure, pressColor);
            char[] colorTemp = new char[3];
            char[] colorSalinity = new char[3];
            char[] colorPressure = new char[3];
            for (int j = 0; j < 3; ++j) {
                colorTemp[j] = (char)(255.0 * tempColor[j]);
                colorSalinity[j] = (char)(255.0 * salColor[j]);
                colorPressure[j] = (char)(255.0 * pressColor[j]);
            }
            this.getColorsTemperature().InsertNextTuple3((double)colorTemp[0], (double)colorTemp[1], (double)colorTemp[2]);
            this.getColorsSalinity().InsertNextTuple3((double)colorSalinity[0], (double)colorSalinity[1], (double)colorSalinity[2]);
            this.getColorsPressure().InsertNextTuple3((double)colorPressure[0], (double)colorPressure[1], (double)colorPressure[2]);
        }
    }

    @Override
    public void invertLUTTableColors() {
        vtkLookupTable look1 = new vtkLookupTable();
        look1.SetRange(this.temperatureArray.GetRange());
        look1.SetScaleToLinear();
        look1.Build();
        this.lutTemperature.SetRange(this.temperatureArray.GetRange());
        for (int i = 1; i <= 256; ++i) {
            this.lutTemperature.SetTableValue(256 - i, look1.GetTableValue(i));
        }
        this.lutTemperature.Build();
        vtkLookupTable look2 = new vtkLookupTable();
        look2.SetRange(this.salinityArray.GetRange());
        look2.SetScaleToLinear();
        look2.Build();
        this.lutSalinity.SetRange(this.salinityArray.GetRange());
        for (int i = 1; i <= 256; ++i) {
            this.lutSalinity.SetTableValue(256 - i, look2.GetTableValue(i));
        }
        this.lutSalinity.Build();
        vtkLookupTable look3 = new vtkLookupTable();
        look3.SetRange(this.pressureArray.GetRange());
        look3.SetScaleToLinear();
        look3.Build();
        this.lutPressure.SetRange(this.pressureArray.GetRange());
        for (int i = 1; i <= 256; ++i) {
            this.lutPressure.SetTableValue(256 - i, look3.GetTableValue(i));
        }
        this.lutPressure.Build();
    }

    public vtkLookupTable getLutTemperature() {
        return this.lutTemperature;
    }

    public void setLutTemperature(vtkLookupTable lutTemperature) {
        this.lutTemperature = lutTemperature;
    }

    public vtkLookupTable getLutSalinity() {
        return this.lutSalinity;
    }

    public void setLutSalinity(vtkLookupTable lutSalinity) {
        this.lutSalinity = lutSalinity;
    }

    public vtkLookupTable getLutPressure() {
        return this.lutPressure;
    }

    public void setLutPressure(vtkLookupTable lutPressure) {
        this.lutPressure = lutPressure;
    }

    public vtkUnsignedCharArray getColorsTemperature() {
        return this.colorsTemperature;
    }

    private void setColorsTemperature(vtkUnsignedCharArray colorsTemperature) {
        this.colorsTemperature = colorsTemperature;
    }

    public vtkUnsignedCharArray getColorsSalinity() {
        return this.colorsSalinity;
    }

    private void setColorsSalinity(vtkUnsignedCharArray colorsSalinity) {
        this.colorsSalinity = colorsSalinity;
    }

    public vtkUnsignedCharArray getColorsPressure() {
        return this.colorsPressure;
    }

    private void setColorsPressure(vtkUnsignedCharArray colorsPressure) {
        this.colorsPressure = colorsPressure;
    }
}

