/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.pointcloud;

import pt.lsts.neptus.plugins.vtk.pointcloud.IPointCloudHandler;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudHandlerXYZ;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudXYZI;
import vtk.vtkLookupTable;
import vtk.vtkPolyData;
import vtk.vtkUnsignedCharArray;

public class PointCloudHandlerXYZI
extends PointCloudHandlerXYZ
implements IPointCloudHandler {
    private vtkUnsignedCharArray colorsI;
    private vtkLookupTable lutI;
    private final PointCloudXYZI pointCloud;
    private final vtkPolyData polyData;
    private final double[] bounds;

    public PointCloudHandlerXYZI(PointCloudXYZI pointCloud) {
        this.setLutI(new vtkLookupTable());
        this.pointCloud = pointCloud;
        this.polyData = pointCloud.getPolyData();
        this.bounds = pointCloud.getBounds();
    }

    @Override
    public void generatePointCloudColors(boolean isColorInverted) {
        if (!isColorInverted) {
            this.getLutX().SetRange(this.bounds[0], this.bounds[1]);
            this.getLutX().SetScaleToLinear();
            this.getLutX().Build();
            this.getLutY().SetRange(this.bounds[2], this.bounds[3]);
            this.getLutY().SetScaleToLinear();
            this.getLutY().Build();
            this.getLutZ().SetRange(this.bounds[4], this.bounds[5]);
            this.getLutZ().SetScaleToLinear();
            this.getLutZ().Build();
            this.getLutI().SetRange(this.pointCloud.getIntensities().GetRange());
            this.getLutI().SetScaleToLinear();
            this.getLutI().Build();
        } else {
            this.invertLUTTableColors();
        }
        this.getColorsX().SetNumberOfComponents(3);
        this.getColorsY().SetNumberOfComponents(3);
        this.getColorsZ().SetNumberOfComponents(3);
        this.getColorsI().SetNumberOfComponents(3);
        this.getColorsX().SetName("colorsX");
        this.getColorsY().SetName("colorsY");
        this.getColorsZ().SetName("colorsZ");
        this.getColorsI().SetName("colorsI");
        for (int i = 0; i < this.polyData.GetNumberOfPoints(); ++i) {
            double[] point = new double[3];
            this.polyData.GetPoint(i, point);
            double[] xDColor = new double[3];
            double[] yDColor = new double[3];
            double[] zDColor = new double[3];
            this.getLutX().GetColor(point[0], xDColor);
            this.getLutY().GetColor(point[1], yDColor);
            this.getLutZ().GetColor(point[2], zDColor);
            char[] colorx = new char[3];
            char[] colory = new char[3];
            char[] colorz = new char[3];
            for (int j = 0; j < 3; ++j) {
                colorx[j] = (char)(255.0 * xDColor[j]);
                colory[j] = (char)(255.0 * yDColor[j]);
                colorz[j] = (char)(255.0 * zDColor[j]);
            }
            this.getColorsX().InsertNextTuple3((double)colorx[0], (double)colorx[1], (double)colorx[2]);
            this.getColorsY().InsertNextTuple3((double)colory[0], (double)colory[1], (double)colory[2]);
            this.getColorsZ().InsertNextTuple3((double)colorz[0], (double)colorz[1], (double)colorz[2]);
        }
    }

    @Override
    public void invertLUTTableColors() {
        vtkLookupTable look1 = new vtkLookupTable();
        look1.SetRange(this.bounds[0], this.bounds[1]);
        look1.SetScaleToLinear();
        look1.Build();
        this.getLutX().SetRange(this.bounds[0], this.bounds[1]);
        for (int i = 1; i <= 256; ++i) {
            this.getLutX().SetTableValue(256 - i, look1.GetTableValue(i));
        }
        this.getLutX().Build();
        vtkLookupTable look2 = new vtkLookupTable();
        look2.SetRange(this.bounds[2], this.bounds[3]);
        look2.SetScaleToLinear();
        look2.Build();
        this.getLutY().SetRange(this.bounds[2], this.bounds[3]);
        for (int i = 1; i <= 256; ++i) {
            this.getLutY().SetTableValue(256 - i, look2.GetTableValue(i));
        }
        this.getLutY().Build();
        vtkLookupTable look3 = new vtkLookupTable();
        look3.SetRange(this.bounds[4], this.bounds[5]);
        for (int i = 1; i <= 256; ++i) {
            this.getLutZ().SetTableValue(256 - i, look3.GetTableValue(i));
        }
        this.getLutZ().Build();
        vtkLookupTable look4 = new vtkLookupTable();
        look4.SetRange(this.pointCloud.getIntensities().GetRange());
        for (int i = 1; i <= 256; ++i) {
            this.getLutI().SetTableValue(256 - i, look4.GetTableValue(i));
        }
        this.getLutI().Build();
    }

    public vtkUnsignedCharArray getColorsI() {
        return this.colorsI;
    }

    protected void setColorsI(vtkUnsignedCharArray colorsI) {
        this.colorsI = colorsI;
    }

    public vtkLookupTable getLutI() {
        return this.lutI;
    }

    protected void setLutI(vtkLookupTable lutI) {
        this.lutI = lutI;
    }
}

