/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.pointcloud;

import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import pt.lsts.neptus.plugins.vtk.pointcloud.PointCloudHandlerXYZ;
import pt.lsts.neptus.plugins.vtk.pointtypes.PointXYZ;
import vtk.vtkDataObject;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkVertexGlyphFilter;

public class PointCloudXYZ
extends APointCloud<PointXYZ> {
    @Override
    public PointXYZ getPointAtIndex(int index) {
        if (this.getXYZPoints().GetNumberOfPoints() > index) {
            double[] p = this.getXYZPoints().GetPoint(index);
            return new PointXYZ(p[0], p[1], p[2]);
        }
        return null;
    }

    @Override
    public void addPoint(PointXYZ p) {
        this.getXYZPoints().InsertNextPoint(p.getX(), p.getY(), p.getZ());
    }

    @Override
    public void addPointAtIndex(PointXYZ p, int index) {
        this.getXYZPoints().InsertPoint(index, p.getX(), p.getY(), p.getZ());
    }

    @Override
    public void createActorFromPoints() {
        try {
            this.getXYZPoints().Squeeze();
            this.getXYZPoints().Modified();
            this.getPolyData().Allocate(this.getNumberOfPoints(), this.getNumberOfPoints());
            this.getPolyData().SetPoints(this.getXYZPoints());
            vtkVertexGlyphFilter vertex = new vtkVertexGlyphFilter();
            vertex.AddInput((vtkDataObject)this.getPolyData());
            vertex.Update();
            this.getPolyData().ShallowCopy((vtkDataObject)vertex.GetOutput());
            this.getPolyData().Squeeze();
            this.getPolyData().Update();
            this.setBounds(this.getPolyData().GetBounds());
            vtkPolyDataMapper mapper = new vtkPolyDataMapper();
            mapper.SetInputConnection(this.getPolyData().GetProducerPort());
            this.getCloudLODActor().SetMapper((vtkMapper)mapper);
            this.getCloudLODActor().GetProperty().SetPointSize(1.0);
            this.getCloudLODActor().GetProperty().SetRepresentationToPoints();
            this.setMemorySize(mapper.GetInput().GetActualMemorySize());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void generateHandler() {
        this.setColorHandler(new PointCloudHandlerXYZ(this));
        this.getColorHandler().generatePointCloudColors(false);
    }
}

