/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.pointcloud;

import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import pt.lsts.neptus.plugins.vtk.pointtypes.PointXYZI;
import vtk.vtkIntArray;

public class PointCloudXYZI
extends APointCloud<PointXYZI> {
    private vtkIntArray intensities;

    @Override
    public PointXYZI getPointAtIndex(int index) {
        if (this.getXYZPoints().GetNumberOfPoints() > index) {
            double[] p = this.getXYZPoints().GetPoint(index);
            int intens = this.getIntensities().GetValue(index);
            return new PointXYZI(p[0], p[1], p[2], intens);
        }
        return null;
    }

    @Override
    public void addPoint(PointXYZI p) {
        this.getXYZPoints().InsertNextPoint(p.getX(), p.getY(), p.getZ());
        int intSize = this.getIntensities().GetSize();
        this.getIntensities().InsertValue(intSize, p.getIntensity());
    }

    @Override
    public void addPointAtIndex(PointXYZI p, int index) {
        this.getXYZPoints().InsertPoint(index, p.getX(), p.getY(), p.getZ());
        this.getIntensities().InsertValue(index, p.getIntensity());
    }

    @Override
    public void createActorFromPoints() {
    }

    @Override
    public void generateHandler() {
    }

    public vtkIntArray getIntensities() {
        return this.intensities;
    }

    public void setIntensities(vtkIntArray intensities) {
        this.intensities = intensities;
    }
}

