/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.surface;

import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import vtk.vtkActor;
import vtk.vtkCleanPolyData;
import vtk.vtkDataSetMapper;
import vtk.vtkDelaunay3D;
import vtk.vtkMapper;

public class Delauny3D {
    public APointCloud<?> pointCloud;
    private vtkActor delaunyActor;

    public Delauny3D(APointCloud<?> pointCloud) {
        this.pointCloud = pointCloud;
    }

    public void performDelauny() {
        vtkCleanPolyData cleaner = new vtkCleanPolyData();
        cleaner.SetInputConnection(this.pointCloud.getPolyData().GetProducerPort());
        cleaner.Update();
        vtkDelaunay3D delauny3D = new vtkDelaunay3D();
        delauny3D.SetInputConnection(cleaner.GetOutputPort());
        delauny3D.SetTolerance(0.5);
        delauny3D.Update();
        vtkDataSetMapper delaunyMapper = new vtkDataSetMapper();
        delaunyMapper.SetInputConnection(delauny3D.GetOutputPort());
        this.setDelaunyActor(new vtkActor());
        this.getDelaunyActor().SetMapper((vtkMapper)delaunyMapper);
    }

    public vtkActor getDelaunyActor() {
        return this.delaunyActor;
    }

    public void setDelaunyActor(vtkActor delaunyActor) {
        this.delaunyActor = delaunyActor;
    }
}

