/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.surface;

import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import vtk.vtkActor;
import vtk.vtkContourFilter;
import vtk.vtkDataObject;
import vtk.vtkGaussianSplatter;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;

public class GaussianSplat {
    private final APointCloud<?> pointCloud;
    private vtkActor actorGaussianSplat;

    public GaussianSplat(APointCloud<?> pointCloud) {
        this.pointCloud = pointCloud;
        this.setActorGaussianSplat(new vtkActor());
    }

    public void performGaussianSplat(int dim0, int dim1, int dim2, double radius) {
        vtkGaussianSplatter splatter = new vtkGaussianSplatter();
        splatter.SetInput((vtkDataObject)this.pointCloud.getPolyData());
        splatter.SetSampleDimensions(dim0, dim1, dim2);
        splatter.SetRadius(radius);
        splatter.ScalarWarpingOff();
        vtkContourFilter surface = new vtkContourFilter();
        surface.SetInputConnection(splatter.GetOutputPort());
        surface.SetValue(0, 0.2);
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputConnection(surface.GetOutputPort());
        this.actorGaussianSplat.SetMapper((vtkMapper)mapper);
    }

    public vtkActor getActorGaussianSplat() {
        return this.actorGaussianSplat;
    }

    private void setActorGaussianSplat(vtkActor actorGaussianSplat) {
        this.actorGaussianSplat = actorGaussianSplat;
    }
}

