/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.surface;

import pt.lsts.neptus.plugins.vtk.surface.PointCloudMesh;
import vtk.vtkDataObject;
import vtk.vtkPolyData;
import vtk.vtkSmoothPolyDataFilter;

public class MeshSmoothingLaplacian {
    private vtkPolyData polyData;
    private int numIterations = 40;
    private float convergence = 0.0f;
    private float relaxationFactor = 0.08f;
    private boolean featureEdgeSmoothing = false;
    private float featureAngle = 90.0f;
    private float edgeAngle = 5.0f;
    private boolean boundarySmoothing = false;

    public MeshSmoothingLaplacian() {
    }

    public MeshSmoothingLaplacian(int numIterations, float convergence, boolean featureEdgeSmoothing, float featureAngle, float edgeAngle, boolean boundarySmoothing) {
        this.setNumIterations(numIterations);
        this.setConvergence(convergence);
        this.setFeatureEdgeSmoothing(featureEdgeSmoothing);
        this.setFeatureAngle(featureAngle);
        this.setEdgeAngle(edgeAngle);
        this.setBoundarySmoothing(boundarySmoothing);
    }

    public void performProcessing(PointCloudMesh mesh) {
        try {
            vtkSmoothPolyDataFilter smoother = new vtkSmoothPolyDataFilter();
            smoother.SetInput((vtkDataObject)mesh.getPolyData());
            smoother.SetNumberOfIterations(this.numIterations);
            if (this.convergence != 0.0f) {
                smoother.SetConvergence((double)this.convergence);
            }
            smoother.SetRelaxationFactor((double)this.relaxationFactor);
            if (!this.featureEdgeSmoothing) {
                smoother.FeatureEdgeSmoothingOff();
            } else {
                smoother.FeatureEdgeSmoothingOn();
            }
            smoother.SetFeatureAngle((double)this.featureAngle);
            smoother.SetEdgeAngle((double)this.edgeAngle);
            if (this.boundarySmoothing) {
                smoother.BoundarySmoothingOn();
            } else {
                smoother.BoundarySmoothingOff();
            }
            this.setPolyData(smoother.GetOutput());
            this.getPolyData().Update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public float getConvergence() {
        return this.convergence;
    }

    public void setConvergence(float convergence) {
        this.convergence = convergence;
    }

    public float getRelaxationFactor() {
        return this.relaxationFactor;
    }

    public void setRelaxationFactor(float relaxationFactor) {
        this.relaxationFactor = relaxationFactor;
    }

    public boolean isFeatureEdgeSmoothing() {
        return this.featureEdgeSmoothing;
    }

    public void setFeatureEdgeSmoothing(boolean featureEdgeSmoothing) {
        this.featureEdgeSmoothing = featureEdgeSmoothing;
    }

    public float getFeatureAngle() {
        return this.featureAngle;
    }

    public void setFeatureAngle(float featureAngle) {
        this.featureAngle = featureAngle;
    }

    public float getEdgeAngle() {
        return this.edgeAngle;
    }

    public void setEdgeAngle(float edgeAngle) {
        this.edgeAngle = edgeAngle;
    }

    public boolean isBoundarySmoothing() {
        return this.boundarySmoothing;
    }

    public void setBoundarySmoothing(boolean boundarySmoothing) {
        this.boundarySmoothing = boundarySmoothing;
    }

    public vtkPolyData getPolyData() {
        return this.polyData;
    }

    public void setPolyData(vtkPolyData polyData) {
        this.polyData = polyData;
    }
}

