/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.surface;

import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.vtk.surface.PointCloudMesh;
import vtk.vtkDataObject;
import vtk.vtkLODActor;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkWindowedSincPolyDataFilter;

public class MeshSmoothingWindowedSinc {
    private int numIterations = 20;
    private float passBand = 0.1f;
    private boolean featureEdgeSmoothing = false;
    private float featureAngle = 45.0f;
    private float edgeAngle = 15.0f;
    private boolean boundarySmoothing = true;
    private boolean normalizeCoordinates = false;

    public void performProcessing(PointCloudMesh mesh) {
        try {
            NeptusLog.pub().info((Object)("Smoothing Windowed Sinc time start: " + System.currentTimeMillis()));
            vtkWindowedSincPolyDataFilter smoother = new vtkWindowedSincPolyDataFilter();
            smoother.SetInput((vtkDataObject)mesh.getPolyData());
            smoother.SetNumberOfIterations(this.numIterations);
            smoother.SetPassBand((double)this.passBand);
            if (!this.normalizeCoordinates) {
                smoother.NormalizeCoordinatesOff();
            } else {
                smoother.NormalizeCoordinatesOn();
            }
            if (!this.featureEdgeSmoothing) {
                smoother.FeatureEdgeSmoothingOff();
            } else {
                smoother.FeatureEdgeSmoothingOn();
            }
            smoother.SetFeatureAngle((double)this.featureAngle);
            smoother.SetEdgeAngle((double)this.edgeAngle);
            if (this.boundarySmoothing) {
                smoother.BoundarySmoothingOn();
            } else {
                smoother.BoundarySmoothingOff();
            }
            mesh.setPolyData(smoother.GetOutput());
            mesh.getPolyData().Update();
            vtkPolyDataMapper mapper = new vtkPolyDataMapper();
            mapper.SetInputConnection(mesh.getPolyData().GetProducerPort());
            mapper.Update();
            mesh.setMeshCloudLODActor(new vtkLODActor());
            mesh.getMeshCloudLODActor().SetMapper((vtkMapper)mapper);
            mesh.getMeshCloudLODActor().Modified();
            NeptusLog.pub().info((Object)("Smoothing Windowed Sinc time end: " + System.currentTimeMillis()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public float getPassBand() {
        return this.passBand;
    }

    public void setPassBand(float passBand) {
        this.passBand = passBand;
    }

    public boolean isFeatureEdgeSmoothing() {
        return this.featureEdgeSmoothing;
    }

    public void setFeatureEdgeSmoothing(boolean featureEdgeSmoothing) {
        this.featureEdgeSmoothing = featureEdgeSmoothing;
    }

    public float getFeatureAngle() {
        return this.featureAngle;
    }

    public void setFeatureAngle(float featureAngle) {
        this.featureAngle = featureAngle;
    }

    public float getEdgeAngle() {
        return this.edgeAngle;
    }

    public void setEdgeAngle(float edgeAngle) {
        this.edgeAngle = edgeAngle;
    }

    public boolean isBoundarySmoothing() {
        return this.boundarySmoothing;
    }

    public void setBoundarySmoothing(boolean boundarySmoothing) {
        this.boundarySmoothing = boundarySmoothing;
    }

    public boolean isNormalizeCoordinates() {
        return this.normalizeCoordinates;
    }

    public void setNormalizeCoordinates(boolean normalizeCoordinates) {
        this.normalizeCoordinates = normalizeCoordinates;
    }
}

