/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.surface;

import pt.lsts.neptus.NeptusLog;
import vtk.vtkButterflySubdivisionFilter;
import vtk.vtkDataObject;
import vtk.vtkLinearSubdivisionFilter;
import vtk.vtkLoopSubdivisionFilter;
import vtk.vtkPolyData;

public class MeshSubdivision {
    private MeshSubdivisionFilterType filterType = MeshSubdivisionFilterType.LINEAR;
    private vtkPolyData polyDataSubdivided = new vtkPolyData();

    public void performProcessing(vtkPolyData polyData) {
        vtkLinearSubdivisionFilter subdivisionFilter = null;
        switch (this.filterType) {
            case LINEAR: {
                subdivisionFilter = new vtkLinearSubdivisionFilter();
                break;
            }
            case LOOP: {
                subdivisionFilter = new vtkLoopSubdivisionFilter();
                break;
            }
            case BUTTERFLY: {
                subdivisionFilter = new vtkButterflySubdivisionFilter();
                break;
            }
            default: {
                NeptusLog.pub().error((Object)"MeshSubdivion: Invalid filter selection");
            }
        }
        subdivisionFilter.SetInput((vtkDataObject)polyData);
        subdivisionFilter.Update();
        this.polyDataSubdivided = subdivisionFilter.GetOutput();
    }

    public MeshSubdivisionFilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(MeshSubdivisionFilterType filterType) {
        this.filterType = filterType;
    }

    public vtkPolyData getPolyDataSubdivided() {
        return this.polyDataSubdivided;
    }

    protected void setPolyDataSubdivided(vtkPolyData polyDataSubdivided) {
        this.polyDataSubdivided = polyDataSubdivided;
    }

    public static enum MeshSubdivisionFilterType {
        LINEAR,
        LOOP,
        BUTTERFLY;

    }
}

