/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.surface;

import pt.lsts.neptus.plugins.vtk.filters.Contours;
import vtk.vtkLODActor;
import vtk.vtkMapper;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;

public class PointCloudMesh {
    private vtkPolyData polyData;
    private vtkLODActor meshCloudLODActor;
    private Contours contours;

    public PointCloudMesh() {
        this.setPolyData(new vtkPolyData());
        this.setMeshCloudLODActor(new vtkLODActor());
        this.setContours(new Contours(this));
    }

    public void generateLODActorFromPolyData(vtkPolyData polyData) {
        this.setPolyData(new vtkPolyData());
        this.setPolyData(polyData);
        this.getPolyData().Update();
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        mapper.SetInputConnection(this.getPolyData().GetProducerPort());
        mapper.Update();
        this.setMeshCloudLODActor(new vtkLODActor());
        this.getMeshCloudLODActor().SetMapper((vtkMapper)mapper);
        this.getMeshCloudLODActor().Modified();
    }

    public vtkLODActor getMeshCloudLODActor() {
        return this.meshCloudLODActor;
    }

    public void setMeshCloudLODActor(vtkLODActor meshCloudLODActor) {
        this.meshCloudLODActor = meshCloudLODActor;
    }

    public vtkPolyData getPolyData() {
        return this.polyData;
    }

    public void setPolyData(vtkPolyData polyData) {
        this.polyData = polyData;
    }

    public Contours getContours() {
        return this.contours;
    }

    public void setContours(Contours contours) {
        this.contours = contours;
    }
}

