/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.utils;

import java.io.File;
import pt.lsts.neptus.util.FileUtil;

public class File3DUtils {
    public static final String[] TYPES_3D_FILES = new String[]{"xyz", "wrl", "stl", "ply", "obj", "vtk", "3ds", "x3d"};

    public static String getExtension(File f) {
        String ext = FileUtil.getFileExtension((File)f);
        return ext.isEmpty() ? null : ext;
    }

    public static FileType getFileType(String ext) {
        FileType type = null;
        int index = 0;
        for (String f : TYPES_3D_FILES) {
            if (f.equals(ext)) break;
            ++index;
        }
        switch (index) {
            case 0: {
                type = FileType.XYZ;
                break;
            }
            case 1: {
                type = FileType.WRL;
                break;
            }
            case 2: {
                type = FileType.STL;
                break;
            }
            case 3: {
                type = FileType.PLY;
                break;
            }
            case 4: {
                type = FileType.OBJ;
                break;
            }
            case 5: {
                type = FileType.ThreeDS;
                break;
            }
            case 6: {
                type = FileType.X3D;
                break;
            }
            case 7: {
                type = FileType.VTK;
            }
        }
        return type;
    }

    public static enum FileType {
        XYZ,
        WRL,
        STL,
        PLY,
        OBJ,
        ThreeDS,
        X3D,
        VTK;

    }
}

