/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Calendar;

public class MultibeamDeltaTHeader {
    ByteBuffer buf;
    String fileType;
    byte fileVersion;
    short numberBytesPing;
    byte intensity;
    String systemDate;
    String systemTime;
    String systemTimeHundredsSeconds;
    long timeStamp;
    Calendar cal;
    String gnssShipPosLat;
    String gnssShipPosLong;
    float gnssShipSpeedKnots;
    float gnssShipSpeedMS;
    float gnssShipHeading;
    float pitchAngle;
    float rollAngle;
    float headingAngle;
    short numberBeams;
    short numberSamplesPerBeam;
    short sectorSize;
    float startAngle;
    float angleIncrement;
    short acousticRange;
    short acousticFrequency;
    float soundVelocity;
    short rangeResolution;
    short pulseLength;
    float profileTiltAngle;
    short repetitionRate;
    int pingNumber;
    float sonarXOffset;
    float sonarYOffset;
    float sonarZOffset;
    String miliseconds;
    short pingLatency;
    short dataLatency;
    byte sampleRate;
    byte optionFlags;
    byte numberOfPingsAveraged;
    short centerPingtimeOffSet;
    float heave;
    byte userDefinedByte;
    float altitude;
    byte externalSensorFlags;
    float externalPitchAngle;
    float externalRollAngle;
    float externalHeadingAngle;
    byte transmitScanFlag;
    float transmitScanAngle;

    public MultibeamDeltaTHeader(ByteBuffer buf) {
        this.buf = buf;
    }

    public void parseHeader() {
        this.fileType = this.parseFileType();
        this.fileVersion = this.buf.get(3);
        this.numberBytesPing = this.buf.getShort(4);
        this.intensity = this.buf.get(117);
        this.buf.position(8);
        this.systemDate = this.parseSystemDate();
        this.systemTime = this.parseSystemTime();
        this.systemTimeHundredsSeconds = this.parseTimeHundredsSeconds();
        this.gnssShipPosLat = this.parsePositionLatitude();
        this.gnssShipPosLong = this.parsePositionLongitude();
        this.gnssShipSpeedKnots = (float)this.buf.get(61) / 10.0f;
        this.gnssShipSpeedMS = this.convertKnotsToMetersPerSecond(this.gnssShipSpeedKnots);
        this.gnssShipHeading = (float)this.buf.getShort(62) * 10.0f;
        this.pitchAngle = this.parsePitchAngle();
        this.rollAngle = this.parseRollAngle();
        this.headingAngle = this.parseHeadingAngle();
        this.numberBeams = this.buf.getShort(70);
        this.numberSamplesPerBeam = this.buf.getShort(72);
        this.sectorSize = this.buf.getShort(74);
        this.startAngle = (float)this.buf.getShort(76) / 100.0f - 180.0f;
        this.angleIncrement = (float)this.buf.get(78) / 100.0f;
        this.acousticRange = this.buf.getShort(79);
        this.acousticFrequency = this.buf.getShort(81);
        this.soundVelocity = this.parseSoundVelocity();
        this.rangeResolution = this.buf.getShort(85);
        this.pulseLength = this.buf.getShort(87);
        this.profileTiltAngle = (float)this.buf.getShort(89) + 180.0f;
        this.repetitionRate = this.buf.getShort(91);
        this.pingNumber = this.buf.getInt(93);
        this.sonarXOffset = this.buf.getFloat(100);
        this.sonarYOffset = this.buf.getFloat(104);
        this.sonarZOffset = this.buf.getFloat(108);
        this.miliseconds = this.parseMiliseconds();
        this.pingLatency = this.buf.getShort(118);
        this.dataLatency = this.buf.getShort(120);
        this.sampleRate = this.buf.get(122);
        this.optionFlags = this.buf.get(123);
        this.numberOfPingsAveraged = this.buf.get(125);
        this.centerPingtimeOffSet = this.buf.getShort(126);
        this.heave = this.buf.getFloat(128);
        this.userDefinedByte = this.buf.get(132);
        this.altitude = this.buf.getFloat(133);
    }

    private String parseMiliseconds() {
        this.buf.position(112);
        byte[] milisbuf = new byte[5];
        this.buf.get(milisbuf, 0, 5);
        return new String(milisbuf);
    }

    private float convertKnotsToMetersPerSecond(float gnssShipSpeedKnots2) {
        return gnssShipSpeedKnots2 * 0.51444f;
    }

    private float parseSoundVelocity() {
        byte vel83 = this.buf.get(83);
        byte vel84 = this.buf.get(84);
        if (!MultibeamDeltaTHeader.isBitSet(vel83, 7).booleanValue()) {
            return 1500.0f;
        }
        float vel = (float)((double)((vel83 & 0x7F) << 8 | vel84) / 10.0);
        return vel;
    }

    private float parseHeadingAngle() {
        byte heading68 = this.buf.get(68);
        if (!MultibeamDeltaTHeader.isBitSet(heading68, 7).booleanValue()) {
            return 0.0f;
        }
        byte heading69 = this.buf.get(69);
        float heading = (float)((heading68 & 0x7F) << 8 | heading69) / 10.0f;
        return heading;
    }

    private float parseRollAngle() {
        byte roll66 = this.buf.get(66);
        if (!MultibeamDeltaTHeader.isBitSet(roll66, 7).booleanValue()) {
            return 0.0f;
        }
        byte roll67 = this.buf.get(67);
        float roll = ((float)(roll66 & 0x7F00 | roll67) - 900.0f) / 10.0f;
        return roll;
    }

    private float parsePitchAngle() {
        byte pitch64 = this.buf.get(64);
        if (!MultibeamDeltaTHeader.isBitSet(pitch64, 7).booleanValue()) {
            return 0.0f;
        }
        byte pitch65 = this.buf.get(65);
        float pitchf = (float)((pitch64 & 0x7F) << 8 | pitch65) / 10.0f;
        return pitchf;
    }

    private String parsePositionLongitude() {
        byte[] posLongBuf = new byte[14];
        this.buf.get(posLongBuf, 0, 14);
        String posLong = new String(posLongBuf);
        return posLong;
    }

    private String parsePositionLatitude() {
        byte[] posLatBuf = new byte[14];
        this.buf.get(posLatBuf, 0, 14);
        String posLat = new String(posLatBuf);
        return posLat;
    }

    private String parseTimeHundredsSeconds() {
        byte[] systemTimeBuf = new byte[4];
        this.buf.get(systemTimeBuf, 0, 4);
        String systemTimeHundredsSeconds = new String(systemTimeBuf);
        return systemTimeHundredsSeconds;
    }

    private String parseSystemTime() {
        byte[] systemTimeBuf = new byte[9];
        this.buf.get(systemTimeBuf, 0, 9);
        String systemTime = new String(systemTimeBuf);
        return systemTime;
    }

    private String parseSystemDate() {
        byte[] systemDateBuf = new byte[12];
        this.buf.get(systemDateBuf, 0, 12);
        String systemDate = new String(systemDateBuf);
        return systemDate;
    }

    private String parseFileType() {
        byte[] byteBuf = new byte[]{this.buf.get(0), this.buf.get(1), this.buf.get(2)};
        String fileTypeStr = null;
        try {
            fileTypeStr = new String(byteBuf, 0, byteBuf.length, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return fileTypeStr;
    }

    private static Boolean isBitSet(byte b, int bit) {
        return (b & 1 << bit) != 0;
    }

    protected void printDeltaTHeaderInfo() {
        System.out.println("File Type: " + this.fileType);
        System.out.println("File Version: " + this.fileVersion);
        System.out.println("Number of bytes for this ping N: " + this.numberBytesPing);
        System.out.println("Intensity 0 = No, 1 = Yes: " + this.intensity);
        System.out.println("System Date: " + this.systemDate);
        System.out.println("System Time: " + this.systemTime);
        System.out.println("System Time Hundreds seconds: " + this.systemTimeHundredsSeconds);
        System.out.println("GNSS AUV Position Latitude: " + this.gnssShipPosLat);
        System.out.println("GNSS AUV Position Longitude: " + this.gnssShipPosLong);
        System.out.println("GNSS AUV Speed: " + this.gnssShipSpeedKnots + " knots");
        System.out.println("GNSS AUV Speed: " + this.gnssShipSpeedMS + " m/s");
        System.out.println("GNSS AUV Course/Heading: " + this.gnssShipHeading);
        System.out.println("Pitch Angle: " + this.pitchAngle);
        System.out.println("Roll Angle: " + this.rollAngle);
        System.out.println("Heading Angle: " + this.headingAngle);
        System.out.println("Number of beams: " + this.numberBeams);
        System.out.println("Number Samples Per Beam: " + this.numberSamplesPerBeam);
        System.out.println("Sector Size: " + this.sectorSize);
        System.out.println("Start angle: " + this.startAngle);
        System.out.println("Angle Increment: " + this.angleIncrement);
        System.out.println("Acoustic Range: " + this.acousticRange);
        System.out.println("Acoustic Frequency: " + this.acousticFrequency + " kHz");
        System.out.println("Sound Velocity: " + this.soundVelocity + " m/s");
        System.out.println("Range Resolution: " + this.rangeResolution + " (mm)");
        System.out.println("Pulse Length: " + this.pulseLength + " microseconds");
        System.out.println("Profile tilt angle: " + this.profileTiltAngle);
        System.out.println("Repetition rate: " + this.repetitionRate + " miliseconds");
        System.out.println("Ping Number: " + this.pingNumber);
        System.out.println("Sonar X-Offset: " + this.sonarXOffset + " m");
        System.out.println("Sonar Y-Offset: " + this.sonarYOffset + " m");
        System.out.println("Sonar Z-Offset: " + this.sonarZOffset + " m");
        System.out.println("Miliseconds: " + this.miliseconds);
        System.out.println("Ping Latency (in units of 100 microseconds): " + this.pingLatency);
        System.out.println("Data Latency (in units of 100 microseconds): " + this.dataLatency);
        System.out.println("Sample Rate: " + this.sampleRate);
        System.out.println("Option flags: " + this.optionFlags);
        System.out.println("Number of Pings Averaged: " + this.numberOfPingsAveraged);
        System.out.println("Center Ping Time Offset (in units of 100 microseconds): " + this.centerPingtimeOffSet);
        System.out.println("Heave: " + this.heave + " meters");
        System.out.println("User defined Byte: " + this.userDefinedByte);
        System.out.println("Altitude: " + this.altitude);
    }
}

