/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.utils;

import pt.lsts.neptus.plugins.vtk.pointcloud.APointCloud;
import vtk.vtkDataArray;
import vtk.vtkPoints;

public class PointCloudUtils {
    protected static double[] center;

    public static double[] computeBounds(vtkPoints points) {
        double[] bounds = new double[6];
        double[] p = points.GetPoint(0);
        bounds[0] = bounds[1] = p[0];
        bounds[2] = bounds[3] = p[1];
        bounds[4] = bounds[5] = p[2];
        for (int i = 1; i < points.GetNumberOfPoints(); ++i) {
            p = points.GetPoint(i);
            for (int j = 0; j < 3; ++j) {
                if (p[j] < bounds[2 * j]) {
                    bounds[2 * j] = p[j];
                }
                if (!(p[j] > bounds[2 * j + 1])) continue;
                bounds[2 * j + 1] = p[j];
            }
        }
        return bounds;
    }

    public static double[] computeBounds(APointCloud<?> pointCloud) {
        double[] bounds = new double[6];
        double[] p = pointCloud.getXYZPoints().GetPoint(0);
        bounds[0] = bounds[1] = p[0];
        bounds[2] = bounds[3] = p[1];
        bounds[4] = bounds[5] = p[2];
        for (int i = 1; i < pointCloud.getNumberOfPoints(); ++i) {
            p = pointCloud.getXYZPoints().GetPoint(i);
            for (int j = 0; j < 3; ++j) {
                if (p[j] < bounds[2 * j]) {
                    bounds[2 * j] = p[j];
                }
                if (!(p[j] > bounds[2 * j + 1])) continue;
                bounds[2 * j + 1] = p[j];
            }
        }
        return bounds;
    }

    public static double[] computeScalarRange(APointCloud<?> pointCloud) {
        double[] scalarRange = new double[2];
        return scalarRange;
    }

    public static double[] computeScalarRange(vtkDataArray scalars) {
        double[] scalarRange = new double[2];
        return scalarRange;
    }

    public static double[] computeCenter(APointCloud<?> pointCloud) {
        double[] center = new double[3];
        double[] bounds = PointCloudUtils.computeBounds(pointCloud);
        for (int i = 0; i < 3; ++i) {
            center[i] = (bounds[i * 2] + bounds[i * 2 + 1]) / 2.0;
        }
        return center;
    }

    public static double[] computeCenter(vtkPoints points) {
        double[] center = new double[3];
        double[] bounds = PointCloudUtils.computeBounds(points);
        for (int i = 0; i < 3; ++i) {
            center[i] = (bounds[i * 2] + bounds[i * 2 + 1]) / 2.0;
        }
        return center;
    }
}

