/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.utils;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mra.NeptusMRA;
import pt.lsts.neptus.plugins.vtk.utils.VTKMemoryManager;
import vtk.vtkCanvas;
import vtk.vtkNativeLibrary;
import vtk.vtkObjectBase;
import vtk.vtkSettings;
import vtk.vtkVersion;

public class Utils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class.getName());
    public static boolean hasTryedToLoadVtkLib = false;

    public static void loadVTKLibraries() {
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable e) {
            NeptusLog.pub().warn((Object)"<###> cannot load jawt lib!");
        }
        try {
            vtkNativeLibrary.COMMON.LoadLibrary();
        }
        catch (Throwable e) {
            NeptusMRA.vtkEnabled = false;
            NeptusLog.pub().warn((Object)"<###> cannot load vtkCommon, skipping...");
        }
        try {
            vtkNativeLibrary.FILTERING.LoadLibrary();
        }
        catch (Throwable e) {
            NeptusMRA.vtkEnabled = false;
            NeptusLog.pub().warn((Object)"<###> cannot load vtkFiltering, skipping...");
        }
        try {
            vtkNativeLibrary.IO.LoadLibrary();
        }
        catch (Throwable e) {
            NeptusMRA.vtkEnabled = false;
            NeptusLog.pub().warn((Object)"<###> cannot load vtkImaging, skipping...");
        }
        try {
            vtkNativeLibrary.GRAPHICS.LoadLibrary();
        }
        catch (Throwable e) {
            NeptusMRA.vtkEnabled = false;
            NeptusLog.pub().warn((Object)"<###> cannot load vtkGrahics, skipping...");
        }
        try {
            vtkNativeLibrary.RENDERING.LoadLibrary();
        }
        catch (Throwable e) {
            NeptusMRA.vtkEnabled = false;
            NeptusLog.pub().warn((Object)"<###> cannot load vtkRendering, skipping...");
        }
        try {
            vtkNativeLibrary.INFOVIS.LoadLibrary();
        }
        catch (Throwable e) {
            NeptusMRA.vtkEnabled = false;
            NeptusLog.pub().warn((Object)"<###> cannot load vtkInfoVis, skipping...");
        }
        try {
            vtkNativeLibrary.VIEWS.LoadLibrary();
        }
        catch (Throwable e) {
            NeptusMRA.vtkEnabled = false;
            NeptusLog.pub().warn((Object)"<###> cannot load vtkViews, skipping...");
        }
        try {
            vtkNativeLibrary.WIDGETS.LoadLibrary();
        }
        catch (Throwable e) {
            NeptusMRA.vtkEnabled = false;
            NeptusLog.pub().warn((Object)"<###> cannot load vtkWidgets, skipping...");
        }
        try {
            vtkNativeLibrary.GEOVIS.LoadLibrary();
        }
        catch (Throwable e) {
            NeptusMRA.vtkEnabled = false;
            NeptusLog.pub().warn((Object)"<###> cannot load vtkGeoVis, skipping...");
        }
        try {
            vtkNativeLibrary.CHARTS.LoadLibrary();
        }
        catch (Throwable e) {
            NeptusMRA.vtkEnabled = false;
            NeptusLog.pub().warn((Object)"<###> cannot load vtkCharts, skipping...");
        }
        try {
            vtkNativeLibrary.HYBRID.LoadLibrary();
        }
        catch (Throwable e) {
            NeptusLog.pub().warn((Object)"cannot load vtkHybrid, skipping...");
        }
        try {
            vtkNativeLibrary.VOLUME_RENDERING.LoadLibrary();
        }
        catch (Throwable e) {
            NeptusMRA.vtkEnabled = false;
            NeptusLog.pub().warn((Object)"<###> cannot load vtkVolumeRendering, skipping...");
        }
        if (NeptusMRA.vtkEnabled) {
            NeptusLog.pub().info((Object)("Vtk source version: " + new vtkVersion().GetVTKSourceVersion()));
            NeptusLog.pub().info((Object)("VTK Library Dir (searches for vtk.jar): " + vtkSettings.GetVTKLibraryDir()));
            VTKMemoryManager.GC.SetAutoGarbageCollection(false);
        }
        hasTryedToLoadVtkLib = true;
    }

    public static void goToAWTThread(Runnable runnable) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        } else {
            runnable.run();
        }
    }

    public static void delete(vtkObjectBase o) {
        VTKMemoryManager.delete(o);
    }

    public static vtkCanvas retrieveCanvas(ComponentEvent e) {
        Component c = e.getComponent();
        if (c instanceof vtkCanvas) {
            return (vtkCanvas)c;
        }
        throw new NoSuchElementException("Found " + c.getClass() + " when " + vtkCanvas.class + " expected.");
    }

    public static boolean isMeshCoherent(float[] points, int[] indices) {
        boolean[] flags = new boolean[points.length / 3];
        Arrays.fill(flags, false);
        int i = 0;
        while (i < indices.length) {
            int nb = indices[i];
            if (i + nb >= indices.length) {
                return false;
            }
            for (int j = i + 1; j < i + nb + 1; ++j) {
                if (indices[j] >= points.length) {
                    return false;
                }
                flags[indices[j]] = true;
            }
            i = i + nb + 1;
        }
        for (boolean flag : flags) {
            if (flag) continue;
            return false;
        }
        return true;
    }

    public static boolean intToBoolean(int value) {
        return value != 0;
    }

    public static int booleanToInt(boolean value) {
        return value ? 1 : 0;
    }
}

