/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.utils;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import vtk.vtkJavaGarbageCollector;
import vtk.vtkObject;
import vtk.vtkObjectBase;

public final class VTKMemoryManager {
    private static final Logger LOGGER = Logger.getLogger(VTKMemoryManager.class.getName());
    public static final vtkJavaGarbageCollector GC;
    private static final Method DELETE_ALL_METHOD;
    private static final Object OBJECT_MANAGER;
    private static final Method UNREGISTER_METHOD;
    private static final ConcurrentHashMap<Long, WeakReference<?>> OBJECT_MAP;

    private VTKMemoryManager() {
    }

    public static void deleteAll() {
        try {
            DELETE_ALL_METHOD.invoke(OBJECT_MANAGER, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            LOGGER.log(Level.SEVERE, null, e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            LOGGER.log(Level.SEVERE, null, e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            LOGGER.log(Level.SEVERE, null, e);
        }
    }

    public static void delete(vtkObjectBase o) {
        if (OBJECT_MAP != null) {
            WeakReference<?> ref = OBJECT_MAP.get(o.GetVTKId());
            ref.clear();
        } else {
            try {
                UNREGISTER_METHOD.invoke(OBJECT_MANAGER, o.GetVTKId());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                LOGGER.log(Level.SEVERE, null, e);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                LOGGER.log(Level.SEVERE, null, e);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                LOGGER.log(Level.SEVERE, null, e);
            }
        }
    }

    static {
        vtkJavaGarbageCollector lGC = null;
        Method lDeleteAll = null;
        Method lUnregisterMethod = null;
        Object lObjectManager = null;
        ConcurrentHashMap lObjectMap = null;
        try {
            try {
                Class<?> javaHash = Class.forName("vtk.vtkGlobalJavaHash");
                Field f = javaHash.getDeclaredField("GarbageCollector");
                lGC = (vtkJavaGarbageCollector)f.get(null);
                lDeleteAll = javaHash.getDeclaredMethod("GC", new Class[0]);
                lObjectMap = (ConcurrentHashMap)javaHash.getDeclaredField("PointerToReference").get(null);
            }
            catch (ClassNotFoundException ex) {
                Field f = vtkObject.class.getDeclaredField("JAVA_OBJECT_MANAGER");
                lObjectManager = f.get(null);
                Method m = lObjectManager.getClass().getDeclaredMethod("getAutoGarbageCollector", new Class[0]);
                lGC = (vtkJavaGarbageCollector)m.invoke(lObjectManager, new Object[0]);
                lDeleteAll = lObjectManager.getClass().getDeclaredMethod("deleteAll", new Class[0]);
                lUnregisterMethod = lObjectManager.getClass().getDeclaredMethod("unRegisterJavaObject", Long.class);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.log(Level.SEVERE, null, ex);
        }
        GC = lGC;
        DELETE_ALL_METHOD = lDeleteAll;
        OBJECT_MANAGER = lObjectManager;
        UNREGISTER_METHOD = lUnregisterMethod;
        OBJECT_MAP = lObjectMap;
    }
}

