/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.vtk.visualization;

import pt.lsts.neptus.plugins.vtk.events.MouseEvent;
import pt.lsts.neptus.plugins.vtk.events.PointPickingEvent;
import pt.lsts.neptus.plugins.vtk.visualization.Canvas;
import vtk.vtkInteractorStyleTrackballCamera;
import vtk.vtkProp;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkRenderer;
import vtk.vtkTextActor;

public abstract class AInteractorStyleTrackballCamera
extends vtkInteractorStyleTrackballCamera {
    private Canvas canvas;
    private vtkRenderer renderer;
    private vtkRenderWindowInteractor interactor;
    private vtkTextActor fpsActor;
    private MouseEvent mouseEvent;
    private PointPickingEvent pointPickingEvent;

    public AInteractorStyleTrackballCamera() {
    }

    public AInteractorStyleTrackballCamera(Canvas canvas, vtkRenderer renderer, vtkRenderWindowInteractor interactor) {
        this.setCanvas(canvas);
        this.setRenderer(renderer);
        this.setInteractor(interactor);
        this.setPointPickEvent(new PointPickingEvent(canvas));
        this.setMouseEvent(new MouseEvent(canvas, this.pointPickingEvent));
        this.setFpsActor(new vtkTextActor());
    }

    protected abstract void onInitialize();

    protected void callbackFunctionFPS() {
        double timeInSeconds = this.getRenderer().GetLastRenderTimeInSeconds();
        double fps = 1.0 / timeInSeconds;
        fps = (double)Math.round(fps * 100.0) / 100.0;
        this.getFpsActor().SetInput(String.valueOf(fps));
        this.getFpsActor().GetTextProperty().SetColor(0.0, 1.0, 0.0);
        this.getFpsActor().UseBorderAlignOn();
        this.getFpsActor().SetDisplayPosition(2, 2);
        this.getRenderer().AddActor((vtkProp)this.getFpsActor());
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    protected void setCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    public vtkRenderer getRenderer() {
        return this.renderer;
    }

    protected void setRenderer(vtkRenderer renderer) {
        this.renderer = renderer;
    }

    public vtkRenderWindowInteractor getInteractor() {
        return this.interactor;
    }

    protected void setInteractor(vtkRenderWindowInteractor interactor) {
        this.interactor = interactor;
    }

    protected vtkTextActor getFpsActor() {
        return this.fpsActor;
    }

    protected void setFpsActor(vtkTextActor fpsActor) {
        this.fpsActor = fpsActor;
    }

    protected MouseEvent getMouseEvent() {
        return this.mouseEvent;
    }

    protected void setMouseEvent(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
    }

    protected PointPickingEvent getPointPickingEvent() {
        return this.pointPickingEvent;
    }

    protected void setPointPickEvent(PointPickingEvent pointPickingEvent) {
        this.pointPickingEvent = pointPickingEvent;
    }
}

